/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.tartaros.common.crafting;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import ladysnake.tartaros.common.init.ModItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class CrystallizerRecipes {
    private static final CrystallizerRecipes CRYSTAL_BASE = new CrystallizerRecipes();
    private final Map<ItemStack, ItemStack> crystallizingList = Maps.newHashMap();
    public final Map<Item, Integer> crystalTimeList = new HashMap<Item, Integer>();

    public static CrystallizerRecipes instance() {
        return CRYSTAL_BASE;
    }

    private CrystallizerRecipes() {
        this.addCrystalRecipe(new ItemStack(Blocks.field_150424_aL), new ItemStack(Blocks.field_150385_bj));
        this.addCrystalRecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150359_w), 20);
        this.addCrystalRecipe(new ItemStack(ModItems.ectoplasm), new ItemStack(ModItems.ectoplasma), 400);
    }

    public void addCrystalRecipe(ItemStack input, ItemStack output) {
        this.addCrystalRecipe(input, output, 200);
    }

    public void addCrystalRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getCrystalResult(input) != ItemStack.field_190927_a) {
            FMLLog.info((String)("Ignored crystallizing recipe with conflicting input: " + input + " = " + output), (Object[])new Object[0]);
            return;
        }
        this.crystallizingList.put(input, output);
        this.crystalTimeList.put(input.func_77973_b(), time);
    }

    public ItemStack getCrystalResult(ItemStack input) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.crystallizingList.entrySet()) {
            if (!this.compareItemStacks(input, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getCrystallizingList() {
        return this.crystallizingList;
    }
}

