/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.tartaros.common.handlers;

import java.util.Random;
import ladysnake.tartaros.client.gui.IncorporealOverlay;
import ladysnake.tartaros.common.blocks.IRespawnLocation;
import ladysnake.tartaros.common.capabilities.IIncorporealHandler;
import ladysnake.tartaros.common.capabilities.IncorporealDataHandler;
import ladysnake.tartaros.common.entity.EntityItemWaystone;
import ladysnake.tartaros.common.init.ModBlocks;
import ladysnake.tartaros.common.networkingtest.PacketHandler;
import ladysnake.tartaros.common.networkingtest.SimpleMessage;
import ladysnake.tartaros.common.networkingtest.UpdateMessage;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerCommon {
    private static final Random rand = new Random();
    private static int ticksSinceLastSync = 0;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        IIncorporealHandler playerCorp = IncorporealDataHandler.getHandler((Entity)event.player);
        if (playerCorp.isIncorporeal()) {
            if (++ticksSinceLastSync >= 100) {
                if (Math.floor(event.player.field_70165_t) == 0.0 && Math.floor(event.player.field_70161_v) == 0.0) {
                    playerCorp.setIncorporeal(false, event.player);
                    for (int i = 0; i < 50; ++i) {
                        double motionX = rand.nextGaussian() * 0.02;
                        double motionY = rand.nextGaussian() * 0.02 + 1.0;
                        double motionZ = rand.nextGaussian() * 0.02;
                        ((WorldServer)event.player.field_70170_p).func_180505_a(EnumParticleTypes.CLOUD, false, event.player.field_70165_t + 0.5, event.player.field_70163_u + 1.0, event.player.field_70161_v + 0.5, 1, 0.3, 0.3, 0.3, 0.0, new int[0]);
                    }
                }
                UpdateMessage msg = new UpdateMessage(playerCorp.isIncorporeal());
                PacketHandler.net.sendTo((IMessage)msg, (EntityPlayerMP)event.player);
                ticksSinceLastSync = 0;
            }
            if (event.player.field_71106_cc > 0.0f && rand.nextInt() % 3 == 0) {
                event.player.field_71106_cc -= 1.0f;
            }
            if (rand.nextInt() % 300 == 0) {
                if (event.player.field_71068_ca > 0) {
                    event.player.func_71013_b(1);
                } else {
                    event.player.field_71075_bZ.field_75101_c = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(new ResourceLocation("tartaros", "incorporeal"), (ICapabilityProvider)new IncorporealDataHandler.Provider());
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)event.getEntity();
            ItemStack merc = new ItemStack((Block)ModBlocks.mercurius_waystone);
            if (p.field_71071_by.func_70431_c(merc)) {
                p.field_71071_by.func_70304_b(p.field_71071_by.func_184429_b(merc));
                p.field_70170_p.func_72838_d((Entity)new EntityItemWaystone(p.field_70170_p, p.field_70165_t + 0.5, p.field_70163_u + 1.0, p.field_70161_v + 0.5));
            }
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        if (event.isWasDeath() && !event.getEntityPlayer().func_184812_l_()) {
            event.getEntityPlayer().field_71068_ca = event.getOriginal().field_71068_ca;
            IIncorporealHandler clone = IncorporealDataHandler.getHandler((Entity)event.getEntityPlayer());
            clone.setIncorporeal(true, event.getEntityPlayer());
            SimpleMessage msg = new SimpleMessage(event.getEntityPlayer().func_110124_au().getMostSignificantBits(), event.getEntityPlayer().func_110124_au().getLeastSignificantBits(), true);
            PacketHandler.net.sendToAll((IMessage)msg);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onVisibilityPlayer(PlayerEvent.Visibility event) {
        IIncorporealHandler playerCorp = IncorporealDataHandler.getHandler((Entity)event.getEntityPlayer());
        if (playerCorp.isIncorporeal()) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        IIncorporealHandler playerCorp = IncorporealDataHandler.getHandler((Entity)event.getEntityPlayer());
        if (playerCorp.isIncorporeal() && event.isCancelable() && !(event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof IRespawnLocation)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerAttackEntity(AttackEntityEvent event) {
        IIncorporealHandler playerCorp = IncorporealDataHandler.getHandler((Entity)event.getEntityPlayer());
        if (playerCorp.isIncorporeal() && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityItemPickup(EntityItemPickupEvent event) {
        IIncorporealHandler playerCorp = IncorporealDataHandler.getHandler((Entity)event.getEntityPlayer());
        if (playerCorp.isIncorporeal() && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onEntityRender(RenderLivingEvent.Pre event) {
        IIncorporealHandler playerCorp;
        if (event.getEntity() instanceof EntityPlayer && (playerCorp = IncorporealDataHandler.getHandler((Entity)((EntityPlayer)event.getEntity()))).isIncorporeal()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent event) {
        IIncorporealHandler playerCorp;
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && (playerCorp = IncorporealDataHandler.getHandler((Entity)Minecraft.func_71410_x().field_71439_g)).isIncorporeal()) {
            IncorporealOverlay.renderIncorporealOverlay(event.getResolution());
        }
    }
}

