/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.misc;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import georgetsak.opcraft.entities.gomugomuno.EntityLuffyPistol;
import georgetsak.opcraft.entities.hiehie.EntityIcePhoenix;
import georgetsak.opcraft.entities.hiehie.EntityIceSaber;
import georgetsak.opcraft.entities.meramera.EntityEntei;
import georgetsak.opcraft.entities.meramera.EntityFireFist;
import georgetsak.opcraft.entities.nikyu.EntityUrsusBubble;
import georgetsak.opcraft.entities.noronoro.EntitySlowBeam;
import georgetsak.opcraft.main.CommonProxy;
import georgetsak.opcraft.misc.DamageCalculator;
import georgetsak.opcraft.misc.EntitySlowBeamSpawner;
import georgetsak.opcraft.misc.OPSoundEvent;
import georgetsak.opcraft.misc.generators.GenIceBall;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class OPMessage
implements IMessage {
    private String text;
    private Entity entitySec;

    public OPMessage() {
    }

    public OPMessage(String text) {
        this.text = text;
    }

    public void fromBytes(ByteBuf buf) {
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }

    static void createLightnings(EntityPlayer ep, int repeatTimes, double radius) {
        double x = ep.field_70165_t;
        double y = ep.field_70163_u;
        double z = ep.field_70161_v;
        Random r = new Random();
        for (int i = 0; i < repeatTimes; ++i) {
            double finalX = x + (r.nextDouble() * (radius * 2.0) - radius);
            double finalZ = x + (r.nextDouble() * (radius * 2.0) - radius);
            double finalY = ep.field_70170_p.func_175672_r(new BlockPos(finalX, 255.0, finalZ)).func_177956_o();
            ep.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(ep.field_70170_p, finalX, finalY, finalZ, false));
        }
    }

    static void damageNearbyPlayers(EntityPlayer ep, int range, float damage, float velMul) {
        double x1 = ep.field_70165_t - (double)range;
        double x2 = ep.field_70165_t + (double)range;
        double y1 = ep.field_70163_u - (double)range;
        double y2 = ep.field_70163_u + (double)range;
        double z1 = ep.field_70161_v - (double)range;
        double z2 = ep.field_70161_v + (double)range;
        List entities = ep.field_70170_p.func_72839_b((Entity)ep, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
        for (int i = 0; i < entities.size(); ++i) {
            if (entities.get(i) == null) continue;
            if (entities.get(i) instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)entities.get(i);
                entityPlayer.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ep), DamageCalculator.damageCalculation(entityPlayer, damage));
            } else if (entities.get(i) instanceof EntityLiving) {
                Entity e = (Entity)entities.get(i);
                e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ep), damage);
            }
            if (!(entities.get(i) instanceof EntityLiving) && !(entities.get(i) instanceof EntityPlayer)) continue;
            double distanceX = ((Entity)entities.get((int)i)).field_70165_t - ep.field_70165_t;
            double distanceY = ((Entity)entities.get((int)i)).field_70163_u - ep.field_70163_u;
            double distanceZ = ((Entity)entities.get((int)i)).field_70161_v - ep.field_70161_v;
            double velocityX = (double)range / distanceX * (double)velMul;
            double velocityY = (double)range / distanceY * (double)velMul;
            double velocityZ = (double)range / distanceZ * (double)velMul;
            if (distanceX == 0.0) {
                velocityX = 0.0;
            }
            if (distanceY == 0.0) {
                velocityY = 0.0;
            }
            if (distanceZ == 0.0) {
                velocityZ = 0.0;
            }
            if (velocityX > (double)range) {
                velocityX = range;
            }
            if (velocityX < (double)(-range)) {
                velocityX = -range;
            }
            if (velocityY > (double)range) {
                velocityY = range;
            }
            if (velocityY < (double)(-range)) {
                velocityY = -range;
            }
            if (velocityZ > (double)range) {
                velocityZ = range;
            }
            if (velocityZ < (double)(-range)) {
                velocityZ = -range;
            }
            ((Entity)entities.get(i)).func_70024_g(velocityX, velocityY, velocityZ);
        }
    }

    static void createIceSeaRoad(EnumFacing ef, BlockPos startPoint, EntityPlayer ep) {
        Block roadMat = CommonProxy.IceAgeBlock;
        World world = ep.field_70170_p;
        switch (ef) {
            case EAST: {
                for (int i = 0; i < 200; ++i) {
                    for (int h = -2; h < 2; ++h) {
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(i, h, 0))) {
                            world.func_175656_a(startPoint.func_177982_a(i, h, 0), roadMat.func_176223_P());
                        }
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(i, h, 1))) {
                            world.func_175656_a(startPoint.func_177982_a(i, h, 1), roadMat.func_176223_P());
                        }
                        if (!OPMessage.isBlockWater(ep, startPoint.func_177982_a(i, h, -1))) continue;
                        world.func_175656_a(startPoint.func_177982_a(i, h, -1), roadMat.func_176223_P());
                    }
                }
                break;
            }
            case WEST: {
                for (int i = 0; i < 200; ++i) {
                    for (int h = -2; h < 2; ++h) {
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(-i, h, 0))) {
                            world.func_175656_a(startPoint.func_177982_a(-i, h, 0), roadMat.func_176223_P());
                        }
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(-i, h, 1))) {
                            world.func_175656_a(startPoint.func_177982_a(-i, h, 1), roadMat.func_176223_P());
                        }
                        if (!OPMessage.isBlockWater(ep, startPoint.func_177982_a(-i, h, -1))) continue;
                        world.func_175656_a(startPoint.func_177982_a(-i, h, -1), roadMat.func_176223_P());
                    }
                }
                break;
            }
            case SOUTH: {
                for (int i = 0; i < 200; ++i) {
                    for (int h = -2; h < 2; ++h) {
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(0, h, i))) {
                            world.func_175656_a(startPoint.func_177982_a(0, h, i), roadMat.func_176223_P());
                        }
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(1, h, i))) {
                            world.func_175656_a(startPoint.func_177982_a(1, h, i), roadMat.func_176223_P());
                        }
                        if (!OPMessage.isBlockWater(ep, startPoint.func_177982_a(-1, h, i))) continue;
                        world.func_175656_a(startPoint.func_177982_a(-1, h, i), roadMat.func_176223_P());
                    }
                }
                break;
            }
            case NORTH: {
                for (int i = 0; i < 200; ++i) {
                    for (int h = -2; h < 2; ++h) {
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(0, h, -i))) {
                            world.func_175656_a(startPoint.func_177982_a(0, h, -i), roadMat.func_176223_P());
                        }
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(1, h, -i))) {
                            world.func_175656_a(startPoint.func_177982_a(1, h, -i), roadMat.func_176223_P());
                        }
                        if (!OPMessage.isBlockWater(ep, startPoint.func_177982_a(-1, h, -i))) continue;
                        world.func_175656_a(startPoint.func_177982_a(-1, h, -i), roadMat.func_176223_P());
                    }
                }
                break;
            }
        }
    }

    private static boolean isBlockWater(EntityPlayer ep, BlockPos blockPos) {
        return ep.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150355_j || ep.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150358_i;
    }

    static void createIceCage(EntityPlayer user, Entity target) {
        if (target != null) {
            user.field_70170_p.func_184133_a((EntityPlayer)null, user.func_180425_c(), OPSoundEvent.ice_ball, SoundCategory.NEUTRAL, 20.0f, 1.0f);
            target.field_70170_p.func_184133_a((EntityPlayer)null, target.func_180425_c(), OPSoundEvent.ice_ball, SoundCategory.NEUTRAL, 20.0f, 1.0f);
            if (target instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)target;
                entityPlayer.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 3));
            }
            int posX = (int)target.field_70165_t;
            int posY = (int)target.field_70163_u;
            int posZ = (int)target.field_70161_v;
            GenIceBall gib = new GenIceBall();
            gib.generate(user.field_70170_p, new BlockPos(posX, posY, posZ));
            target.func_70107_b((double)posX + 0.5, (double)posY, (double)posZ + 0.5);
        }
    }

    static Entity findEntity(EntityPlayer ep) {
        int range = 50;
        int partialTicks = 5;
        Entity pointedEntity = null;
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity != null && Minecraft.func_71410_x().field_71441_e != null) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a("pick");
            Minecraft.func_71410_x().field_147125_j = null;
            double d0 = range;
            Minecraft.func_71410_x().field_71476_x = entity.func_174822_a(d0, (float)partialTicks);
            double d1 = d0;
            Vec3d vec3d = entity.func_174824_e((float)partialTicks);
            boolean flag = false;
            if (Minecraft.func_71410_x().field_71442_b.func_78749_i()) {
                d0 = range;
                d1 = range;
            } else if (d0 > (double)range) {
                flag = true;
            }
            if (Minecraft.func_71410_x().field_71476_x != null) {
                d1 = Minecraft.func_71410_x().field_71476_x.field_72307_f.func_72438_d(vec3d);
            }
            Vec3d vec3d1 = entity.func_70676_i((float)partialTicks);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
            pointedEntity = null;
            Vec3d vec3d3 = null;
            float f = 1.0f;
            List list = Minecraft.func_71410_x().field_71441_e.func_175674_a(entity, entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0).func_72314_b((double)f, (double)f, (double)f), Predicates.and((Predicate)EntitySelectors.field_180132_d, p_apply_1_ -> p_apply_1_ != null && p_apply_1_.func_70067_L()));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == entity.func_184208_bv() && !entity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && flag && vec3d.func_72438_d(vec3d3) > (double)range) {
                pointedEntity = null;
                Minecraft.func_71410_x().field_71476_x = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, (EnumFacing)null, new BlockPos(vec3d3));
            }
            if (pointedEntity != null && (d2 < d1 || Minecraft.func_71410_x().field_71476_x == null)) {
                Minecraft.func_71410_x().field_71476_x = new RayTraceResult(pointedEntity, vec3d3);
                if (pointedEntity instanceof EntityLivingBase || pointedEntity instanceof EntityItemFrame) {
                    Minecraft.func_71410_x().field_147125_j = pointedEntity;
                }
            }
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
        if (pointedEntity != null) {
            return ep.field_70170_p.func_73045_a(pointedEntity.func_145782_y());
        }
        return null;
    }

    static void destroyNearbyCropsAndGrass(EntityPlayer ep, int radius) {
        BlockPos playerPos = new BlockPos(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v);
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos = playerPos.func_177982_a(x, y, z);
                    Block blockFound = ep.field_70170_p.func_180495_p(pos).func_177230_c();
                    if (blockFound != Blocks.field_150330_I && blockFound != Blocks.field_150398_cm && blockFound != Blocks.field_150327_N && blockFound != Blocks.field_150328_O && blockFound != Blocks.field_150345_g && blockFound != Blocks.field_150464_aj && blockFound != Blocks.field_150459_bM && blockFound != Blocks.field_150469_bN && blockFound != Blocks.field_185773_cZ && blockFound != Blocks.field_150338_P && blockFound != Blocks.field_150337_Q && blockFound != Blocks.field_150395_bd && blockFound != Blocks.field_150392_bi) continue;
                    ep.field_70170_p.func_175655_b(pos, false);
                }
            }
        }
    }

    static BlockPos findCenterOfDome(EntityPlayer ep) {
        BlockPos DomeCenter = new BlockPos(0, 0, 0);
        boolean foundCenter = false;
        BlockPos center = new BlockPos(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v);
        int x = center.func_177958_n();
        int y = center.func_177956_o();
        int z = center.func_177952_p();
        int radius = 40;
        for (int i = x - radius; i < x + radius; ++i) {
            block1: for (int j = y - radius; j < y + radius; ++j) {
                for (int k = z - radius; k < z + radius; ++k) {
                    if (ep.field_70170_p.func_180495_p(new BlockPos(i, j, k)).func_177230_c() != CommonProxy.LawDomeCenterBlock) continue;
                    foundCenter = true;
                    DomeCenter = new BlockPos(i, j, k);
                    continue block1;
                }
            }
        }
        if (foundCenter) {
            return DomeCenter;
        }
        return null;
    }

    static void OPTakt(EntityPlayer ep) {
        BlockPos DomeCenter = new BlockPos((Vec3i)OPMessage.findCenterOfDome(ep));
        if (DomeCenter != null) {
            Random r = new Random();
            int radius = 6;
            int x = DomeCenter.func_177958_n();
            int y = DomeCenter.func_177956_o();
            int z = DomeCenter.func_177952_p();
            for (int i = x - radius; i < x + radius; ++i) {
                for (int j = y - 4; j < y + 4; ++j) {
                    for (int k = z - radius; k < z + radius; ++k) {
                        Block blockFound = ep.field_70170_p.func_180495_p(new BlockPos(i, j, k)).func_177230_c();
                        if (blockFound == CommonProxy.LawDomeCenterBlock || blockFound == CommonProxy.LawDomeBlock || blockFound == Blocks.field_150350_a || blockFound == Blocks.field_150357_h || blockFound == Blocks.field_150427_aO || blockFound == Blocks.field_185775_db || blockFound == Blocks.field_150384_bq || blockFound == Blocks.field_150378_br || blockFound == Blocks.field_150486_ae || blockFound == Blocks.field_150477_bB || blockFound == Blocks.field_150447_bR || blockFound == Blocks.field_150355_j || blockFound == Blocks.field_150358_i || blockFound == Blocks.field_150353_l || blockFound == Blocks.field_150356_k || blockFound == Blocks.field_150464_aj || blockFound == Blocks.field_150459_bM || blockFound == Blocks.field_150469_bN || blockFound == Blocks.field_150393_bb || blockFound == Blocks.field_150394_bc || blockFound == Blocks.field_150448_aq || blockFound == Blocks.field_150408_cc || blockFound == Blocks.field_150319_E || blockFound == Blocks.field_150318_D || blockFound == Blocks.field_185766_cS || blockFound == Blocks.field_150328_O || blockFound == Blocks.field_150327_N || blockFound == Blocks.field_150338_P || blockFound == Blocks.field_150337_Q || blockFound == Blocks.field_150329_H || blockFound == Blocks.field_150345_g || blockFound == Blocks.field_150488_af || blockFound == Blocks.field_185773_cZ || blockFound == Blocks.field_150398_cm || blockFound == Blocks.field_150473_bD || blockFound == Blocks.field_150479_bC || !OPMessage.canBlockSeeSky(new BlockPos(i, j, k), ep)) continue;
                        ep.field_70170_p.func_175698_g(new BlockPos(i, j, k));
                        EntityFallingBlock entityFallingBlock = new EntityFallingBlock(ep.field_70170_p, (double)i + (double)r.nextInt(radius * 5) - (double)r.nextInt(radius * 5), (double)y + (double)r.nextInt(30), (double)k + (double)r.nextInt(radius * 5) - (double)r.nextInt(radius * 5), blockFound.func_176194_O().func_177621_b());
                        entityFallingBlock.field_145812_b = 2;
                        ep.field_70170_p.func_72838_d((Entity)entityFallingBlock);
                    }
                }
            }
        }
    }

    static boolean canBlockSeeSky(BlockPos blockPos, EntityPlayer ep) {
        int y = blockPos.func_177956_o();
        int x = blockPos.func_177958_n();
        int z = blockPos.func_177952_p();
        for (int i = 256; i > y; --i) {
            if (ep.field_70170_p.func_180495_p(new BlockPos(x, i, z)) == Blocks.field_150350_a.func_176223_P() || ep.field_70170_p.func_180495_p(new BlockPos(x, i, z)) == Blocks.field_150480_ab.func_176223_P() || ep.field_70170_p.func_180495_p(new BlockPos(x, i, z)) == CommonProxy.LawDomeBlock.func_176223_P() || ep.field_70170_p.func_180495_p(new BlockPos(x, i, z)) == CommonProxy.LawDomeCenterBlock.func_176223_P()) continue;
            return false;
        }
        return true;
    }

    static void OPShambles(EntityPlayer ep) {
        BlockPos DomeCenter = new BlockPos((Vec3i)OPMessage.findCenterOfDome(ep));
        if (DomeCenter != null) {
            int tpZ;
            int tpX;
            Random r;
            int i;
            double distance = 19.0;
            double x1 = (double)DomeCenter.func_177958_n() - distance;
            double x2 = (double)DomeCenter.func_177958_n() + distance;
            double y1 = (double)DomeCenter.func_177956_o() - distance;
            double y2 = (double)DomeCenter.func_177956_o() + distance;
            double z1 = (double)DomeCenter.func_177952_p() - distance;
            double z2 = (double)DomeCenter.func_177952_p() + distance;
            List entities = ep.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
            List players = ep.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
            if (!players.isEmpty()) {
                for (i = 0; i < players.size(); ++i) {
                    if (players.get(i) == null || !(players.get(i) instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)players.get(i);
                    r = new Random();
                    tpX = r.nextInt(37);
                    tpZ = r.nextInt(37);
                    if (player == ep) continue;
                    player.func_70107_b(x1 + (double)tpX, (double)player.func_180425_c().func_177956_o(), z1 + (double)tpZ);
                }
            }
            if (!entities.isEmpty()) {
                for (i = 0; i < entities.size(); ++i) {
                    if (entities.get(i) == null || !(entities.get(i) instanceof EntityLiving)) continue;
                    EntityLiving el = (EntityLiving)entities.get(i);
                    r = new Random();
                    tpX = r.nextInt(37);
                    tpZ = r.nextInt(37);
                    el.func_70107_b(x1 + (double)tpX, (double)el.func_180425_c().func_177956_o(), z1 + (double)tpZ);
                }
            }
        }
    }

    static void OPInjectionShot(EntityPlayer ep) {
        BlockPos DomeCenter = new BlockPos((Vec3i)OPMessage.findCenterOfDome(ep));
        if (DomeCenter != null) {
            double z2;
            double distance = 19.0;
            double x1 = (double)DomeCenter.func_177958_n() - distance;
            double x2 = (double)DomeCenter.func_177958_n() + distance;
            double y1 = (double)DomeCenter.func_177956_o() - distance;
            double y2 = (double)DomeCenter.func_177956_o() + distance;
            double z1 = (double)DomeCenter.func_177952_p() - distance;
            List players = ep.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2 = (double)DomeCenter.func_177952_p() + distance));
            if (!players.isEmpty()) {
                for (int i = 0; i < players.size(); ++i) {
                    EntityPlayer player;
                    if (players.get(i) == null || !(players.get(i) instanceof EntityPlayer) || (player = (EntityPlayer)players.get(i)) == ep) continue;
                    ep.func_184595_k(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    player.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ep), DamageCalculator.damageCalculation(player, 8.0f));
                    break;
                }
            }
        }
    }

    public static class Handler
    implements IMessageHandler<OPMessage, IMessage> {
        public IMessage onMessage(final OPMessage message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    RayTraceResult rayTraceResult;
                    Object e;
                    EntityFlying esb;
                    EntityFireFist eff;
                    EntityLuffyPistol elp;
                    EntityPlayerMP ep = ctx.getServerHandler().field_147369_b;
                    if (message.text.contains("GomuPistolA")) {
                        elp = new EntityLuffyPistol(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, false);
                        ep.field_70170_p.func_72838_d((Entity)elp);
                        ep.field_70170_p.func_184148_a((EntityPlayer)null, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, OPSoundEvent.gomu_stretch, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                    }
                    if (message.text.contains("GomuGear2A")) {
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.gomu_gear2, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 1));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 200, 1));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 1));
                        for (int i = 0; i < 50; ++i) {
                            Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_LARGE, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, (Math.random() - 0.5) * 0.2, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.2, new int[0]);
                        }
                    }
                    if (message.text.contains("GomuGear3A")) {
                        elp = new EntityLuffyPistol(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 0.5, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, true);
                        ep.field_70170_p.func_72838_d((Entity)elp);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.gomu_stretch, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                    }
                    if (message.text.contains("GomuGear4A")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 400, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 400, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 400, 2));
                    }
                    if (message.text.contains("MeraHiganA")) {
                        eff = new EntityFireFist(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, 1);
                        ep.field_70170_p.func_72838_d((Entity)eff);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                    }
                    if (message.text.contains("MeraShinkaA")) {
                        ep.field_70170_p.func_72838_d((Entity)new EntityFireFist(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 2.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, 2));
                        ep.field_70170_p.func_72838_d((Entity)new EntityFireFist(ep.field_70170_p, ep.field_70165_t + 0.5, ep.field_70163_u + 0.5 + 2.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, 2));
                        ep.field_70170_p.func_72838_d((Entity)new EntityFireFist(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 0.5 + 2.0, ep.field_70161_v + 1.0, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, 2));
                        ep.field_70170_p.func_72838_d((Entity)new EntityFireFist(ep.field_70170_p, ep.field_70165_t - 0.5, ep.field_70163_u - 0.5 + 2.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, 2));
                        ep.field_70170_p.func_72838_d((Entity)new EntityFireFist(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u - 0.5 + 2.0, ep.field_70161_v - 1.0, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, 2));
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                    }
                    if (message.text.contains("MeraHikenA")) {
                        eff = new EntityFireFist(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, 4);
                        ep.field_70170_p.func_72838_d((Entity)eff);
                    }
                    if (message.text.contains("MeraEnteiA")) {
                        EntityEntei ee = new EntityEntei(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 5.0, ep.field_70161_v, (EntityPlayer)ep);
                        ep.field_70170_p.func_72838_d((Entity)ee);
                        ep.field_70170_p.func_184148_a((EntityPlayer)null, ep.field_70165_t, ep.field_70163_u + 5.0, ep.field_70161_v, OPSoundEvent.entei_charge, SoundCategory.NEUTRAL, 15.0f, 1.0f);
                    }
                    if (message.text.contains("SlowBeamA")) {
                        esb = new EntitySlowBeam(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.slow_beam, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                        ep.field_70170_p.func_72838_d((Entity)esb);
                    }
                    if (message.text.contains("SlowBallA")) {
                        esb = new EntitySlowBeamSpawner(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, true, 60, 10);
                        ep.field_70170_p.func_72838_d((Entity)esb);
                    }
                    if (message.text.contains("SlowMashiA")) {
                        esb = new EntitySlowBeamSpawner(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep, false, 120, 5);
                        ep.field_70170_p.func_72838_d((Entity)esb);
                    }
                    if (message.text.contains("ClearSkatingA")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 500, 0));
                    }
                    if (message.text.contains("RoomA")) {
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.dome_appear, SoundCategory.NEUTRAL, 40.0f, 1.0f);
                        ep.field_70170_p.func_175656_a(new BlockPos(ep.func_180425_c().func_177958_n(), ep.func_180425_c().func_177956_o(), ep.func_180425_c().func_177952_p()), CommonProxy.LawDomeCenterBlock.func_176223_P());
                    }
                    if (message.text.contains("Shambles")) {
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.shambles, SoundCategory.NEUTRAL, 40.0f, 1.0f);
                        OPMessage.OPShambles((EntityPlayer)ep);
                    }
                    if (message.text.contains("InjectionShot")) {
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.shambles, SoundCategory.NEUTRAL, 40.0f, 1.0f);
                        OPMessage.OPInjectionShot((EntityPlayer)ep);
                    }
                    if (message.text.contains("Takt")) {
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.takt, SoundCategory.NEUTRAL, 40.0f, 1.0f);
                        OPMessage.OPTakt((EntityPlayer)ep);
                    }
                    if (message.text.contains("IceSaberA")) {
                        OPMessage.destroyNearbyCropsAndGrass((EntityPlayer)ep, 5);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.ice_saber, SoundCategory.NEUTRAL, 20.0f, 1.0f);
                        e = new EntityIceSaber(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        EntityIceSaber e1 = new EntityIceSaber(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 2.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        EntityIceSaber e2 = new EntityIceSaber(ep.field_70170_p, ep.field_70165_t + 1.0, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        EntityIceSaber e3 = new EntityIceSaber(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v + 1.0, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        EntityIceSaber e4 = new EntityIceSaber(ep.field_70170_p, ep.field_70165_t - 1.0, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        EntityIceSaber e5 = new EntityIceSaber(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v - 1.0, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        ep.field_70170_p.func_72838_d(e);
                        ep.field_70170_p.func_72838_d((Entity)e1);
                        ep.field_70170_p.func_72838_d((Entity)e2);
                        ep.field_70170_p.func_72838_d((Entity)e3);
                        ep.field_70170_p.func_72838_d((Entity)e4);
                        ep.field_70170_p.func_72838_d((Entity)e5);
                    }
                    if (message.text.contains("IceBallA")) {
                        e = OPMessage.findEntity((EntityPlayer)ep);
                        OPMessage.createIceCage((EntityPlayer)ep, e);
                    }
                    if (message.text.contains("IceAgeA")) {
                        OPMessage.createIceSeaRoad(ep.func_174811_aO(), new BlockPos(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v), (EntityPlayer)ep);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.ice_age, SoundCategory.NEUTRAL, 50.0f, 1.0f);
                    }
                    if (message.text.contains("IceBlockPhBeakA")) {
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.ice_phoenix, SoundCategory.NEUTRAL, 20.0f, 1.0f);
                        e = new EntityIcePhoenix(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        ep.field_70170_p.func_72838_d(e);
                    }
                    if (message.text.contains("PadHoA")) {
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.pad_ho, SoundCategory.NEUTRAL, 15.0f, 1.0f);
                        OPMessage.damageNearbyPlayers((EntityPlayer)ep, 15, 6.0f, 0.2f);
                    }
                    if (message.text.contains("TsuppariPadHoA")) {
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.pad_ho, SoundCategory.NEUTRAL, 30.0f, 1.0f);
                        OPMessage.damageNearbyPlayers((EntityPlayer)ep, 30, 12.0f, 0.5f);
                    }
                    if (message.text.contains("UrsusShockA")) {
                        e = new EntityUrsusBubble(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, (EntityPlayer)ep);
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.ursus_shock, SoundCategory.NEUTRAL, 90.0f, 1.0f);
                        ep.field_70170_p.func_72838_d(e);
                    }
                    if (message.text.contains("ElThorA") && (rayTraceResult = ep.func_174822_a(300.0, 1.0f)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                        BlockPos spawnPosition = rayTraceResult.func_178782_a();
                        double x = spawnPosition.func_177958_n();
                        double y = spawnPosition.func_177956_o();
                        double z = spawnPosition.func_177952_p();
                        for (int i = 0; i < 6; ++i) {
                            EntityLightningBolt lightningBolt = new EntityLightningBolt(ep.field_70170_p, x, y, z, false);
                            ep.field_70170_p.func_72942_c((Entity)lightningBolt);
                        }
                    }
                    if (message.text.contains("SangoA")) {
                        OPMessage.createLightnings((EntityPlayer)ep, 150, 80.0);
                    }
                    if (message.text.contains("DeathpieaA")) {
                        OPMessage.createLightnings((EntityPlayer)ep, 400, 100.0);
                    }
                    if (message.text.contains("GomuGear2B")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 1));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 1));
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 3.0f, 1.0f);
                    }
                    if (message.text.contains("GomuGear3B")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 1));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 2));
                    }
                    if (message.text.contains("GomuGear4B")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 340, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 340, 1));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 340, 1));
                        ep.field_70170_p.func_184133_a((EntityPlayer)null, ep.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 3.0f, 1.0f);
                    }
                    if (message.text.contains("MeraShinkaB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 160, 0));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 160, 0));
                    }
                    if (message.text.contains("MeraHikenB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 160, 1));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 160, 1));
                    }
                    if (message.text.contains("MeraEnteiB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 380, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 380, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 380, 0));
                    }
                    if (message.text.contains("SlowBallB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 300, 0));
                    }
                    if (message.text.contains("SlowMashiB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 300, 0));
                    }
                    if (message.text.contains("IceBallB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 0));
                    }
                    if (message.text.contains("IceBlockPhBeakB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 0));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200, 1));
                    }
                    if (message.text.contains("TsuppariPadHoB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 1));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
                    }
                    if (message.text.contains("UrsusShockB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 400, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 400, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 400, 2));
                    }
                    if (message.text.contains("SangoB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 1));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 80, 1));
                    }
                    if (message.text.contains("DeathpieaB")) {
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 300, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 300, 2));
                        ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 300, 2));
                    }
                }
            });
            return null;
        }
    }
}

