/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.misc.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import georgetsak.opcraft.misc.recipes.ShipBuilderRecipes;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ShipBuilderCraftingManager {
    private static final ShipBuilderCraftingManager INSTANCE = new ShipBuilderCraftingManager();
    private final List<IRecipe> recipes = Lists.newArrayList();

    public static ShipBuilderCraftingManager getInstance() {
        return INSTANCE;
    }

    private ShipBuilderCraftingManager() {
    }

    public ShipBuilderRecipes addRecipe(ItemStack stack, Object ... recipeComponents) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = null;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }
            map.put(character, itemstack);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);
            aitemstack[l] = map.containsKey(Character.valueOf(c0)) ? ((ItemStack)map.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShipBuilderRecipes shipBuilderRecipe = new ShipBuilderRecipes(j, k, aitemstack, stack);
        this.recipes.add(shipBuilderRecipe);
        return shipBuilderRecipe;
    }

    public void addRecipe(IRecipe recipe) {
        this.recipes.add(recipe);
    }

    public ItemStack findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : this.recipes) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.func_77572_b(craftMatrix);
        }
        return null;
    }

    public ItemStack[] getRemainingItems(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : this.recipes) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.func_179532_b(craftMatrix);
        }
        ItemStack[] aitemstack = new ItemStack[craftMatrix.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            aitemstack[i] = craftMatrix.func_70301_a(i);
        }
        return aitemstack;
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

