/*
 * Decompiled with CFR 0.152.
 */
package ch.immortal.shaderconfigurator;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;

public class ColoredButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private String name;
    private Color color;

    public ColoredButton(String str, Color color) {
        super(str);
        this.name = str;
        this.color = color;
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(this.color);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(new Color(205, 205, 202));
        g2d.drawString(this.name, this.getWidth() / 2 - g2d.getFontMetrics().stringWidth(this.name) / 2, this.getHeight() / 2 + g2d.getFontMetrics().getHeight() / 2);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 200);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 255);
        this.repaint();
    }
}

