/*
 * Decompiled with CFR 0.152.
 */
package ch.immortal.shaderconfigurator;

import ch.immortal.shaderconfigurator.ColoredButton;
import ch.immortal.shaderconfigurator.ImportationFrame;
import ch.immortal.shaderconfigurator.PanelImage;
import ch.immortal.shaderconfigurator.util.FileFilterZip;
import ch.immortal.shaderconfigurator.util.Function;
import ch.immortal.shaderconfigurator.util.ShaderFile;
import ch.immortal.shaderconfigurator.util.ThreadOpenZip;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;

public class ShaderConfigurator
extends JFrame
implements ActionListener {
    private String copyRightFr = "Si tu vois cette variable, tu es entrain de regarder mon code et tu es dans ton droit. Cependant, \u00e9vite de le voler ;)";
    private String copyRightEn = "If you are seing this variable, you are probably looking at my code et you can do it. However, don't steal it ;)";
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JPanel panelFunctions;
    private PanelImage panelImage;
    private ColoredButton btnImportShader;
    private ColoredButton btnHelp;
    private ColoredButton btnSaveShader;
    private Hashtable<String, JCheckBox> boxes;
    public Hashtable<String, ShaderFile> files;
    private Function functions = new Function();
    private File tmpDir;
    private JTextArea descArea;

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ShaderConfigurator frame = new ShaderConfigurator();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ShaderConfigurator() {
        this.setResizable(false);
        this.setBackground(new Color(34, 35, 37));
        this.setForeground(Color.BLACK);
        this.setTitle("Shaders Configurator");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 934, 599);
        this.contentPane = new JPanel();
        this.contentPane.setBackground(new Color(34, 35, 37));
        this.contentPane.setForeground(Color.BLACK);
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JLabel lblDocteurdreadsShadersConfigurator = new JLabel("Shaders Configurator");
        lblDocteurdreadsShadersConfigurator.setBounds(5, 5, 542, 32);
        lblDocteurdreadsShadersConfigurator.setFont(new Font("Helvetica Neue", 1, 18));
        lblDocteurdreadsShadersConfigurator.setForeground(Color.LIGHT_GRAY);
        this.contentPane.add(lblDocteurdreadsShadersConfigurator);
        JPanel panelButtons = new JPanel();
        panelButtons.setBounds(477, 5, 450, 56);
        panelButtons.setBackground(new Color(34, 35, 37));
        panelButtons.setForeground(new Color(34, 35, 37));
        this.contentPane.add(panelButtons);
        this.btnImportShader = new ColoredButton("Import Shaders", new Color(34, 155, 90));
        this.btnImportShader.setFont(new Font("Helvetica Neue", 1, 15));
        this.btnImportShader.addActionListener(this);
        panelButtons.add(this.btnImportShader);
        this.btnSaveShader = new ColoredButton(" Save Shaders ", new Color(56, 110, 165));
        this.btnSaveShader.addActionListener(this);
        this.btnSaveShader.setFont(new Font("Helvetica Neue", 1, 15));
        panelButtons.add(this.btnSaveShader);
        this.btnHelp = new ColoredButton("     Help     ", new Color(208, 0, 59));
        this.btnHelp.addActionListener(this);
        this.btnHelp.setFont(new Font("Helvetica Neue", 1, 15));
        panelButtons.add(this.btnHelp);
        this.panelFunctions = new JPanel();
        this.panelFunctions.setBounds(5, 73, 450, 319);
        this.panelFunctions.setBackground(new Color(46, 54, 56));
        this.contentPane.add(this.panelFunctions);
        this.panelFunctions.setLayout(new GridLayout(15, 1, 0, 0));
        this.panelImage = new PanelImage();
        this.panelImage.setBounds(477, 73, 450, 319);
        this.panelImage.setBackground(new Color(46, 54, 56));
        this.contentPane.add(this.panelImage);
        JPanel panelDesc = new JPanel();
        panelDesc.setBounds(5, 397, 922, 174);
        panelDesc.setBackground(new Color(46, 54, 56));
        this.contentPane.add(panelDesc);
        panelDesc.setLayout(null);
        this.descArea = new JTextArea();
        this.descArea.setEditable(false);
        this.descArea.setBounds(0, 0, 922, 174);
        this.descArea.setBackground(new Color(46, 54, 56));
        this.descArea.setForeground(Color.LIGHT_GRAY);
        panelDesc.add(this.descArea);
        this.importImages();
    }

    private void importImages() {
        this.panelImage.addImage("bloom", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/bloom.jpg")));
        this.panelImage.addImage("Cel", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/Cel.jpg")));
        this.panelImage.addImage("DOF", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/DOF.jpg")));
        this.panelImage.addImage("DEPTH_OF_FIELD", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/DEPTH_OF_FIELD.jpg")));
        this.panelImage.addImage("fading", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/fading.jpg")));
        this.panelImage.addImage("Handlight", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/Handlight.jpg")));
        this.panelImage.addImage("lens_flare", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/lens_flare.jpg")));
        this.panelImage.addImage("lens", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/lens.jpg")));
        this.panelImage.addImage("motionblur", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/motionblur.jpg")));
        this.panelImage.addImage("rainlens", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/rainlens.jpg")));
        this.panelImage.addImage("vignette", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/vignette.jpg")));
        this.panelImage.addImage("water_reflections", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/water_reflections.jpg")));
        this.panelImage.addImage("waving fire", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/waving fire.gif")));
        this.panelImage.addImage("waving flowers", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/waving flowers.gif")));
        this.panelImage.addImage("waving grass", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/waving grass.gif")));
        this.panelImage.addImage("waving lava", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/waving lava.gif")));
        this.panelImage.addImage("waving leaves", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/waving leaves.gif")));
        this.panelImage.addImage("waving lilypad", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/waving lilypad.gif")));
        this.panelImage.addImage("waving wheat", Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("img/waving wheat.gif")));
    }

    public void openShader(File path, ImportationFrame progress) throws FileNotFoundException {
        this.tmpDir = path;
        this.boxes = new Hashtable();
        this.files = new Hashtable();
        this.panelFunctions.removeAll();
        File shadersDir = new File(path + "/shaders/");
        File[] fileArray = shadersDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().startsWith("composite") && f.getName().endsWith(".fsh")) {
                this.files.put(f.getName(), new ShaderFile(f.getPath()));
            }
            ++n2;
        }
        this.files.put("final.fsh", new ShaderFile(path + "/shaders/final.fsh"));
        this.files.put("gbuffers_terrain.vsh", new ShaderFile(path + "/shaders/gbuffers_terrain.vsh"));
        for (ShaderFile file : this.files.values()) {
            try (BufferedReader buff = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = buff.readLine()) != null) {
                    for (Function f : this.functions.functions.values()) {
                        if (!line.contains("#define " + f.getName()) || this.boxes.get(f.getDisplayName()) != null) continue;
                        JCheckBox tmpBox = new JCheckBox(f.getDisplayName());
                        tmpBox.setBackground(new Color(46, 54, 56));
                        tmpBox.setForeground(Color.white);
                        tmpBox.addActionListener(this);
                        this.boxes.put(f.getDisplayName(), tmpBox);
                        this.panelFunctions.add(tmpBox);
                        f.setEnabled(this.isEnabled(line));
                        f.setFirstValue(this.isEnabled(line));
                        this.boxes.get(f.getDisplayName()).setSelected(this.isEnabled(line));
                    }
                    file.content = String.valueOf(file.content) + "\n" + line;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.panelFunctions.repaint();
        this.panelFunctions.revalidate();
        this.contentPane.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileDialog fc;
        if (e.getSource() == this.btnImportShader) {
            fc = new FileDialog((Frame)this, "Open Shader", 0);
            fc.setFilenameFilter(new FileFilterZip());
            fc.setVisible(true);
            if (fc.getDirectory() != null) {
                ImportationFrame progressFrame = new ImportationFrame();
                progressFrame.setLocationRelativeTo(this);
                progressFrame.setVisible(true);
                ThreadOpenZip openZip = new ThreadOpenZip(this, new File(String.valueOf(fc.getDirectory()) + fc.getFile()), progressFrame);
                openZip.start();
            }
        }
        if (e.getSource() == this.btnHelp) {
            try {
                this.openLink(new URL("http://forum.minecraft-france.fr/threads/shaders-configurator-coming-soon.25179/").toURI());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == this.btnSaveShader) {
            fc = new FileDialog((Frame)this, "Save Shader", 1);
            fc.setVisible(true);
            if (String.valueOf(fc.getDirectory()) + fc.getFile() != null) {
                if (!fc.getFile().endsWith(".zip")) {
                    this.saveShader(String.valueOf(fc.getDirectory()) + fc.getFile() + ".zip");
                } else {
                    this.saveShader(String.valueOf(fc.getDirectory()) + fc.getFile());
                }
            }
        }
        if (e.getSource() instanceof JCheckBox) {
            for (JCheckBox box : this.boxes.values()) {
                if (e.getSource() != box) continue;
                this.descArea.setText(this.functions.functions.get(box.getText()).getDesc());
                this.panelImage.setImage(box.getText());
                if (box.isSelected()) {
                    this.enableFunction(this.functions.functions.get(box.getText()));
                    continue;
                }
                this.disableFunction(this.functions.functions.get(box.getText()));
            }
        }
    }

    public void saveShader(String path) {
        for (ShaderFile file : this.files.values()) {
            for (Function f : this.functions.functions.values()) {
                if (f.isEnabled()) {
                    if (f.getFirstValue() == f.isEnabled()) continue;
                    file.content = file.content.replace("//#define " + f.getName(), "#define " + f.getName());
                    continue;
                }
                if (f.getFirstValue() == f.isEnabled()) continue;
                file.content = file.content.replace("#define " + f.getName(), "//#define " + f.getName());
            }
            try {
                FileWriter fw = new FileWriter(file);
                fw.write(file.content);
                fw.close();
            }
            catch (FileNotFoundException ei) {
                ei.printStackTrace();
            }
            catch (IOException ei) {
                ei.printStackTrace();
            }
        }
        this.archiveDir(String.valueOf(this.tmpDir.getAbsolutePath()) + "/shaders/", path);
    }

    private void archiveDir(String src, String path) {
        try {
            System.out.println(src);
            ZipFile zipFile = new ZipFile(path);
            String folderToAdd = src;
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            zipFile.addFolder(folderToAdd, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabled(String line) {
        return !line.startsWith("//");
    }

    public void enableFunction(Function f) {
        f.setEnabled(true);
    }

    public void disableFunction(Function f) {
        f.setEnabled(false);
    }

    public void openLink(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

