/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.GuiScreenTooltip;
import net.spellcraftgaming.rpghud.gui.GuiSettingsModSub;
import net.spellcraftgaming.rpghud.gui.GuiSliderMod;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementBarred;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.ModSettings;

public class GuiSettingsModColor
extends GuiScreenTooltip {
    private GuiTextField colorCodeField;
    private GuiScreen parent;
    private int parentSubtype;
    private EnumColor colorType;
    private int colorR;
    private int colorG;
    private int colorB;
    private int color;
    private String title = "";

    public GuiSettingsModColor(GuiScreen parent, int parentSubtype, EnumColor color) {
        this.parent = parent;
        this.parentSubtype = parentSubtype;
        this.colorType = color;
        this.setColors();
        this.title = this.setTitle() + " " + I18n.func_135052_a((String)"gui.rpg.editor", (Object[])new Object[0]);
    }

    private String setTitle() {
        switch (this.colorType) {
            case EXPERIENCE: {
                return I18n.func_135052_a((String)"name.color_exp", (Object[])new Object[0]);
            }
            case BREATH: {
                return I18n.func_135052_a((String)"name.color_air", (Object[])new Object[0]);
            }
            case HEALTH: {
                return I18n.func_135052_a((String)"name.color_health", (Object[])new Object[0]);
            }
            case JUMPBAR: {
                return I18n.func_135052_a((String)"name.color_jumpbar", (Object[])new Object[0]);
            }
            case STAMINA: {
                return I18n.func_135052_a((String)"name.color_stamina", (Object[])new Object[0]);
            }
            case POISON: {
                return I18n.func_135052_a((String)"name.color_poison", (Object[])new Object[0]);
            }
            case HUNGER: {
                return I18n.func_135052_a((String)"name.color_hunger", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void setColors() {
        int color = 0;
        switch (this.colorType) {
            case EXPERIENCE: {
                color = ModRPGHud.instance.settings.color_experience;
                break;
            }
            case BREATH: {
                color = ModRPGHud.instance.settings.color_air;
                break;
            }
            case HEALTH: {
                color = ModRPGHud.instance.settings.color_health;
                break;
            }
            case JUMPBAR: {
                color = ModRPGHud.instance.settings.color_jumpbar;
                break;
            }
            case STAMINA: {
                color = ModRPGHud.instance.settings.color_stamina;
                break;
            }
            case POISON: {
                color = ModRPGHud.instance.settings.color_poison;
                break;
            }
            case HUNGER: {
                color = ModRPGHud.instance.settings.color_hunger;
            }
        }
        this.color = color;
        this.colorR = color >> 16 & 0xFF;
        this.colorG = color >> 8 & 0xFF;
        this.colorB = color & 0xFF;
    }

    private void setSettingColor() {
        switch (this.colorType) {
            case EXPERIENCE: {
                ModRPGHud.instance.settings.color_experience = this.color;
                break;
            }
            case BREATH: {
                ModRPGHud.instance.settings.color_air = this.color;
                break;
            }
            case HEALTH: {
                ModRPGHud.instance.settings.color_health = this.color;
                break;
            }
            case STAMINA: {
                ModRPGHud.instance.settings.color_stamina = this.color;
                break;
            }
            case JUMPBAR: {
                ModRPGHud.instance.settings.color_jumpbar = this.color;
                break;
            }
            case POISON: {
                ModRPGHud.instance.settings.color_poison = this.color;
                break;
            }
            case HUNGER: {
                ModRPGHud.instance.settings.color_hunger = this.color;
            }
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.add(new GuiSliderMod(1, GuiSliderMod.EnumColor.RED, this.field_146294_l / 2 - 75, 40, this.colorR, 0.0f, 255.0f, 1.0f));
        this.field_146292_n.add(new GuiSliderMod(2, GuiSliderMod.EnumColor.GREEN, this.field_146294_l / 2 - 75, 65, this.colorG, 0.0f, 255.0f, 1.0f));
        this.field_146292_n.add(new GuiSliderMod(3, GuiSliderMod.EnumColor.BLUE, this.field_146294_l / 2 - 75, 90, this.colorB, 0.0f, 255.0f, 1.0f));
        this.colorCodeField = new GuiTextField(5, this.field_146289_q, this.field_146294_l / 2 - 74, 115, 147, 20);
        this.colorCodeField.func_146180_a(ModSettings.intToHexString(this.color));
        this.field_146292_n.add(new GuiButtonTooltip(10, this.field_146294_l / 4 * 3 - 20, 40, 60, 20, I18n.func_135052_a((String)"color.red", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(11, this.field_146294_l / 4 * 3 - 20, 60, 60, 20, I18n.func_135052_a((String)"color.pink", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(12, this.field_146294_l / 4 * 3 - 20, 80, 60, 20, I18n.func_135052_a((String)"color.brown", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(13, this.field_146294_l / 4 * 3 - 20, 100, 60, 20, I18n.func_135052_a((String)"color.white", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(14, this.field_146294_l / 4 * 3 - 20, 120, 60, 20, I18n.func_135052_a((String)"color.orange", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(15, this.field_146294_l / 4 * 3 - 20, 140, 60, 20, I18n.func_135052_a((String)"color.green", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(16, this.field_146294_l / 4 * 3 + 60 - 20, 40, 60, 20, I18n.func_135052_a((String)"color.purple", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(17, this.field_146294_l / 4 * 3 + 60 - 20, 60, 60, 20, I18n.func_135052_a((String)"color.blue", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(18, this.field_146294_l / 4 * 3 + 60 - 20, 80, 60, 20, I18n.func_135052_a((String)"color.aqua", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(19, this.field_146294_l / 4 * 3 + 60 - 20, 100, 60, 20, I18n.func_135052_a((String)"color.black", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(20, this.field_146294_l / 4 * 3 + 60 - 20, 120, 60, 20, I18n.func_135052_a((String)"color.grey", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(21, this.field_146294_l / 4 * 3 + 60 - 20, 140, 60, 20, I18n.func_135052_a((String)"color.yellow", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(250, this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 168, 125, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"tooltip.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonTooltip(251, this.field_146294_l / 2 + 24, this.field_146295_m / 6 + 168, 75, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"tooltip.cancel", (Object[])new Object[0])));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 10) {
                this.setColorTo(0xC10000);
            } else if (button.field_146127_k == 11) {
                this.setColorTo(16738740);
            } else if (button.field_146127_k == 12) {
                this.setColorTo(9127187);
            } else if (button.field_146127_k == 13) {
                this.setColorTo(0xF2F2F2);
            } else if (button.field_146127_k == 14) {
                this.setColorTo(16745472);
            } else if (button.field_146127_k == 15) {
                this.setColorTo(3916288);
            } else if (button.field_146127_k == 16) {
                this.setColorTo(10748144);
            } else if (button.field_146127_k == 17) {
                this.setColorTo(23490);
            } else if (button.field_146127_k == 18) {
                this.setColorTo(65535);
            } else if (button.field_146127_k == 19) {
                this.setColorTo(0x121212);
            } else if (button.field_146127_k == 20) {
                this.setColorTo(0x8A8A8A);
            } else if (button.field_146127_k == 21) {
                this.setColorTo(0xEEEE00);
            } else if (button.field_146127_k == 250) {
                this.setSettingColor();
                this.field_146297_k.func_147108_a((GuiScreen)new GuiSettingsModSub(this.parent, this.parentSubtype));
                ModRPGHud.instance.settings.saveOptions();
            } else if (button.field_146127_k == 251) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiSettingsModSub(this.parent, this.parentSubtype));
            }
        }
    }

    public void setColorTo(int color) {
        this.color = color;
        this.colorR = this.color >> 16 & 0xFF;
        ((GuiSliderMod)((Object)this.field_146292_n.get((int)0))).sliderValue = (float)this.colorR / 255.0f;
        ((GuiSliderMod)((Object)this.field_146292_n.get((int)0))).value = this.colorR;
        this.colorG = this.color >> 8 & 0xFF;
        ((GuiSliderMod)((Object)this.field_146292_n.get((int)1))).sliderValue = (float)this.colorG / 255.0f;
        ((GuiSliderMod)((Object)this.field_146292_n.get((int)1))).value = this.colorG;
        this.colorB = this.color & 0xFF;
        ((GuiSliderMod)((Object)this.field_146292_n.get((int)2))).sliderValue = (float)this.colorB / 255.0f;
        ((GuiSliderMod)((Object)this.field_146292_n.get((int)2))).value = this.colorB;
        this.colorCodeField.func_146180_a(ModSettings.intToHexString(this.color));
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.colorCodeField.func_146206_l()) {
            if (this.colorCodeField.func_146179_b().length() == 7 && this.colorCodeField.func_146179_b().startsWith("#") && this.colorCodeField.func_146179_b().replace("#", "").matches("[0-9A-Fa-f]+")) {
                this.color = Integer.valueOf(this.colorCodeField.func_146179_b().replace("#", ""), 16);
                this.colorR = this.color >> 16 & 0xFF;
                ((GuiSliderMod)((Object)this.field_146292_n.get((int)0))).sliderValue = (float)this.colorR / 255.0f;
                ((GuiSliderMod)((Object)this.field_146292_n.get((int)0))).value = this.colorR;
                this.colorG = this.color >> 8 & 0xFF;
                ((GuiSliderMod)((Object)this.field_146292_n.get((int)1))).sliderValue = (float)this.colorG / 255.0f;
                ((GuiSliderMod)((Object)this.field_146292_n.get((int)1))).value = this.colorG;
                this.colorB = this.color & 0xFF;
                ((GuiSliderMod)((Object)this.field_146292_n.get((int)2))).sliderValue = (float)this.colorB / 255.0f;
                ((GuiSliderMod)((Object)this.field_146292_n.get((int)2))).value = this.colorB;
            }
            this.colorCodeField.func_146180_a(this.colorCodeField.func_146179_b().toUpperCase());
        } else {
            this.colorCodeField.func_146180_a(ModSettings.intToHexString(this.color));
            this.colorR = ((GuiSliderMod)((Object)this.field_146292_n.get(0))).getValue();
            this.colorG = ((GuiSliderMod)((Object)this.field_146292_n.get(1))).getValue();
            this.colorB = ((GuiSliderMod)((Object)this.field_146292_n.get(2))).getValue();
            int color = (this.colorR << 16) + (this.colorG << 8) + this.colorB;
            if (color > 0xFFFFFF) {
                color = 0xFFFFFF;
            }
            if (color < 0) {
                color = 0;
            }
            this.color = color;
        }
        this.colorCodeField.func_146178_a();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.colorCodeField.func_146206_l()) {
            this.colorCodeField.func_146201_a(typedChar, keyCode);
            if (keyCode == 28) {
                this.colorCodeField.func_146195_b(false);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.colorCodeField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 12, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"color.red", (Object[])new Object[0]), this.field_146294_l / 2, 31, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"color.green", (Object[])new Object[0]), this.field_146294_l / 2, 56, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"color.blue", (Object[])new Object[0]), this.field_146294_l / 2, 81, -1);
        this.colorCodeField.func_146194_f();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.rpg.result", (Object[])new Object[0]) + ": " + ModSettings.intToHexString(this.color), this.field_146294_l / 2, 141, -1);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        HudElementBarred.drawCustomBar(this.field_146294_l / 2 - 75, 149, 150, 16, 100.0, 0, 0, this.color, HudElementBarred.offsetColorPercent(this.color, 25), true);
    }

    public static enum EnumColor {
        EXPERIENCE,
        BREATH,
        HEALTH,
        JUMPBAR,
        STAMINA,
        POISON,
        HUNGER;

    }
}

