/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementBarred;

@SideOnly(value=Side.CLIENT)
public class GuiSliderMod
extends GuiButtonTooltip {
    public float sliderValue;
    private EnumColor color;
    public boolean dragging;
    private final float minValue;
    private final float maxValue;
    private final float valueStep;
    public int value;

    public GuiSliderMod(int buttonId, EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep) {
        super(buttonId, x, y, 150, 12, "");
        this.color = color;
        this.sliderValue = value / 255.0f;
        this.value = MathHelper.func_76123_f((float)value);
        this.minValue = minValueIn;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m && this.dragging) {
            this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            this.field_146126_j = this.getDisplayString();
            this.value = MathHelper.func_76123_f((float)MathHelper.func_76131_a((float)(this.sliderValue * 255.0f), (float)0.0f, (float)255.0f));
        }
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            FontRenderer fontrenderer = mc.field_71466_p;
            mc.func_110434_K().func_110577_a(field_146122_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int color = 0 + (this.color == EnumColor.RED ? this.value << 16 : (this.color == EnumColor.GREEN ? this.value << 8 : this.value));
            HudElementBarred.drawCustomBar(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 100.0, color, HudElementBarred.offsetColorPercent(color, 25));
            this.func_146119_b(mc, mouseX, mouseY);
            int j = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                j = this.packedFGColour;
            } else if (!this.field_146124_l) {
                j = 0xA0A0A0;
            } else if (this.field_146123_n) {
                j = 0xFFFFA0;
            }
            this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
        }
        mc.func_110434_K().func_110577_a(field_146122_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146126_j = this.getDisplayString();
        this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, this.field_146121_g / 2);
        this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i + this.field_146121_g / 2, 0, 86 - this.field_146121_g / 2, 4, this.field_146121_g / 2);
        this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, this.field_146121_g / 2);
        this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i + this.field_146121_g / 2, 196, 86 - this.field_146121_g / 2, 4, this.field_146121_g / 2);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            this.field_146126_j = this.getDisplayString();
            this.value = MathHelper.func_76123_f((float)MathHelper.func_76131_a((float)(this.sliderValue * 255.0f), (float)0.0f, (float)255.0f));
            this.dragging = true;
            return true;
        }
        return false;
    }

    private String getDisplayString() {
        return "#" + Integer.toHexString(this.getValue()).toUpperCase();
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
    }

    public float normalizeValue(float value) {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(value) - this.maxValue) / (this.maxValue - this.minValue)), (float)0.0f, (float)1.0f);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp(this.minValue + (this.maxValue - this.minValue) * MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    public float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return MathHelper.func_76131_a((float)value, (float)this.minValue, (float)this.maxValue);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public int getValue() {
        return MathHelper.func_76123_f((float)this.value);
    }

    public static enum EnumColor {
        RED,
        GREEN,
        BLUE;

    }
}

