/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.ModSettings;

public abstract class HudElement {
    protected int posX;
    protected int posY;
    protected final int defaultPosX;
    protected final int defaultPosY;
    protected int elementWidth;
    protected int elementHeight;
    protected boolean moveable;
    protected HudElementType type;
    protected Minecraft mc;
    protected ModRPGHud rpgHud;
    protected ModSettings settings;

    public HudElement(HudElementType type, int posX, int posY, int width, int height, boolean moveable) {
        this.type = type;
        this.posX = posX;
        this.posY = posY;
        this.defaultPosX = posX;
        this.defaultPosY = posY;
        this.elementWidth = width;
        this.elementHeight = height;
        this.moveable = moveable;
        this.mc = Minecraft.func_71410_x();
        this.rpgHud = ModRPGHud.instance;
        this.settings = this.rpgHud.settings;
    }

    public abstract void drawElement(Gui var1, float var2, float var3);

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getWidth() {
        return this.elementWidth;
    }

    public int getHeight() {
        return this.elementHeight;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public HudElementType getType() {
        return this.type;
    }

    public boolean setPos(int posX, int posY) {
        boolean xValid = false;
        boolean yValid = false;
        if (posX >= 0 && posX < this.mc.field_71443_c - this.elementWidth) {
            xValid = true;
        }
        if (posY >= 0 && posY < this.mc.field_71440_d - this.elementHeight) {
            yValid = true;
        }
        if (xValid && yValid) {
            this.posX = posX;
            this.posY = posY;
        }
        return xValid && yValid;
    }

    public void setPositionToDefault() {
        this.posX = this.defaultPosX;
        this.posY = this.defaultPosY;
    }

    public boolean checkConditions() {
        return true;
    }

    public static void drawRect(int posX, int posY, int width, int height, int color) {
        if (color == -1) {
            return;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        GlStateManager.func_179097_i();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)posX, (double)posY + (double)height, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)posX + (double)width, (double)posY + (double)height, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)posX + (double)width, (double)posY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)posX, (double)posY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

