/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public abstract class HudElementBarred
extends HudElement {
    public static final int COLOR_RED = 0xC10000;
    public static final int COLOR_PINK = 16738740;
    public static final int COLOR_BROWN = 9127187;
    public static final int COLOR_WHITE = 0xF2F2F2;
    public static final int COLOR_ORANGE = 16745472;
    public static final int COLOR_GREEN = 3916288;
    public static final int COLOR_PURPLE = 10748144;
    public static final int COLOR_BLUE = 23490;
    public static final int COLOR_AQUA = 65535;
    public static final int COLOR_BLACK = 0x121212;
    public static final int COLOR_GREY = 0x8A8A8A;
    public static final int COLOR_YELLOW = 0xEEEE00;
    public static final int[] COLOR_DEFAULT = new int[]{0x4C4C4C, 0x3D3D3D};
    public static final int OFFSET_PERCENT = 25;
    public static final int OFFSET_PREVIEW = 0x5A5A5A;

    public HudElementBarred(HudElementType type, int posX, int posY, int width, int height, boolean moveable) {
        super(type, posX, posY, width, height, moveable);
    }

    protected static void drawOutline(int x, int y, int width, int height, int color) {
        HudElementBarred.drawRect(x, y, width, 1, color);
        HudElementBarred.drawRect(x, y, 1, height, color);
        HudElementBarred.drawRect(x + width - 1, y, 1, height, color);
        HudElementBarred.drawRect(x, y + height - 1, width, 1, color);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorBarLight, int colorBarDark) {
        HudElementBarred.drawCustomBar(x, y, width, height, value, COLOR_DEFAULT[0], COLOR_DEFAULT[1], colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark) {
        HudElementBarred.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined) {
        HudElementBarred.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, outlined, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, int colorOutline) {
        HudElementBarred.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, colorOutline);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined, int colorOutline) {
        if (value < 0.0) {
            value = 0.0;
        }
        int offset = 0;
        if (outlined) {
            offset = 1;
        }
        int filledWidth = width;
        filledWidth = width - offset * 2;
        if (filledWidth < 0) {
            filledWidth = 0;
        }
        int filledHeight = width;
        filledHeight = height - offset * 2;
        if (filledHeight < 0) {
            filledHeight = 0;
        }
        int percentFilled = (int)Math.round(value / 100.0 * (double)filledWidth);
        if (outlined) {
            HudElementBarred.drawOutline(x, y, width, height, colorOutline);
        }
        int halfedFilledHeight = filledHeight / 2;
        HudElementBarred.drawRect(x + offset, y + offset, percentFilled, halfedFilledHeight, colorBarLight);
        HudElementBarred.drawRect(x + offset, y + offset + halfedFilledHeight, percentFilled, filledHeight - halfedFilledHeight, colorBarDark);
        if (filledWidth - percentFilled > 0) {
            HudElementBarred.drawRect(x + offset + percentFilled, y + offset, filledWidth - percentFilled, halfedFilledHeight, colorGroundLight);
            HudElementBarred.drawRect(x + offset + percentFilled, y + offset + halfedFilledHeight, filledWidth - percentFilled, filledHeight - halfedFilledHeight, colorGroundDark);
        }
    }

    public void drawTetragon(int posX1, int posX2, int posY1, int posY2, int width1, int width2, int height1, int height2, int color) {
        if (color == -1) {
            return;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        GlStateManager.func_179097_i();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)posX1, (double)posY1 + (double)height1, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)posX2 + (double)width2, (double)posY2 + (double)height2, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)posX1 + (double)width1, (double)posY2, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)posX2, (double)posY1, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int offsetColorPercent(int color, int offsetPercent) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart -= colorPart / (100 / offsetPercent)) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    public static int offsetColor(int color, int offset) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart += offset >> 16 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        if ((colorPart += offset >> 8 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        if ((colorPart += offset & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }
}

