/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.spellcraftgaming.rpghud.event.ClientTickHandler;
import net.spellcraftgaming.rpghud.event.ItemPickupHandler;
import net.spellcraftgaming.rpghud.event.PlayerContainerHandler;
import net.spellcraftgaming.rpghud.event.PlayerTickHandler;
import net.spellcraftgaming.rpghud.gui.hud.Hud;
import net.spellcraftgaming.rpghud.gui.hud.HudDefault;
import net.spellcraftgaming.rpghud.gui.hud.HudExtendedWidget;
import net.spellcraftgaming.rpghud.gui.hud.HudFullTexture;
import net.spellcraftgaming.rpghud.gui.hud.HudHotbarWidget;
import net.spellcraftgaming.rpghud.gui.hud.HudModern;
import net.spellcraftgaming.rpghud.gui.hud.HudVanilla;
import net.spellcraftgaming.rpghud.settings.ModDebugSettings;
import net.spellcraftgaming.rpghud.settings.ModSettings;

@Mod(modid="rpghud", version="3.3", name="RPG-Hud", clientSideOnly=true, guiFactory="net.spellcraftgaming.rpghud.gui.GuiFactoryRPGHud", updateJSON="http://download.spellcraftgaming.net/rpghud/version/update.json", acceptedMinecraftVersions="[1.10.2]")
public class ModRPGHud {
    public static final String MOD_ID = "rpghud";
    public static final String NAME = "RPG-Hud";
    public static final String VERSION = "3.3";
    public static final String GUI_FACTORY = "net.spellcraftgaming.rpghud.gui.GuiFactoryRPGHud";
    public static final String UPDATE_JSON = "http://download.spellcraftgaming.net/rpghud/version/update.json";
    public static final boolean CLIENT_SIDE_ONLY = true;
    @Mod.Instance
    public static ModRPGHud instance;
    public ModDebugSettings settingsDebug;
    public ModSettings settings;
    public Map<String, Hud> huds = new LinkedHashMap<String, Hud>();
    public static boolean[] renderDetailsAgain;
    public ItemPickupHandler pickupHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.settings = new ModSettings(Minecraft.func_71410_x().field_71412_D);
        this.settingsDebug = new ModDebugSettings(Minecraft.func_71410_x().field_71412_D);
        this.registerHud(new HudVanilla(Minecraft.func_71410_x(), "vanilla", "Vanilla"));
        this.registerHud(new HudDefault(Minecraft.func_71410_x(), "default", "Default"));
        this.registerHud(new HudExtendedWidget(Minecraft.func_71410_x(), "extended", "Extended Widget"));
        this.registerHud(new HudFullTexture(Minecraft.func_71410_x(), "texture", "Full Texture"));
        this.registerHud(new HudHotbarWidget(Minecraft.func_71410_x(), "hotbar", "Hotbar Widget"));
        this.registerHud(new HudModern(Minecraft.func_71410_x(), "modern", "Modern Style"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTickHandler());
        this.pickupHandler = new ItemPickupHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.pickupHandler);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerContainerHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.isHudKeyValid(this.settings.hud_type)) {
            this.settings.hud_type = "vanilla";
        }
    }

    public void registerHud(Hud hud) {
        this.huds.put(hud.getHudKey(), hud);
    }

    public Hud getActiveHud() {
        return this.huds.get(this.settings.hud_type);
    }

    public Hud getVanillaHud() {
        return this.huds.get("vanilla");
    }

    public boolean isHudKeyValid(String key) {
        return this.huds.containsKey(key);
    }

    static {
        renderDetailsAgain = new boolean[]{false, false, false};
    }
}

