/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.settings;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public enum EnumOptionsMod {
    BUTTON_TOOLTIP_ENABLED(EnumOptionType.BOOLEAN, "name.button_tooltip", I18n.func_135052_a((String)"tooltip.button_tooltip", (Object[])new Object[0])),
    SHOW_ARMOR(EnumOptionType.BOOLEAN, "name.show_armor", I18n.func_135052_a((String)"tooltip.show_armor", (Object[])new Object[0])),
    SHOW_ITEMDURABILITY(EnumOptionType.BOOLEAN, "name.item_durability", I18n.func_135052_a((String)"tooltip.item_durability", (Object[])new Object[0])),
    SHOW_ITEMCOUNT(EnumOptionType.BOOLEAN, "name.item_count", I18n.func_135052_a((String)"tooltip.item_count", (Object[])new Object[0])),
    SHOW_ARROWCOUNT(EnumOptionType.BOOLEAN, "name.arrow_count", I18n.func_135052_a((String)"tooltip.arrow_count", (Object[])new Object[0])),
    SHOW_NUMBERS_HEALTH(EnumOptionType.BOOLEAN, "name.show_numbers_health", I18n.func_135052_a((String)"tooltip.numbers_health", (Object[])new Object[0])),
    SHOW_NUMBERS_STAMINA(EnumOptionType.BOOLEAN, "name.show_numbers_stamina", I18n.func_135052_a((String)"tooltip.numbers_stamina", (Object[])new Object[0])),
    SHOW_NUMBERS_EXPERIENCE(EnumOptionType.BOOLEAN, "name.show_numbers_exp", I18n.func_135052_a((String)"tooltip.numbers_exp", (Object[])new Object[0])),
    ENABLE_CLOCK(EnumOptionType.BOOLEAN, "name.enable_clock", I18n.func_135052_a((String)"tooltip.enable_clock", (Object[])new Object[0])),
    ENABLE_IMMERSIVE_CLOCK(EnumOptionType.BOOLEAN, "name.enable_immersive_clock", I18n.func_135052_a((String)"tooltip.enable_immersive_clock", (Object[])new Object[0])),
    ENABLE_TIMECOLOR(EnumOptionType.BOOLEAN, "name.enable_timecolor", I18n.func_135052_a((String)"tooltip.enable_timecolor", (Object[])new Object[0])),
    RENDER_PLAYER_FACE(EnumOptionType.BOOLEAN, "name.player_face", I18n.func_135052_a((String)"tooltip.player_face", (Object[])new Object[0])),
    HUD_TYPE(EnumOptionType.STRING, "name.hud_type", I18n.func_135052_a((String)"tooltip.hud_type", (Object[])new Object[0])),
    COLOR_HEALTH(EnumOptionType.INTEGER, "name.color_health", I18n.func_135052_a((String)"tooltip.color_health", (Object[])new Object[0])),
    COLOR_STAMINA(EnumOptionType.INTEGER, "name.color_stamina", I18n.func_135052_a((String)"tooltip.color_stamina", (Object[])new Object[0])),
    COLOR_AIR(EnumOptionType.INTEGER, "name.color_air", I18n.func_135052_a((String)"tooltip.color_air", (Object[])new Object[0])),
    COLOR_EXPERIENCE(EnumOptionType.INTEGER, "name.color_exp", I18n.func_135052_a((String)"tooltip.color_exp", (Object[])new Object[0])),
    COLOR_JUMPBAR(EnumOptionType.INTEGER, "name.color_jumpbar", I18n.func_135052_a((String)"tooltip.color_jumpbar", (Object[])new Object[0])),
    COLOR_POISON(EnumOptionType.INTEGER, "name.color_poison", I18n.func_135052_a((String)"tooltip.color_poison", (Object[])new Object[0])),
    COLOR_HUNGER(EnumOptionType.INTEGER, "name.color_hunger", I18n.func_135052_a((String)"tooltip.color_hunger", (Object[])new Object[0])),
    SHOW_HUNGERPREVIEW(EnumOptionType.BOOLEAN, "name.show_hungerpreview", I18n.func_135052_a((String)"tooltip.show_hungerpreview", (Object[])new Object[0])),
    CLOCK_TIME_FORMAT(EnumOptionType.INTEGER, "name.time_format", I18n.func_135052_a((String)"tooltip.clock_time_format", (Object[])new Object[0])),
    REDUCE_SIZE(EnumOptionType.BOOLEAN, "name.reduce_size", I18n.func_135052_a((String)"tooltip.reduce_size", (Object[])new Object[0])),
    ENABLE_COMPASS(EnumOptionType.BOOLEAN, "name.enable_compass", I18n.func_135052_a((String)"tooltip.enable_compass", (Object[])new Object[0])),
    ENABLE_IMMERSIVE_COMPASS(EnumOptionType.BOOLEAN, "name.immersive_compass", I18n.func_135052_a((String)"tooltip.immersive_compass", (Object[])new Object[0])),
    ENABLE_COMPASS_COLOR(EnumOptionType.BOOLEAN, "name.compass_color", I18n.func_135052_a((String)"tooltip.compass_color", (Object[])new Object[0])),
    ENABLE_PICKUP(EnumOptionType.BOOLEAN, "name.enable_pickup", I18n.func_135052_a((String)"tooltip.enable_pickup", (Object[])new Object[0])),
    PICK_DURATION(EnumOptionType.FLOAT, "name.pickup_duration", I18n.func_135052_a((String)"tooltip.pickup_duration", (Object[])new Object[0]), 1.0f, 10.0f, 1.0f);

    private final String enumName;
    private final String tooltip;
    private final EnumOptionType type;
    private final float valueStep;
    private final float valueMin;
    private final float valueMax;

    public static EnumOptionsMod getEnumOptions(int par0) {
        for (EnumOptionsMod enumoptions : EnumOptionsMod.values()) {
            if (enumoptions.returnEnumOrdinal() != par0) continue;
            return enumoptions;
        }
        return null;
    }

    private EnumOptionsMod(EnumOptionType type, String name, String tooltip) {
        this.type = type;
        this.enumName = name;
        this.tooltip = tooltip;
        this.valueMin = 0.0f;
        this.valueMax = 0.0f;
        this.valueStep = 0.0f;
    }

    private EnumOptionsMod(EnumOptionType type, String name, String tooltip, float valMin, float valMax, float valStep) {
        this.type = type;
        this.enumName = name;
        this.tooltip = tooltip;
        this.valueMin = valMin;
        this.valueMax = valMax;
        this.valueStep = valStep;
    }

    public int returnEnumOrdinal() {
        return this.ordinal();
    }

    public String getName() {
        return this.enumName;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public EnumOptionType getType() {
        return this.type;
    }

    public boolean isBoolean() {
        return this.type == EnumOptionType.BOOLEAN;
    }

    public float normalizeValue(float value) {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(value) - this.valueMin) / (this.valueMax - this.valueMin)), (float)0.0f, (float)1.0f);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    public float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return MathHelper.func_76131_a((float)value, (float)this.valueMin, (float)this.valueMax);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public static enum EnumOptionType {
        INTEGER,
        BOOLEAN,
        STRING,
        FLOAT;

    }
}

