/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.spellcraftgaming.rpghud.gui.hud.Hud;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.EnumOptionsMod;

public class ModSettings {
    protected Minecraft mc = Minecraft.func_71410_x();
    private File optionsFile;
    private static final String[] TIME_FORMAT = new String[]{"time.24", "time.12"};
    public boolean button_tooltip_enabled = true;
    public boolean show_armor = true;
    public boolean show_arrowcount = true;
    public boolean show_itemdurability = true;
    public boolean show_blockcount = true;
    public boolean show_numbers_health = true;
    public boolean show_numbers_stamina = true;
    public boolean show_numbers_experience = true;
    public boolean enable_clock = true;
    public boolean enable_clock_color = true;
    public boolean enable_immersive_clock = false;
    public boolean enable_compass = true;
    public boolean enable_compass_color = true;
    public boolean enable_immersive_compass = false;
    public boolean enable_pickup = true;
    public boolean render_player_face = true;
    public boolean show_hunger_preview = true;
    public boolean reduce_size = false;
    public String hud_type = "vanilla";
    public int color_health = 0xC10000;
    public int color_stamina = 3916288;
    public int color_air = 23490;
    public int color_experience = 0xEEEE00;
    public int color_jumpbar = 0xBFBFBF;
    public int color_poison = 0x800080;
    public int color_hunger = 10199143;
    public int clock_time_format = 0;
    public float pickup_duration = 5.0f;

    public ModSettings(File file) {
        this.optionsFile = new File(file, "RPGHud_settings.txt");
        this.loadOptions();
    }

    public void setOptionValue(EnumOptionsMod options) {
        if (options == EnumOptionsMod.BUTTON_TOOLTIP_ENABLED) {
            boolean bl = this.button_tooltip_enabled = !this.button_tooltip_enabled;
        }
        if (options == EnumOptionsMod.SHOW_ARMOR) {
            boolean bl = this.show_armor = !this.show_armor;
        }
        if (options == EnumOptionsMod.SHOW_ARROWCOUNT) {
            boolean bl = this.show_arrowcount = !this.show_arrowcount;
        }
        if (options == EnumOptionsMod.SHOW_ITEMDURABILITY) {
            boolean bl = this.show_itemdurability = !this.show_itemdurability;
        }
        if (options == EnumOptionsMod.SHOW_ITEMCOUNT) {
            boolean bl = this.show_blockcount = !this.show_blockcount;
        }
        if (options == EnumOptionsMod.SHOW_NUMBERS_HEALTH) {
            boolean bl = this.show_numbers_health = !this.show_numbers_health;
        }
        if (options == EnumOptionsMod.SHOW_NUMBERS_STAMINA) {
            boolean bl = this.show_numbers_stamina = !this.show_numbers_stamina;
        }
        if (options == EnumOptionsMod.SHOW_NUMBERS_EXPERIENCE) {
            boolean bl = this.show_numbers_experience = !this.show_numbers_experience;
        }
        if (options == EnumOptionsMod.ENABLE_CLOCK) {
            boolean bl = this.enable_clock = !this.enable_clock;
        }
        if (options == EnumOptionsMod.ENABLE_TIMECOLOR) {
            boolean bl = this.enable_clock_color = !this.enable_clock_color;
        }
        if (options == EnumOptionsMod.ENABLE_IMMERSIVE_CLOCK) {
            boolean bl = this.enable_immersive_clock = !this.enable_immersive_clock;
        }
        if (options == EnumOptionsMod.ENABLE_COMPASS) {
            boolean bl = this.enable_compass = !this.enable_compass;
        }
        if (options == EnumOptionsMod.ENABLE_COMPASS_COLOR) {
            boolean bl = this.enable_compass_color = !this.enable_compass_color;
        }
        if (options == EnumOptionsMod.ENABLE_IMMERSIVE_COMPASS) {
            boolean bl = this.enable_immersive_compass = !this.enable_immersive_compass;
        }
        if (options == EnumOptionsMod.RENDER_PLAYER_FACE) {
            boolean bl = this.render_player_face = !this.render_player_face;
        }
        if (options == EnumOptionsMod.SHOW_HUNGERPREVIEW) {
            boolean bl = this.show_hunger_preview = !this.show_hunger_preview;
        }
        if (options == EnumOptionsMod.REDUCE_SIZE) {
            boolean bl = this.reduce_size = !this.reduce_size;
        }
        if (options == EnumOptionsMod.CLOCK_TIME_FORMAT) {
            this.clock_time_format = this.clock_time_format >= 1 ? 0 : ++this.clock_time_format;
        }
        if (options == EnumOptionsMod.HUD_TYPE) {
            this.incrementHudType();
        }
        if (options == EnumOptionsMod.ENABLE_PICKUP) {
            this.enable_pickup = !this.enable_pickup;
        }
        this.saveOptions();
    }

    private void incrementHudType() {
        Set<String> huds = ModRPGHud.instance.huds.keySet();
        String[] keys = huds.toArray(new String[huds.size()]);
        int size = keys.length;
        for (int n = 0; n < size; ++n) {
            if (!keys[n].equals(this.hud_type)) continue;
            if (++n == size) {
                n = 0;
            }
            this.hud_type = keys[n];
            return;
        }
    }

    public void setOptionFloatValue(EnumOptionsMod options, float value) {
        switch (options) {
            case PICK_DURATION: {
                this.pickup_duration = value;
                break;
            }
        }
    }

    public float getOptionFloatValue(EnumOptionsMod settingOption) {
        switch (settingOption) {
            case PICK_DURATION: {
                return this.pickup_duration;
            }
        }
        return 0.0f;
    }

    public boolean getOptionOrdinalValue(EnumOptionsMod options) {
        switch (SwitchOptions.optionIds[options.ordinal()]) {
            case 0: {
                return this.show_armor;
            }
            case 1: {
                return this.show_numbers_health;
            }
            case 2: {
                return this.show_numbers_stamina;
            }
            case 3: {
                return this.show_numbers_experience;
            }
            case 4: {
                return this.render_player_face;
            }
            case 5: {
                return this.show_hunger_preview;
            }
            case 6: {
                return this.enable_clock;
            }
            case 7: {
                return this.enable_clock_color;
            }
            case 8: {
                return this.enable_immersive_clock;
            }
            case 9: {
                return this.button_tooltip_enabled;
            }
            case 10: {
                return this.show_itemdurability;
            }
            case 11: {
                return this.show_arrowcount;
            }
            case 12: {
                return this.show_blockcount;
            }
            case 13: {
                return this.reduce_size;
            }
            case 14: {
                return this.enable_compass;
            }
            case 15: {
                return this.enable_compass_color;
            }
            case 16: {
                return this.enable_immersive_compass;
            }
            case 17: {
                return this.enable_pickup;
            }
        }
        return false;
    }

    public void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(this.optionsFile));
            String s = "";
            while ((s = reader.readLine()) != null) {
                try {
                    String[] string = s.split(":");
                    if (string[0].equals("button_tooltip_enabled")) {
                        this.button_tooltip_enabled = string[1].equals("true");
                    }
                    if (string[0].equals("color_health")) {
                        this.color_health = string[1].startsWith("#") ? Integer.parseInt(string[1].replace("#", ""), 16) : ModSettings.getColor(this.color_health);
                    }
                    if (string[0].equals("color_stamina")) {
                        this.color_stamina = string[1].startsWith("#") ? Integer.parseInt(string[1].replace("#", ""), 16) : ModSettings.getColor(this.color_stamina);
                    }
                    if (string[0].equals("color_air")) {
                        this.color_air = string[1].startsWith("#") ? Integer.parseInt(string[1].replace("#", ""), 16) : ModSettings.getColor(this.color_air);
                    }
                    if (string[0].equals("color_experience")) {
                        this.color_experience = string[1].startsWith("#") ? Integer.parseInt(string[1].replace("#", ""), 16) : ModSettings.getColor(this.color_experience);
                    }
                    if (string[0].equals("color_jumpbar")) {
                        this.color_jumpbar = string[1].startsWith("#") ? Integer.parseInt(string[1].replace("#", ""), 16) : ModSettings.getColor(this.color_jumpbar);
                    }
                    if (string[0].equals("color_poison")) {
                        this.color_poison = Integer.parseInt(string[1].replace("#", ""), 16);
                    }
                    if (string[0].equals("color_hunger")) {
                        this.color_hunger = Integer.parseInt(string[1].replace("#", ""), 16);
                    }
                    if (string[0].equals("clock_time_format")) {
                        this.clock_time_format = Integer.parseInt(string[1]);
                    }
                    if (string[0].equals("hud_type")) {
                        this.hud_type = string[1];
                    }
                    if (string[0].equals("show_armor")) {
                        this.show_armor = string[1].equals("true");
                    }
                    if (string[0].equals("show_blockcount")) {
                        this.show_blockcount = string[1].equals("true");
                    }
                    if (string[0].equals("show_arrowcount")) {
                        this.show_arrowcount = string[1].equals("true");
                    }
                    if (string[0].equals("show_itemdurability")) {
                        this.show_itemdurability = string[1].equals("true");
                    }
                    if (string[0].equals("enable_clock")) {
                        this.enable_clock = string[1].equals("true");
                    }
                    if (string[0].equals("enable_clock_color")) {
                        this.enable_clock_color = string[1].equals("true");
                    }
                    if (string[0].equals("enable_immersive_clock")) {
                        this.enable_immersive_clock = string[1].equals("true");
                    }
                    if (string[0].equals("enable_compass")) {
                        this.enable_compass = string[1].equals("true");
                    }
                    if (string[0].equals("enable_compass_color")) {
                        this.enable_compass_color = string[1].equals("true");
                    }
                    if (string[0].equals("enable_immersive_compass")) {
                        this.enable_immersive_compass = string[1].equals("true");
                    }
                    if (string[0].equals("render_player_face")) {
                        this.render_player_face = string[1].equals("true");
                    }
                    if (string[0].equals("show_numbers_health")) {
                        this.show_numbers_health = string[1].equals("true");
                    }
                    if (string[0].equals("show_numbers_stamina")) {
                        this.show_numbers_stamina = string[1].equals("true");
                    }
                    if (string[0].equals("show_numbers_experience")) {
                        this.show_numbers_experience = string[1].equals("true");
                    }
                    if (string[0].equals("show_hunger_preview")) {
                        this.show_hunger_preview = string[1].equals("true");
                    }
                    if (string[0].equals("reduce_size")) {
                        this.reduce_size = string[1].equals("true");
                    }
                    if (string[0].equals("enable_pickup")) {
                        this.enable_pickup = string[1].equals("true");
                    }
                    if (!string[0].equals("pickup_duration")) continue;
                    this.pickup_duration = Float.parseFloat(string[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getKeyBinding(EnumOptionsMod par1EnumOptions) {
        String s = I18n.func_135052_a((String)par1EnumOptions.getName(), (Object[])new Object[0]) + ": ";
        if (par1EnumOptions.isBoolean()) {
            boolean flag = this.getOptionOrdinalValue(par1EnumOptions);
            return flag ? s + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : s + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        }
        if (par1EnumOptions.getType() == EnumOptionsMod.EnumOptionType.FLOAT) {
            return s + (par1EnumOptions == EnumOptionsMod.PICK_DURATION ? MathHelper.func_76123_f((float)par1EnumOptions.snapToStepClamp(this.getOptionFloatValue(par1EnumOptions))) + " " + I18n.func_135052_a((String)"gui.rpg.sec", (Object[])new Object[0]) : String.valueOf(par1EnumOptions.snapToStepClamp(this.getOptionFloatValue(par1EnumOptions))));
        }
        switch (par1EnumOptions) {
            case HUD_TYPE: {
                return s + ModSettings.getHudName(this.hud_type);
            }
            case COLOR_JUMPBAR: {
                return s + ModSettings.intToHexString(this.color_jumpbar);
            }
            case COLOR_EXPERIENCE: {
                return s + ModSettings.intToHexString(this.color_experience);
            }
            case COLOR_STAMINA: {
                return s + ModSettings.intToHexString(this.color_stamina);
            }
            case COLOR_POISON: {
                return s + ModSettings.intToHexString(this.color_poison);
            }
            case COLOR_HUNGER: {
                return s + ModSettings.intToHexString(this.color_hunger);
            }
            case COLOR_HEALTH: {
                return s + ModSettings.intToHexString(this.color_health);
            }
            case COLOR_AIR: {
                return s + ModSettings.intToHexString(this.color_air);
            }
            case CLOCK_TIME_FORMAT: {
                return s + ModSettings.getTranslation(TIME_FORMAT, this.clock_time_format);
            }
        }
        return s;
    }

    private static String getHudName(String hudtype) {
        Hud hud = ModRPGHud.instance.huds.get(hudtype);
        return hud.getHudName();
    }

    private static String getTranslation(String[] strings, int value) {
        if (value < 0 || value >= strings.length) {
            value = 0;
        }
        return I18n.func_135052_a((String)strings[value], (Object[])new Object[0]);
    }

    public void saveOptions() {
        if (!FMLClientHandler.instance().isLoading()) {
            try {
                PrintWriter exception = new PrintWriter(new FileWriter(this.optionsFile));
                exception.println("button_tooltip_enabled:" + this.button_tooltip_enabled);
                exception.println("color_health:#" + Integer.toHexString(this.color_health));
                exception.println("color_air:#" + Integer.toHexString(this.color_air));
                exception.println("color_stamina:#" + Integer.toHexString(this.color_stamina));
                exception.println("color_experience:#" + Integer.toHexString(this.color_experience));
                exception.println("color_jumpbar:#" + Integer.toHexString(this.color_jumpbar));
                exception.println("color_poison:#" + Integer.toHexString(this.color_poison));
                exception.println("color_hunger:#" + Integer.toHexString(this.color_hunger));
                exception.println("clock_time_format:" + this.clock_time_format);
                exception.println("hud_type:" + this.hud_type);
                exception.println("show_armor:" + this.show_armor);
                exception.println("show_blockcount:" + this.show_blockcount);
                exception.println("show_arrowcount:" + this.show_arrowcount);
                exception.println("show_itemdurability:" + this.show_itemdurability);
                exception.println("show_numbers_health:" + this.show_numbers_health);
                exception.println("show_numbers_stamina:" + this.show_numbers_stamina);
                exception.println("show_numbers_experience:" + this.show_numbers_experience);
                exception.println("enable_clock:" + this.enable_clock);
                exception.println("enable_clock_color:" + this.enable_clock_color);
                exception.println("enable_immersive_clock:" + this.enable_immersive_clock);
                exception.println("enable_compass:" + this.enable_compass);
                exception.println("enable_compass_color:" + this.enable_compass_color);
                exception.println("enable_immersive_compass:" + this.enable_immersive_compass);
                exception.println("render_player_face:" + this.render_player_face);
                exception.println("show_hunger_preview:" + this.show_hunger_preview);
                exception.println("reduce_size:" + this.reduce_size);
                exception.println("enable_pickup:" + this.enable_pickup);
                exception.println("pickup_duration:" + this.pickup_duration);
                exception.close();
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    @Deprecated
    public static int getColor(int setting) {
        switch (setting) {
            case 0: {
                return 0xC10000;
            }
            case 1: {
                return 23490;
            }
            case 2: {
                return 3916288;
            }
            case 3: {
                return 0xEEEE00;
            }
            case 4: {
                return 0xF2F2F2;
            }
            case 5: {
                return 0x8A8A8A;
            }
        }
        return 0xFFFFFF;
    }

    public static String intToHexString(int hex) {
        String s = Integer.toHexString(hex).toUpperCase();
        if (hex <= 1048575) {
            s = "0" + s;
            if (hex <= 65535) {
                s = "0" + s;
                if (hex <= 4095) {
                    s = "0" + s;
                    if (hex <= 255) {
                        s = "0" + s;
                        if (hex <= 15) {
                            s = "0" + s;
                        }
                    }
                }
            }
        }
        return "#" + s;
    }

    static final class SwitchOptions {
        static final int[] optionIds = new int[EnumOptionsMod.values().length];

        SwitchOptions() {
        }

        static {
            try {
                SwitchOptions.optionIds[EnumOptionsMod.SHOW_ARMOR.ordinal()] = 0;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.SHOW_NUMBERS_HEALTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.SHOW_NUMBERS_STAMINA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.SHOW_NUMBERS_EXPERIENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.RENDER_PLAYER_FACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.SHOW_HUNGERPREVIEW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.ENABLE_CLOCK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.ENABLE_TIMECOLOR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.ENABLE_IMMERSIVE_CLOCK.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.BUTTON_TOOLTIP_ENABLED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.SHOW_ITEMDURABILITY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.SHOW_ARROWCOUNT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.SHOW_ITEMCOUNT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.REDUCE_SIZE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.ENABLE_COMPASS.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.ENABLE_COMPASS_COLOR.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.ENABLE_IMMERSIVE_COMPASS.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[EnumOptionsMod.ENABLE_PICKUP.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

