/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import org.lwjgl.input.Keyboard;

public class TMIView
implements _tmi_MgTooltipHandler {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    private _tmi_MgCanvas canvas;
    private TMIConfig config;
    private TMIController controller;
    private boolean widgetsCreated = false;
    private String activeTooltip = null;
    private static String savedTabName = "items";
    private _tmi_MgButton prevButton;
    private _tmi_MgButton nextButton;
    private _tmi_MgButton trashButton;
    private _tmi_MgButton[] stateButtons;
    private _tmi_MgButton[] deleteButtons;
    public TMIItemPanel itemPanel;
    public _tmi_MgTabView tabView = new _tmi_MgTabView();
    public TMIEnchantPanel enchantPanel = new TMIEnchantPanel(this);
    public TMIConfigPanel configPanel = new TMIConfigPanel();
    public TMIFavoritesPanel favoritesPanel;
    public TMIPotionPanel potionPanel = new TMIPotionPanel();
    public TMIFireworkPanel fireworkPanel = new TMIFireworkPanel();
    public _tmi_MgButton rain;
    public _tmi_MgButton survival;
    public _tmi_MgButton creative;
    public _tmi_MgButton adventure;
    public _tmi_MgButton delete;
    public _tmi_MgButton noon;
    public _tmi_MgButton dawn;
    public _tmi_MgButton dusk;
    public _tmi_MgButton midnight;
    public _tmi_MgButton difficulty;
    public _tmi_MgButton health;

    public TMIView(_tmi_MgCanvas _tmi_MgCanvas2, TMIConfig tMIConfig, TMIController tMIController) {
        this.canvas = _tmi_MgCanvas2;
        this.config = tMIConfig;
        this.controller = tMIController;
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.deleteButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.createWidgets();
    }

    public void createWidgets() {
        this.itemPanel = new TMIItemPanel(0, 0, 0, 0, 0, this.config.getItems(), this.controller);
        this.favoritesPanel = new TMIFavoritesPanel(this.config, this.controller);
        this.tabView.addChild("items", TMIImages.iconChest, TMIImages.iconChestLight, this.itemPanel);
        this.tabView.addChild("favorites", TMIImages.iconStar, TMIImages.iconStarLight, this.favoritesPanel);
        this.tabView.addChild("enchant", TMIImages.iconBook, TMIImages.iconBookLight, this.enchantPanel);
        TMIView tMIView = this;
        if (!tMIView.config.isMultiplayer()) {
            this.tabView.addChild("potions", TMIImages.iconPotion, TMIImages.iconPotion, this.potionPanel);
            this.tabView.addChild("fireworks", TMIImages.iconFirework, TMIImages.iconFirework, this.fireworkPanel);
        }
        this.canvas.widgets.add(this.tabView);
        this.tabView.setActiveChild(savedTabName);
        this.delete = new _tmi_MgButton("", this.controller, "deleteMode");
        this.delete.icon = TMIImages.iconDelete;
        this.delete.showState = true;
        this.delete.setOwnWidth(this.canvas);
        this.delete.height = 14;
        this.canvas.widgets.add(this.delete);
        this.rain = new _tmi_MgButton("", this.controller, "rain");
        this.rain.showState = true;
        this.rain.icon = TMIImages.iconRain;
        this.rain.setOwnWidth(this.canvas);
        this.rain.height = 14;
        this.canvas.widgets.add(this.rain);
        this.survival = new _tmi_MgButton("", this.controller, "survival");
        this.survival.icon = TMIImages.iconModeS;
        this.survival.setOwnWidth(this.canvas);
        this.survival.height = 14;
        this.canvas.widgets.add(this.survival);
        this.creative = new _tmi_MgButton("", this.controller, "creative");
        this.creative.icon = TMIImages.iconModeC;
        this.creative.setOwnWidth(this.canvas);
        this.creative.height = 14;
        this.canvas.widgets.add(this.creative);
        this.adventure = new _tmi_MgButton("", this.controller, "adventure");
        this.adventure.icon = TMIImages.iconModeA;
        this.adventure.setOwnWidth(this.canvas);
        this.adventure.height = 14;
        this.canvas.widgets.add(this.adventure);
        this.noon = new _tmi_MgButton("", this.controller, "noon");
        this.noon.icon = TMIImages.iconNoon;
        this.noon.setOwnWidth(this.canvas);
        this.noon.height = 14;
        this.canvas.widgets.add(this.noon);
        this.dawn = new _tmi_MgButton("", this.controller, "dawn");
        this.dawn.icon = TMIImages.iconDawn;
        this.dawn.setOwnWidth(this.canvas);
        this.dawn.height = 14;
        this.canvas.widgets.add(this.dawn);
        this.dusk = new _tmi_MgButton("", this.controller, "dusk");
        this.dusk.icon = TMIImages.iconDusk;
        this.dusk.setOwnWidth(this.canvas);
        this.dusk.height = 14;
        this.canvas.widgets.add(this.dusk);
        this.midnight = new _tmi_MgButton("", this.controller, "midnight");
        this.midnight.icon = TMIImages.iconMidnight;
        this.midnight.setOwnWidth(this.canvas);
        this.midnight.height = 14;
        this.canvas.widgets.add(this.midnight);
        this.difficulty = new _tmi_MgButton("", this.controller, "difficulty");
        this.difficulty.icon = TMIImages.iconDifficulty;
        this.difficulty.setOwnWidth(this.canvas);
        this.difficulty.height = 14;
        this.canvas.widgets.add(this.difficulty);
        this.health = new _tmi_MgButton("", this.controller, "health");
        this.health.icon = TMIImages.iconHeart;
        this.health.setOwnWidth(this.canvas);
        this.health.height = 14;
        this.canvas.widgets.add(this.health);
        this.delete.x = 2;
        this.delete.y = 2;
        this.canvas.arrangeHorizontally(1, 1001, this.delete, this.survival, this.creative, this.adventure, this.rain, this.dawn, this.noon, this.dusk, this.midnight, this.difficulty, this.health);
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        for (int i = 0; i < this.config.getNumSaves(); ++i) {
            this.stateButtons[i] = new _tmi_MgButton("\u4fdd\u5b58 " + (i + 1), this.controller, new TMIStateButtonData(i, 0));
            this.canvas.widgets.add(this.stateButtons[i]);
            this.deleteButtons[i] = new _tmi_MgButton("x", this.controller, new TMIStateButtonData(i, 1));
            this.canvas.widgets.add(this.deleteButtons[i]);
        }
        this.widgetsCreated = true;
    }

    public void layout(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = (n - n3) / 2;
        if (!this.widgetsCreated) {
            this.createWidgets();
        }
        this.itemPanel.x = (n + n3) / 2 + 5;
        this.itemPanel.y = 20;
        this.itemPanel.resize();
        this.tabView.x = (n + n3) / 2 + 5;
        this.tabView.y = 0;
        this.tabView.width = n - this.itemPanel.x - 2;
        this.tabView.height = n2 - 1;
        savedTabName = this.tabView.getActiveChildName();
        this.tabView.resize();
        this.rain.state = TMIUtils.isRaining();
        this.delete.state = this.controller.deleteMode;
        int n7 = TMIUtils.getGameMode();
        this.survival.icon = n7 == 0 ? TMIImages.iconModeSs : TMIImages.iconModeS;
        this.creative.icon = n7 == 1 ? TMIImages.iconModeCs : TMIImages.iconModeC;
        this.adventure.icon = n7 == 2 ? TMIImages.iconModeAs : TMIImages.iconModeA;
        this.canvas.drawRect(0, 0, n, 18, -16445675);
        String string = "" + (TMIItemPanel.page + 1) + "/" + this.itemPanel.numPages;
        this.canvas.drawText(2, n2 - 13, "TMI 1.6.2 2013-07-09by974778701", -1);
        this.rain.show = TMIConfig.canChangeWeather();
        this.survival.show = this.adventure.show = TMIConfig.canChangeCreativeMode();
        this.creative.show = this.adventure.show;
        this.delete.show = TMIConfig.canDelete();
        this.dusk.show = this.midnight.show = TMIConfig.canChangeTime();
        this.noon.show = this.midnight.show;
        this.dawn.show = this.midnight.show;
        this.difficulty.show = TMIConfig.canChangeDifficulty();
        this.health.show = !TMIConfig.isMultiplayer();
        boolean bl = TMIConfig.canRestoreSaves();
        int n8 = 0;
        for (n5 = 0; n5 < this.config.getNumSaves(); ++n5) {
            this.deleteButtons[n5].x = -1000;
            this.stateButtons[n5].y = 30 + n5 * 22;
            this.stateButtons[n5].height = 20;
            String string2 = this.config.getSettings().get("save-name" + (n5 + 1));
            if (string2 == null) {
                string2 = "" + (n5 + 1);
            }
            this.stateButtons[n5].label = this.config.isStateSaved(n5) ? "\u8bfb\u53d6 " + string2 : "\u4fdd\u5b58 " + string2;
            int n9 = this.canvas.getTextWidth(this.stateButtons[n5].label) + 26;
            if (n9 + 2 + 20 > n6) {
                n9 = n6 - 20 - 2;
            }
            if (n9 <= n8) continue;
            n8 = n9;
        }
        for (n5 = 0; n5 < this.config.getNumSaves(); ++n5) {
            this.stateButtons[n5].width = n8;
            this.stateButtons[n5].show = bl;
            this.deleteButtons[n5].show = bl;
            if (!this.config.isStateSaved(n5)) continue;
            this.deleteButtons[n5].x = this.stateButtons[n5].width + 2;
            this.deleteButtons[n5].y = this.stateButtons[n5].y;
            this.deleteButtons[n5].width = 20;
            this.deleteButtons[n5].height = 20;
        }
    }

    public void determineTooltip(int n, int n2) {
        if (this.rain != null && this.rain.contains(n, n2)) {
            this.setTooltip("\u96e8/\u96ea\u5929\u6c14\u4e3a " + (this.rain.state ? "\u5f00" : "\u5173"));
        } else if (this.creative != null && this.creative.contains(n, n2)) {
            this.setTooltip("\u521b\u9020\u6a21\u5f0f");
        } else if (this.survival != null && this.survival.contains(n, n2)) {
            this.setTooltip("\u751f\u5b58\u6a21\u5f0f");
        } else if (this.adventure != null && this.adventure.contains(n, n2)) {
            this.setTooltip("\u5192\u9669\u6a21\u5f0f");
        } else if (this.noon != null && this.noon.contains(n, n2)) {
            this.setTooltip("\u8bbe\u5b9a\u65f6\u95f4\u4e3a\u6b63\u5348");
        } else if (this.dawn != null && this.dawn.contains(n, n2)) {
            this.setTooltip("\u8bbe\u5b9a\u65f6\u95f4\u4e3a\u65e5\u51fa");
        } else if (this.dusk != null && this.dusk.contains(n, n2)) {
            this.setTooltip("\u8bbe\u5b9a\u65f6\u95f4\u4e3a\u65e5\u843d");
        } else if (this.midnight != null && this.midnight.contains(n, n2)) {
            this.setTooltip("\u8bbe\u7f6e\u65f6\u95f4\u4e3a\u5348\u591c");
        } else if (this.difficulty != null && this.difficulty.contains(n, n2)) {
            this.setTooltip(TMIUtils.getDifficultyString());
        } else if (this.health != null && this.health.contains(n, n2)) {
            this.setTooltip("\u56de\u590d\u751f\u547d\u503c\u548c\u9965\u997f\u503c");
        } else if (this.delete != null && this.delete.contains(n, n2)) {
            yd yd2 = TMIUtils.getHeldItem();
            if (yd2 == null) {
                if (TMIUtils.shiftKey()) {
                    this.setTooltip("\u4ece\u5f53\u524d\u7269\u54c1\u680f\u5220\u9664\u6240\u6709\u7269\u54c1");
                } else {
                    this.setTooltip("\u5220\u9664\u6a21\u5f0f\u4e3a " + (this.delete.state ? "\u5f00" : "\u5173"));
                }
            } else if (TMIUtils.shiftKey()) {
                this.setTooltip("\u5220\u9664\u5168\u90e8 " + TMIUtils.itemDisplayName(yd2));
            } else {
                this.setTooltip("\u5220\u9664 " + TMIUtils.itemDisplayName(yd2));
            }
        } else if (this.itemPanel.contains(n, n2)) {
            yd yd3 = TMIUtils.getHeldItem();
            if (yd3 == null) {
                yd yd4 = this.itemPanel.getHoverItem();
                if (yd4 != null) {
                    if (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) {
                        this.setTooltip("\u6dfb\u52a0 " + yd4.d + ":" + yd4.j() + " \u5230\u6536\u85cf\u5939");
                    } else {
                        List<String> list = TMIUtils.itemDisplayNameMultiline(yd4, true);
                        this.canvas.drawMultilineTip(n, n2, list, yd4);
                    }
                }
            } else {
                this.setTooltip("\u5220\u9664 " + TMIUtils.itemDisplayName(yd3));
            }
        } else if (this.favoritesPanel.contains(n, n2)) {
            yd yd5 = TMIUtils.getHeldItem();
            if (yd5 == null) {
                yd yd6 = this.favoritesPanel.getHoverItem();
                if (yd6 != null) {
                    if (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) {
                        this.setTooltip("\u79fb\u9664 " + TMIUtils.itemDisplayName(yd6));
                    } else {
                        List<String> list = TMIUtils.itemDisplayNameMultiline(yd6, true);
                        this.canvas.drawMultilineTip(n, n2, list, yd6);
                    }
                }
            } else {
                this.setTooltip("\u6dfb\u52a0 " + TMIUtils.itemDisplayName(yd5));
            }
        }
        this.showToolTip(n, n2);
    }

    public boolean isInitialized() {
        return this.widgetsCreated;
    }

    public void setTooltip(String string) {
        this.activeTooltip = string;
    }

    public String getTooltip() {
        return this.activeTooltip;
    }

    public boolean hasTooltip() {
        return this.activeTooltip != null;
    }

    public void showToolTip(int n, int n2) {
        if (this.activeTooltip != null) {
            this.canvas.drawTip(n, n2, this.activeTooltip);
        }
    }
}

