/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import atomicstryker.dynamiclights.client.ItemConfigHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_dropItems", name="Dynamic Lights on ItemEntities", version="1.0.4", dependencies="required-after:DynamicLights")
public class DroppedItemsLightSource {
    private ats mcinstance;
    private long nextUpdate;
    private long updateInterval;
    private ArrayList<EntityItemAdapter> trackedItems;
    private Thread thread;
    private boolean threadRunning;
    private ItemConfigHelper itemsMap;
    private ItemConfigHelper notWaterProofItems;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property itemsList = config.get("general", "LightItems", "50,89=12,348=10,91,327,76=10,331=10,314=14");
        itemsList.comment = "Item IDs that shine light when dropped in the World.";
        this.itemsMap = new ItemConfigHelper(itemsList.getString(), 15);
        Property updateI = config.get("general", "update Interval", 1000);
        updateI.comment = "Update Interval time for all Item entities in milliseconds. The lower the better and costlier.";
        this.updateInterval = updateI.getInt();
        Property notWaterProofList = config.get("general", "TurnedOffByWaterItems", "50,327");
        notWaterProofList.comment = "Item IDs that do not shine light when dropped and in water, have to be present in LightItems.";
        this.notWaterProofItems = new ItemConfigHelper(notWaterProofList.getString(), 1);
        config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        this.mcinstance = FMLClientHandler.instance().getClient();
        this.nextUpdate = System.currentTimeMillis();
        this.trackedItems = new ArrayList();
        this.threadRunning = false;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    private int getLightFromItemStack(yd stack) {
        if (stack != null) {
            int r = this.itemsMap.retrieveValue(stack.d, stack.k());
            return r < 0 ? 0 : r;
        }
        return 0;
    }

    private class EntityItemAdapter
    implements IDynamicLightSource {
        private sr entity;
        private int lightLevel = 0;
        private boolean enabled = false;
        private boolean notWaterProof;

        public EntityItemAdapter(sr eI) {
            this.entity = eI;
            this.notWaterProof = DroppedItemsLightSource.this.notWaterProofItems.retrieveValue(eI.d().d, eI.d().k()) == 1;
        }

        public void onTick() {
            if (this.entity.ae()) {
                this.lightLevel = 15;
            } else {
                this.lightLevel = DroppedItemsLightSource.this.getLightFromItemStack(this.entity.d());
                if (this.notWaterProof && this.entity.q.g(lr.c((double)this.entity.u), lr.c((double)this.entity.v), lr.c((double)this.entity.w)) == ajz.h) {
                    this.lightLevel = 0;
                }
            }
            if (!this.enabled && this.lightLevel > 8) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 9) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public nm getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.notWaterProof && this.entity.G() ? 0 : this.lightLevel;
        }
    }

    private class EntityListChecker
    extends Thread {
        private final Object[] list;

        public EntityListChecker(List<nm> input) {
            this.list = input.toArray();
        }

        @Override
        public void run() {
            ArrayList<EntityItemAdapter> newList = new ArrayList<EntityItemAdapter>();
            for (Object o : this.list) {
                nm ent = (nm)o;
                if (!(ent instanceof sr) || !ent.S()) continue;
                boolean found = false;
                Iterator iter = DroppedItemsLightSource.this.trackedItems.iterator();
                EntityItemAdapter adapter = null;
                while (iter.hasNext()) {
                    adapter = (EntityItemAdapter)iter.next();
                    if (!adapter.getAttachmentEntity().equals((Object)ent)) continue;
                    adapter.onTick();
                    newList.add(adapter);
                    found = true;
                    iter.remove();
                    break;
                }
                if (found) continue;
                adapter = new EntityItemAdapter((sr)ent);
                adapter.onTick();
                newList.add(adapter);
            }
            DroppedItemsLightSource.this.trackedItems = newList;
            DroppedItemsLightSource.this.threadRunning = false;
        }
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet<TickType> ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            if (((DroppedItemsLightSource)DroppedItemsLightSource.this).mcinstance.f != null && System.currentTimeMillis() > DroppedItemsLightSource.this.nextUpdate && !DynamicLights.globalLightsOff()) {
                DroppedItemsLightSource.this.nextUpdate = System.currentTimeMillis() + DroppedItemsLightSource.this.updateInterval;
                if (!DroppedItemsLightSource.this.threadRunning) {
                    DroppedItemsLightSource.this.thread = new EntityListChecker(((DroppedItemsLightSource)DroppedItemsLightSource.this).mcinstance.f.e);
                    DroppedItemsLightSource.this.thread.setPriority(1);
                    DroppedItemsLightSource.this.thread.start();
                    DroppedItemsLightSource.this.threadRunning = true;
                }
            }
        }

        public EnumSet<TickType> ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_dropItems";
        }
    }
}

