/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.ITickCallback;
import ic2.core.WorldData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;

public final class EnergyNet {
    public static final double minConductionLoss = 1.0E-4;
    private static final Direction[] directions = Direction.values();
    private final Map<Tile, List<EnergyPath>> energySourceToEnergyPathMap = new HashMap<Tile, List<EnergyPath>>();
    private final Map<EntityLivingBase, Integer> entityLivingToShockEnergyMap = new HashMap<EntityLivingBase, Integer>();
    private final Map<ChunkCoordinates, Tile> registeredTiles = new HashMap<ChunkCoordinates, Tile>();
    private static int apiDemandsErrorCooldown = 0;
    private static int apiEmitErrorCooldown = 0;

    public static void initialize() {
        new EventHandler();
    }

    public static EnergyNet getForWorld(World world) {
        WorldData worldData = WorldData.get(world);
        return worldData.energyNet;
    }

    public static void onTick(World world) {
        IC2.platform.profilerStartSection("Shocking");
        EnergyNet energyNet = EnergyNet.getForWorld(world);
        for (Map.Entry<EntityLivingBase, Integer> entry : energyNet.entityLivingToShockEnergyMap.entrySet()) {
            EntityLivingBase target = entry.getKey();
            int damage = (entry.getValue() + 63) / 64;
            if (!target.func_70089_S()) continue;
            target.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
        }
        energyNet.entityLivingToShockEnergyMap.clear();
        if (world.field_73011_w.field_76574_g == 0) {
            if (apiDemandsErrorCooldown > 0) {
                --apiDemandsErrorCooldown;
            }
            if (apiEmitErrorCooldown > 0) {
                --apiEmitErrorCooldown;
            }
        }
        IC2.platform.profilerEndSection();
    }

    protected EnergyNet() {
    }

    public void addTileEntity(TileEntity te) {
        if (!IC2.platform.isSimulating()) {
            IC2.log.warning("EnergyNet.addTileEntity: called for " + te + " client-side, aborting");
            return;
        }
        if (!(te instanceof IEnergyTile)) {
            IC2.log.warning("EnergyNet.addTileEntity: " + te + " doesn't implement IEnergyTile, aborting");
            return;
        }
        if (te.func_70320_p()) {
            IC2.log.warning("EnergyNet.addTileEntity: " + te + " is invalid (TileEntity.isInvalid()), aborting");
            return;
        }
        ChunkCoordinates coords = new ChunkCoordinates(te.field_70329_l, te.field_70330_m, te.field_70327_n);
        if (this.registeredTiles.containsKey(coords)) {
            IC2.log.warning("EnergyNet.addTileEntity: " + te + " is already added, aborting");
            return;
        }
        if (!te.field_70331_k.func_72899_e(te.field_70329_l, te.field_70330_m, te.field_70327_n)) {
            IC2.log.warning("EnergyNet.addTileEntity: " + te + " was added too early, postponing");
            IC2.addSingleTickCallback(te.field_70331_k, new PostPonedAddCallback(te));
            return;
        }
        Tile tile = new Tile(te);
        this.registeredTiles.put(coords, tile);
        if (te instanceof IEnergyAcceptor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                Tile srcTile = reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)((IEnergySource)srcTile.entity).getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                this.energySourceToEnergyPathMap.remove(srcTile);
            }
        }
        if (te instanceof IEnergySource) {
            // empty if block
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int x = te.field_70329_l + dir.offsetX;
            int y = te.field_70330_m + dir.offsetY;
            int z = te.field_70327_n + dir.offsetZ;
            if (!te.field_70331_k.func_72899_e(x, y, z)) continue;
            te.field_70331_k.func_72821_m(x, y, z, te.func_70311_o().field_71990_ca);
        }
    }

    public void removeTileEntity(TileEntity te) {
        if (!IC2.platform.isSimulating()) {
            IC2.log.warning("EnergyNet.removeTileEntity: called for " + te + " client-side, aborting");
            return;
        }
        if (!(te instanceof IEnergyTile)) {
            IC2.log.warning("EnergyNet.removeTileEntity: " + te + " doesn't implement IEnergyTile, aborting");
            return;
        }
        ChunkCoordinates coords = new ChunkCoordinates(te.field_70329_l, te.field_70330_m, te.field_70327_n);
        Tile tile = this.registeredTiles.get(coords);
        if (tile == null) {
            IC2.log.warning("EnergyNet.removeTileEntity: " + te + " is already removed, aborting");
            return;
        }
        if (te instanceof IEnergyAcceptor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
            block0: for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                Tile srcTile = reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)((IEnergySource)srcTile.entity).getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                if (te instanceof IEnergyConductor) {
                    this.energySourceToEnergyPathMap.remove(srcTile);
                    continue;
                }
                Iterator<EnergyPath> it = this.energySourceToEnergyPathMap.get(srcTile).iterator();
                while (it.hasNext()) {
                    if (it.next().target != tile) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
        if (te instanceof IEnergySource) {
            this.energySourceToEnergyPathMap.remove(tile);
        }
        tile.destroy();
        this.registeredTiles.remove(coords);
        if (te.field_70331_k.func_72899_e(te.field_70329_l, te.field_70330_m, te.field_70327_n)) {
            Block block = te.func_70311_o();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int x = te.field_70329_l + dir.offsetX;
                int y = te.field_70330_m + dir.offsetY;
                int z = te.field_70327_n + dir.offsetZ;
                if (!te.field_70331_k.func_72899_e(x, y, z)) continue;
                te.field_70331_k.func_72821_m(x, y, z, block != null ? block.field_71990_ca : 0);
            }
        }
    }

    public int emitEnergyFrom(IEnergySource energySource, int amount) {
        if (!IC2.platform.isSimulating()) {
            if (apiEmitErrorCooldown == 0) {
                apiEmitErrorCooldown = 600;
                IC2.log.warning("EnergyNet.emitEnergyFrom: called for " + energySource + " client-side, aborting");
            }
            return amount;
        }
        if (!(energySource instanceof TileEntity)) {
            if (apiEmitErrorCooldown == 0) {
                apiEmitErrorCooldown = 600;
                IC2.log.warning("EnergyNet.emitEnergyFrom: " + energySource + " is no tile entity, aborting");
            }
            return amount;
        }
        TileEntity srcTe = (TileEntity)energySource;
        if (srcTe.func_70320_p()) {
            IC2.log.warning("EnergyNet.emitEnergyFrom: " + srcTe + " is invalid (TileEntity.isInvalid()), aborting");
            return amount;
        }
        ChunkCoordinates coords = new ChunkCoordinates(srcTe.field_70329_l, srcTe.field_70330_m, srcTe.field_70327_n);
        Tile tile = this.registeredTiles.get(coords);
        if (tile == null) {
            if (apiEmitErrorCooldown == 0) {
                apiEmitErrorCooldown = 600;
                IC2.log.warning("EnergyNet.emitEnergyFrom: " + energySource + " is not added to the enet, aborting");
            }
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(tile)) {
            this.energySourceToEnergyPathMap.put(tile, this.discover(tile, false, energySource.getMaxEnergyOutput()));
        }
        Vector<EnergyPath> activeEnergyPaths = new Vector<EnergyPath>();
        double totalInvLoss = 0.0;
        for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tile)) {
            IEnergySink sink = (IEnergySink)energyPath.target.entity;
            if (sink.demandsEnergy() <= 0 || !(energyPath.loss < (double)amount)) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
        }
        Collections.shuffle(activeEnergyPaths);
        for (int i = activeEnergyPaths.size() - amount; i > 0; --i) {
            EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
            totalInvLoss -= 1.0 / removedEnergyPath.loss;
        }
        HashMap<EnergyPath, Integer> suppliedEnergyPaths = new HashMap<EnergyPath, Integer>();
        while (!activeEnergyPaths.isEmpty() && amount > 0) {
            int energyConsumed = 0;
            double newTotalInvLoss = 0.0;
            Vector<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new Vector();
            activeEnergyPaths.iterator();
            for (EnergyPath energyPath : currentActiveEnergyPaths) {
                int energyLoss;
                Tile dstTile = energyPath.target;
                IEnergySink sink = (IEnergySink)dstTile.entity;
                int energyProvided = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath.loss * 100000.0) / 100000.0);
                if (energyProvided > (energyLoss = (int)Math.floor(energyPath.loss))) {
                    int energyReturned = sink.injectEnergy(energyPath.targetDirection, energyProvided - energyLoss);
                    if (energyReturned == 0 && sink.demandsEnergy() > 0) {
                        activeEnergyPaths.add(energyPath);
                        newTotalInvLoss += 1.0 / energyPath.loss;
                    } else if (energyReturned >= energyProvided - energyLoss) {
                        energyReturned = energyProvided - energyLoss;
                        if (apiDemandsErrorCooldown == 0) {
                            apiDemandsErrorCooldown = 600;
                            TileEntity te = dstTile.entity;
                            String c = (te.field_70331_k == null ? "unknown" : Integer.valueOf(te.field_70331_k.field_73011_w.field_76574_g)) + ":" + te.field_70329_l + "," + te.field_70330_m + "," + te.field_70327_n;
                            IC2.log.warning("API ERROR: " + dstTile + " (" + c + ") didn't implement demandsEnergy() properly, no energy from injectEnergy accepted (" + energyReturned + ") although demandsEnergy() requested " + (energyProvided - energyLoss) + ".");
                        }
                    }
                    energyConsumed += energyProvided - energyReturned;
                    int energyInjected = energyProvided - energyLoss - energyReturned;
                    if (!suppliedEnergyPaths.containsKey(energyPath)) {
                        suppliedEnergyPaths.put(energyPath, energyInjected);
                        continue;
                    }
                    suppliedEnergyPaths.put(energyPath, energyInjected + (Integer)suppliedEnergyPaths.get(energyPath));
                    continue;
                }
                activeEnergyPaths.add(energyPath);
                newTotalInvLoss += 1.0 / energyPath.loss;
            }
            if (energyConsumed == 0 && !activeEnergyPaths.isEmpty()) {
                EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
                newTotalInvLoss -= 1.0 / removedEnergyPath.loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath energyPath = (EnergyPath)entry.getKey();
            int energyInjected = (Integer)entry.getValue();
            energyPath.totalEnergyConducted += (long)energyInjected;
            if (energyInjected > energyPath.minInsulationEnergyAbsorption) {
                List entitiesNearEnergyPath = srcTe.field_70331_k.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(energyPath.minX - 1), (double)(energyPath.minY - 1), (double)(energyPath.minZ - 1), (double)(energyPath.maxX + 2), (double)(energyPath.maxY + 2), (double)(energyPath.maxZ + 2)));
                for (EntityLivingBase entityLiving : entitiesNearEnergyPath) {
                    int maxShockEnergy = 0;
                    for (Tile condTile : energyPath.conductors) {
                        TileEntity te = condTile.entity;
                        IEnergyConductor conductor = (IEnergyConductor)te;
                        if (!entityLiving.field_70121_D.func_72326_a(AxisAlignedBB.func_72330_a((double)(te.field_70329_l - 1), (double)(te.field_70330_m - 1), (double)(te.field_70327_n - 1), (double)(te.field_70329_l + 2), (double)(te.field_70330_m + 2), (double)(te.field_70327_n + 2)))) continue;
                        int shockEnergy = energyInjected - conductor.getInsulationEnergyAbsorption();
                        if (shockEnergy > maxShockEnergy) {
                            maxShockEnergy = shockEnergy;
                        }
                        if (conductor.getInsulationEnergyAbsorption() != energyPath.minInsulationEnergyAbsorption) continue;
                        break;
                    }
                    if (this.entityLivingToShockEnergyMap.containsKey(entityLiving)) {
                        this.entityLivingToShockEnergyMap.put(entityLiving, this.entityLivingToShockEnergyMap.get(entityLiving) + maxShockEnergy);
                        continue;
                    }
                    this.entityLivingToShockEnergyMap.put(entityLiving, maxShockEnergy);
                }
                if (energyInjected >= energyPath.minInsulationBreakdownEnergy) {
                    for (Tile condTile : energyPath.conductors) {
                        IEnergyConductor conductor = (IEnergyConductor)condTile.entity;
                        if (energyInjected < conductor.getInsulationBreakdownEnergy()) continue;
                        conductor.removeInsulation();
                        if (conductor.getInsulationEnergyAbsorption() >= energyPath.minInsulationEnergyAbsorption) continue;
                        energyPath.minInsulationEnergyAbsorption = conductor.getInsulationEnergyAbsorption();
                    }
                }
            }
            if (energyInjected < energyPath.minConductorBreakdownEnergy) continue;
            for (Tile condTile : energyPath.conductors) {
                IEnergyConductor conductor = (IEnergyConductor)condTile.entity;
                if (energyInjected < conductor.getConductorBreakdownEnergy()) continue;
                conductor.removeConductor();
            }
        }
        return amount;
    }

    @Deprecated
    public long getTotalEnergyConducted(TileEntity tileEntity) {
        Tile tile = this.registeredTiles.get(new ChunkCoordinates(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n));
        if (tile == null) {
            IC2.log.warning("EnergyNet.getTotalEnergyConducted: " + tileEntity + " is not added to the enet, aborting");
            return 0L;
        }
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                Tile srcTile = reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)((IEnergySource)srcTile.entity).getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(srcTile)) {
                    if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tile) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tile))) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tile)) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tile)) {
                ret += energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    public long getTotalEnergyEmitted(TileEntity tileEntity) {
        Tile tile = this.registeredTiles.get(new ChunkCoordinates(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n));
        if (tile == null) {
            IC2.log.warning("EnergyNet.getTotalEnergyEmitted: " + tileEntity + " is not added to the enet, aborting");
            return 0L;
        }
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                Tile srcTile = reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)((IEnergySource)srcTile.entity).getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(srcTile)) {
                    if (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tile)) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tile)) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tile)) {
                ret += energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    public long getTotalEnergySunken(TileEntity tileEntity) {
        Tile tile = this.registeredTiles.get(new ChunkCoordinates(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n));
        if (tile == null) {
            IC2.log.warning("EnergyNet.getTotalEnergySunken: " + tileEntity + " is not added to the enet, aborting");
            return 0L;
        }
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                Tile srcTile = reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)((IEnergySource)srcTile.entity).getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(srcTile)) {
                    if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tile) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tile))) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        return ret;
    }

    public TileEntity getTileEntity(int x, int y, int z) {
        Tile ret = this.registeredTiles.get(new ChunkCoordinates(x, y, z));
        if (ret == null) {
            return null;
        }
        return ret.entity;
    }

    public TileEntity getNeighbor(TileEntity te, Direction dir) {
        switch (dir) {
            case XN: {
                return this.getTileEntity(te.field_70329_l - 1, te.field_70330_m, te.field_70327_n);
            }
            case XP: {
                return this.getTileEntity(te.field_70329_l + 1, te.field_70330_m, te.field_70327_n);
            }
            case YN: {
                return this.getTileEntity(te.field_70329_l, te.field_70330_m - 1, te.field_70327_n);
            }
            case YP: {
                return this.getTileEntity(te.field_70329_l, te.field_70330_m + 1, te.field_70327_n);
            }
            case ZN: {
                return this.getTileEntity(te.field_70329_l, te.field_70330_m, te.field_70327_n - 1);
            }
            case ZP: {
                return this.getTileEntity(te.field_70329_l, te.field_70330_m, te.field_70327_n + 1);
            }
        }
        return null;
    }

    public Tile getNeighbor(Tile te, Direction dir) {
        return te.neighbors[dir.ordinal()];
    }

    private List<EnergyPath> discover(Tile emitter, boolean reverse, int lossLimit) {
        HashMap<Tile, EnergyBlockLink> reachedTileEntities = new HashMap<Tile, EnergyBlockLink>();
        LinkedList<Tile> tileEntitiesToCheck = new LinkedList<Tile>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            Tile tile = (Tile)tileEntitiesToCheck.remove();
            if (tile.entity.func_70320_p()) continue;
            double currentLoss = 0.0;
            if (tile != emitter) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)tile)).loss;
            }
            List<EnergyTarget> validReceivers = this.getValidReceivers(tile, reverse);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tile == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tile.entity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tile.entity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tile) && !(((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tile)).loss > currentLoss + additionalLoss)) continue;
                reachedTileEntities.put(validReceiver.tile, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (!(validReceiver.tile.entity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tile);
                tileEntitiesToCheck.add(validReceiver.tile);
            }
        }
        LinkedList<EnergyPath> energyPaths = new LinkedList<EnergyPath>();
        block2: for (Map.Entry entry : reachedTileEntities.entrySet()) {
            Tile tile = (Tile)entry.getKey();
            if ((reverse || !(tile.entity instanceof IEnergySink)) && (!reverse || !(tile.entity instanceof IEnergySource))) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = energyBlockLink.loss > 0.1 ? energyBlockLink.loss : 0.1;
            energyPath.target = tile;
            energyPath.targetDirection = energyBlockLink.direction;
            if (!reverse && emitter.entity instanceof IEnergySource) {
                while ((tile = this.getNeighbor(tile, energyBlockLink.direction)) != emitter) {
                    if (tile.entity instanceof IEnergyConductor) {
                        TileEntity te = tile.entity;
                        IEnergyConductor energyConductor = (IEnergyConductor)te;
                        if (te.field_70329_l < energyPath.minX) {
                            energyPath.minX = te.field_70329_l;
                        }
                        if (te.field_70330_m < energyPath.minY) {
                            energyPath.minY = te.field_70330_m;
                        }
                        if (te.field_70327_n < energyPath.minZ) {
                            energyPath.minZ = te.field_70327_n;
                        }
                        if (te.field_70329_l > energyPath.maxX) {
                            energyPath.maxX = te.field_70329_l;
                        }
                        if (te.field_70330_m > energyPath.maxY) {
                            energyPath.maxY = te.field_70330_m;
                        }
                        if (te.field_70327_n > energyPath.maxZ) {
                            energyPath.maxZ = te.field_70327_n;
                        }
                        energyPath.conductors.add(tile);
                        if (energyConductor.getInsulationEnergyAbsorption() < energyPath.minInsulationEnergyAbsorption) {
                            energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                        }
                        if (energyConductor.getInsulationBreakdownEnergy() < energyPath.minInsulationBreakdownEnergy) {
                            energyPath.minInsulationBreakdownEnergy = energyConductor.getInsulationBreakdownEnergy();
                        }
                        if (energyConductor.getConductorBreakdownEnergy() < energyPath.minConductorBreakdownEnergy) {
                            energyPath.minConductorBreakdownEnergy = energyConductor.getConductorBreakdownEnergy();
                        }
                        if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tile)) != null) continue;
                        TileEntity srcTe = emitter.entity;
                        TileEntity dstTe = energyPath.target.entity;
                        IC2.platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + srcTe + " (" + srcTe.field_70329_l + "," + srcTe.field_70330_m + "," + srcTe.field_70327_n + ")\n" + "C: " + te + " (" + te.field_70329_l + "," + te.field_70330_m + "," + te.field_70327_n + ")\n" + "R: " + dstTe + " (" + dstTe.field_70329_l + "," + dstTe.field_70330_m + "," + dstTe.field_70327_n + ")");
                        continue;
                    }
                    IC2.log.warning("EnergyNet: EnergyBlockLink corrupted (" + energyPath.target.entity + " [" + energyPath.target.entity.field_70329_l + " " + energyPath.target.entity.field_70330_m + " " + energyPath.target.entity.field_70327_n + "] -> " + tile.entity + " [" + tile.entity.field_70329_l + " " + tile.entity.field_70330_m + " " + tile.entity.field_70327_n + "] -> " + emitter.entity + " [" + emitter.entity.field_70329_l + " " + emitter.entity.field_70330_m + " " + emitter.entity.field_70327_n + "])");
                    continue block2;
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    private List<EnergyTarget> getValidReceivers(Tile emitter, boolean reverse) {
        LinkedList<EnergyTarget> validReceivers = new LinkedList<EnergyTarget>();
        for (Direction direction : directions) {
            Tile target = this.getNeighbor(emitter, direction);
            if (target == null) continue;
            Direction inverseDirection = direction.getInverse();
            if ((reverse || !(emitter.entity instanceof IEnergyEmitter) || !((IEnergyEmitter)emitter.entity).emitsEnergyTo(target.entity, direction)) && (!reverse || !(emitter.entity instanceof IEnergyAcceptor) || !((IEnergyAcceptor)emitter.entity).acceptsEnergyFrom(target.entity, direction)) || (reverse || !(target.entity instanceof IEnergyAcceptor) || !((IEnergyAcceptor)target.entity).acceptsEnergyFrom(emitter.entity, inverseDirection)) && (!reverse || !(target.entity instanceof IEnergyEmitter) || !((IEnergyEmitter)target.entity).emitsEnergyTo(emitter.entity, inverseDirection))) continue;
            validReceivers.add(new EnergyTarget(target, inverseDirection));
        }
        return validReceivers;
    }

    private static class PostPonedAddCallback
    implements ITickCallback {
        private final TileEntity te;

        public PostPonedAddCallback(TileEntity te) {
            this.te = te;
        }

        @Override
        public void tickCallback(World world) {
            if (world.func_72899_e(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n) && !this.te.func_70320_p()) {
                EnergyNet.getForWorld(world).addTileEntity(this.te);
            } else {
                IC2.log.info("EnergyNet.addTileEntity: " + this.te + " unloaded, aborting");
            }
        }
    }

    class Tile {
        final TileEntity entity;
        final Tile[] neighbors = new Tile[6];

        Tile(TileEntity te) {
            this.entity = te;
            for (Direction dir : Direction.directions) {
                ForgeDirection fdir = dir.toForgeDirection();
                ChunkCoordinates coords = new ChunkCoordinates(te.field_70329_l + fdir.offsetX, te.field_70330_m + fdir.offsetY, te.field_70327_n + fdir.offsetZ);
                int index = dir.ordinal();
                this.neighbors[index] = (Tile)EnergyNet.this.registeredTiles.get(coords);
                if (this.neighbors[index] == null) continue;
                this.neighbors[index].neighbors[dir.getInverse().ordinal()] = this;
            }
        }

        void destroy() {
            for (Direction dir : Direction.directions) {
                Tile neighbor = this.neighbors[dir.ordinal()];
                if (neighbor == null) continue;
                neighbor.neighbors[dir.getInverse().ordinal()] = null;
            }
        }
    }

    static class EnergyTarget {
        Tile tile;
        Direction direction;

        EnergyTarget(Tile tile, Direction direction) {
            this.tile = tile;
            this.direction = direction;
        }
    }

    static class EnergyBlockLink {
        Direction direction;
        double loss;

        EnergyBlockLink(Direction direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    static class EnergyPath {
        Tile target = null;
        Direction targetDirection;
        Set<Tile> conductors = new HashSet<Tile>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        double loss = 0.0;
        int minInsulationEnergyAbsorption = Integer.MAX_VALUE;
        int minInsulationBreakdownEnergy = Integer.MAX_VALUE;
        int minConductorBreakdownEnergy = Integer.MAX_VALUE;
        long totalEnergyConducted = 0L;

        EnergyPath() {
        }
    }

    public static class EventHandler {
        public EventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @ForgeSubscribe
        public void onEnergyTileLoad(EnergyTileLoadEvent event) {
            EnergyNet.getForWorld(event.world).addTileEntity((TileEntity)event.energyTile);
        }

        @ForgeSubscribe
        public void onEnergyTileUnload(EnergyTileUnloadEvent event) {
            EnergyNet.getForWorld(event.world).removeTileEntity((TileEntity)event.energyTile);
        }

        @ForgeSubscribe
        public void onEnergyTileSource(EnergyTileSourceEvent event) {
            event.amount = EnergyNet.getForWorld(event.world).emitEnergyFrom((IEnergySource)event.energyTile, event.amount);
        }
    }
}

