/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityTesla
extends TileEntityBlock
implements IEnergySink {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 10000;
    public int maxInput = 128;
    public boolean addedToEnergyNet = false;

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!IC2.platform.isSimulating() || !this.redstoned()) {
            return;
        }
        if (this.energy < TileEntityTesla.getCost()) {
            return;
        }
        int damage = this.energy / TileEntityTesla.getCost();
        --this.energy;
        if (this.ticker++ % 32 == 0 && this.shock(damage)) {
            this.energy = 0;
        }
    }

    public boolean shock(int damage) {
        boolean shock = false;
        List list1 = this.field_70331_k.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 4), (double)(this.field_70330_m - 4), (double)(this.field_70327_n - 4), (double)(this.field_70329_l + 5), (double)(this.field_70330_m + 5), (double)(this.field_70327_n + 5)));
        for (int l = 0; l < list1.size(); ++l) {
            EntityLivingBase victim = (EntityLivingBase)list1.get(l);
            if (ItemArmorHazmat.hasCompleteHazmat(victim)) continue;
            shock = true;
            victim.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
            for (int i = 0; i < damage; ++i) {
                this.field_70331_k.func_72869_a("reddust", victim.field_70165_t + (double)this.field_70331_k.field_73012_v.nextFloat(), victim.field_70163_u + (double)(this.field_70331_k.field_73012_v.nextFloat() * 2.0f), victim.field_70161_v + (double)this.field_70331_k.field_73012_v.nextFloat(), 0.0, 0.0, 1.0);
            }
        }
        return shock;
    }

    public boolean redstoned() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) || this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public static int getCost() {
        return 400;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public int demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0;
        }
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }
}

