/*
 * Decompiled with CFR 0.152.
 */
package muchmorechickens.common.entity.creatures;

import com.google.common.collect.Sets;
import java.util.Set;
import muchmorechickens.common.entity.ai.EntityAIFollow2;
import muchmorechickens.common.entity.ai.EntityAIMateAnimal;
import muchmorechickens.common.entity.classes.EntityModAnimal;
import muchmorechickens.common.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityEasterChicken
extends EntityModAnimal {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public int timeUntilNextEgg;
    public int timeUntilNextDrop;
    public boolean chickenJockey;
    public int DropNum;

    public EntityEasterChicken(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.7f);
        this.timeUntilNextEgg = this.field_70146_Z.nextInt(1200) + 1200;
        this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
        this.DropNum = this.field_70146_Z.nextInt(45);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateAnimal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollow2(this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (!(this.field_70170_p.field_72995_K || this.func_70631_g_() || this.isChickenJockey() || --this.timeUntilNextDrop > 0)) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.ChangeDrop();
        }
    }

    public void ChangeDrop() {
        switch (this.DropNum) {
            case 1: {
                this.func_70099_a(new ItemStack(ModItems.andesite_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 2: {
                this.func_70099_a(new ItemStack(ModItems.blaze_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 3: {
                this.func_70099_a(new ItemStack(ModItems.bone_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 4: {
                this.func_70099_a(new ItemStack(ModItems.boom_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 5: {
                this.func_70099_a(new ItemStack(ModItems.cacao_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 6: {
                this.func_70099_a(new ItemStack(ModItems.chorus_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 7: {
                this.func_70099_a(new ItemStack(ModItems.coal_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 8: {
                this.func_70099_a(new ItemStack(ModItems.cobblestone_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 9: {
                this.func_70099_a(new ItemStack(ModItems.diamond_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 10: {
                this.func_70099_a(new ItemStack(ModItems.diorite_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 11: {
                this.func_70099_a(new ItemStack(ModItems.dirt_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 12: {
                this.func_70099_a(new ItemStack(ModItems.emerald_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 13: {
                this.func_70099_a(new ItemStack(ModItems.end_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 14: {
                this.func_70099_a(new ItemStack(ModItems.ender_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 15: {
                this.func_70099_a(new ItemStack(ModItems.frost_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 16: {
                this.func_70099_a(new ItemStack(ModItems.glowstone_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 17: {
                this.func_70099_a(new ItemStack(ModItems.golden_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 18: {
                this.func_70099_a(new ItemStack(ModItems.granite_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 19: {
                this.func_70099_a(new ItemStack(ModItems.gravel_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 20: {
                this.func_70099_a(new ItemStack(ModItems.ink_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 21: {
                this.func_70099_a(new ItemStack(ModItems.iron_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 22: {
                this.func_70099_a(new ItemStack(ModItems.lapis_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 23: {
                this.func_70099_a(new ItemStack(ModItems.lava_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 24: {
                this.func_70099_a(new ItemStack(ModItems.mushroom_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 25: {
                this.func_70099_a(new ItemStack(ModItems.mycelium_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 26: {
                this.func_70099_a(new ItemStack(ModItems.nether_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 27: {
                this.func_70099_a(new ItemStack(ModItems.oak_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 28: {
                this.func_70099_a(new ItemStack(ModItems.obsidian_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 29: {
                this.func_70099_a(new ItemStack(ModItems.quartz_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 30: {
                this.func_70099_a(new ItemStack(ModItems.redmushroom_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 31: {
                this.func_70099_a(new ItemStack(ModItems.redsand_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 32: {
                this.func_70099_a(new ItemStack(ModItems.redstone_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 33: {
                this.func_70099_a(new ItemStack(ModItems.rose_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 34: {
                this.func_70099_a(new ItemStack(ModItems.sand_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 35: {
                this.func_70099_a(new ItemStack(ModItems.slime_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 36: {
                this.func_70099_a(new ItemStack(ModItems.snow_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 37: {
                this.func_70099_a(new ItemStack(ModItems.stone_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 38: {
                this.func_70099_a(new ItemStack(ModItems.wart_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 39: {
                this.func_70099_a(new ItemStack(ModItems.water_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 40: {
                this.func_70099_a(new ItemStack(ModItems.white_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 41: {
                this.func_70099_a(new ItemStack(ModItems.wither_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            case 42: {
                this.func_70099_a(new ItemStack(Items.field_151110_aK, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
                break;
            }
            default: {
                this.func_70099_a(new ItemStack(ModItems.easter_egg, 1), 0.0f);
                this.timeUntilNextDrop = this.field_70146_Z.nextInt(3000) + 3000;
                this.DropNum = this.field_70146_Z.nextInt(13);
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    public EntityEasterChicken createChild(EntityAgeable ageable) {
        return new EntityEasterChicken(this.field_70170_p);
    }

    @Override
    public boolean isBreedingItem(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Override
    protected int func_70693_a(EntityPlayer player) {
        return this.isChickenJockey() ? 10 : super.func_70693_a(player);
    }

    public static void registerFixesChicken(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, (String)"EasterChicken");
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.chickenJockey = compound.func_74767_n("IsChickenJockey");
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
        if (compound.func_74764_b("ItemLayTime")) {
            this.timeUntilNextDrop = compound.func_74762_e("ItemLayTime");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("IsChickenJockey", this.chickenJockey);
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
        compound.func_74768_a("ItemLayTime", this.timeUntilNextDrop);
    }

    @Override
    protected boolean func_70692_ba() {
        return this.isChickenJockey() && !this.func_184207_aI();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        passenger.func_70107_b(this.field_70165_t + (double)(0.1f * f), this.field_70163_u + (double)(this.field_70131_O * 0.5f) + passenger.func_70033_W() + 0.0, this.field_70161_v - (double)(0.1f * f1));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean isChickenJockey() {
        return this.chickenJockey;
    }

    public void setChickenJockey(boolean jockey) {
        this.chickenJockey = jockey;
    }
}

