/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.lwjgl.opengl.GL11;

public class CustomItemProperties {
    public String name = null;
    public String basePath = null;
    public int type = 1;
    public int[] items = null;
    public String texture = null;
    public Map<String, String> mapTextures = null;
    public RangeListInt damage = null;
    public boolean damagePercent = false;
    public int damageMask = 0;
    public RangeListInt stackSize = null;
    public RangeListInt enchantmentIds = null;
    public RangeListInt enchantmentLevels = null;
    public NbtTagValue[] nbtTagValues = null;
    public int blend = 1;
    public float speed = 0.0f;
    public float rotation = 0.0f;
    public int layer = 0;
    public float duration = 1.0f;
    public int weight = 0;
    public kn textureLocation = null;
    public Map mapTextureLocations = null;
    public bwe sprite = null;
    public Map mapSprites = null;
    public byl model = null;
    public Map<String, byl> mapModels = null;
    private int textureWidth = 0;
    private int textureHeight = 0;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_ITEM = 1;
    public static final int TYPE_ENCHANTMENT = 2;
    public static final int TYPE_ARMOR = 3;
    public static final int TYPE_ELYTRA = 4;

    public CustomItemProperties(Properties props, String path) {
        this.name = CustomItemProperties.parseName(path);
        this.basePath = CustomItemProperties.parseBasePath(path);
        this.type = this.parseType(props.getProperty("type"));
        this.items = this.parseItems(props.getProperty("items"), props.getProperty("matchItems"));
        this.mapTextures = CustomItemProperties.parseTextures(props, this.basePath);
        this.texture = CustomItemProperties.parseTexture(props.getProperty("texture"), props.getProperty("tile"), props.getProperty("source"), path, this.basePath, this.type, this.mapTextures);
        String damageStr = props.getProperty("damage");
        if (damageStr != null) {
            this.damagePercent = damageStr.contains("%");
            damageStr.replace("%", "");
            this.damage = this.parseRangeListInt(damageStr);
            this.damageMask = this.parseInt(props.getProperty("damageMask"), 0);
        }
        this.stackSize = this.parseRangeListInt(props.getProperty("stackSize"));
        this.enchantmentIds = this.parseRangeListInt(props.getProperty("enchantmentIDs"));
        this.enchantmentLevels = this.parseRangeListInt(props.getProperty("enchantmentLevels"));
        this.nbtTagValues = this.parseNbtTagValues(props);
        this.blend = Blender.parseBlend(props.getProperty("blend"));
        this.speed = this.parseFloat(props.getProperty("speed"), 0.0f);
        this.rotation = this.parseFloat(props.getProperty("rotation"), 0.0f);
        this.layer = this.parseInt(props.getProperty("layer"), 0);
        this.weight = this.parseInt(props.getProperty("weight"), 0);
        this.duration = this.parseFloat(props.getProperty("duration"), 1.0f);
    }

    private static String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    private static String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    private int parseType(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equals("item")) {
            return 1;
        }
        if (str.equals("enchantment")) {
            return 2;
        }
        if (str.equals("armor")) {
            return 3;
        }
        if (str.equals("elytra")) {
            return 4;
        }
        Config.warn("Unknown method: " + str);
        return 0;
    }

    private int[] parseItems(String str, String str2) {
        if (str == null) {
            str = str2;
        }
        if (str == null) {
            return null;
        }
        str = str.trim();
        TreeSet<Integer> setItemIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize(str, " ");
        for (int i = 0; i < tokens.length; ++i) {
            adx item;
            String[] parts;
            String token = tokens[i];
            int val = Config.parseInt(token, -1);
            if (val >= 0) {
                setItemIds.add(new Integer(val));
                continue;
            }
            if (token.contains("-") && (parts = Config.tokenize(token, "-")).length == 2) {
                int val1 = Config.parseInt(parts[0], -1);
                int val2 = Config.parseInt(parts[1], -1);
                if (val1 >= 0 && val2 >= 0) {
                    int min = Math.min(val1, val2);
                    int max = Math.max(val1, val2);
                    for (int x = min; x <= max; ++x) {
                        setItemIds.add(new Integer(x));
                    }
                    continue;
                }
            }
            if ((item = adx.d((String)token)) == null) {
                Config.warn("Item not found: " + token);
                continue;
            }
            int id = adx.a((adx)item);
            if (id < 0) {
                Config.warn("Item not found: " + token);
                continue;
            }
            setItemIds.add(new Integer(id));
        }
        Integer[] integers = setItemIds.toArray(new Integer[setItemIds.size()]);
        int[] ints = new int[integers.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = integers[i];
        }
        return ints;
    }

    private static String parseTexture(String texStr, String texStr2, String texStr3, String path, String basePath, int type, Map<String, String> mapTexs) {
        int pos2;
        String bowStandbyTex;
        if (texStr == null) {
            texStr = texStr2;
        }
        if (texStr == null) {
            texStr = texStr3;
        }
        if (texStr != null) {
            String png = ".png";
            if (texStr.endsWith(png)) {
                texStr = texStr.substring(0, texStr.length() - png.length());
            }
            texStr = CustomItemProperties.fixTextureName(texStr, basePath);
            return texStr;
        }
        if (type == 3) {
            return null;
        }
        if (mapTexs != null && (bowStandbyTex = mapTexs.get("texture.bow_standby")) != null) {
            return bowStandbyTex;
        }
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        str = CustomItemProperties.fixTextureName(str, basePath);
        return str;
    }

    private static Map parseTextures(Properties props, String basePath) {
        String prefix = "texture.";
        Map mapProps = CustomItemProperties.getMatchingProperties(props, prefix);
        if (mapProps.size() <= 0) {
            return null;
        }
        Set keySet = mapProps.keySet();
        LinkedHashMap<String, String> mapTex = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            String val = (String)mapProps.get(key);
            val = CustomItemProperties.fixTextureName(val, basePath);
            mapTex.put(key, val);
        }
        return mapTex;
    }

    private static String fixTextureName(String iconName, String basePath) {
        String pathBlocks;
        if (!((iconName = TextureUtils.fixResourcePath(iconName, basePath)).startsWith(basePath) || iconName.startsWith("textures/") || iconName.startsWith("mcpatcher/"))) {
            iconName = basePath + "/" + iconName;
        }
        if (iconName.endsWith(".png")) {
            iconName = iconName.substring(0, iconName.length() - 4);
        }
        if (iconName.startsWith(pathBlocks = "textures/blocks/")) {
            iconName = iconName.substring(pathBlocks.length());
        }
        if (iconName.startsWith("/")) {
            iconName = iconName.substring(1);
        }
        return iconName;
    }

    private int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int val = Config.parseInt(str = str.trim(), Integer.MIN_VALUE);
        if (val == Integer.MIN_VALUE) {
            Config.warn("Invalid integer: " + str);
            return defVal;
        }
        return val;
    }

    private float parseFloat(String str, float defVal) {
        if (str == null) {
            return defVal;
        }
        float val = Config.parseFloat(str = str.trim(), Float.MIN_VALUE);
        if (val == Float.MIN_VALUE) {
            Config.warn("Invalid float: " + str);
            return defVal;
        }
        return val;
    }

    private RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        String[] tokens = Config.tokenize(str, " ");
        RangeListInt rangeList = new RangeListInt();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            RangeInt range = this.parseRangeInt(token);
            if (range == null) {
                Config.warn("Invalid range list: " + str);
                return null;
            }
            rangeList.addRange(range);
        }
        return rangeList;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        int countMinus = (str = str.trim()).length() - str.replace("-", "").length();
        if (countMinus > 1) {
            Config.warn("Invalid range: " + str);
            return null;
        }
        String[] tokens = Config.tokenize(str, "- ");
        int[] vals = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int val = Config.parseInt(token, -1);
            if (val < 0) {
                Config.warn("Invalid range: " + str);
                return null;
            }
            vals[i] = val;
        }
        if (vals.length == 1) {
            int val = vals[0];
            if (str.startsWith("-")) {
                return new RangeInt(0, val);
            }
            if (str.endsWith("-")) {
                return new RangeInt(val, 255);
            }
            return new RangeInt(val, val);
        }
        if (vals.length == 2) {
            int min = Math.min(vals[0], vals[1]);
            int max = Math.max(vals[0], vals[1]);
            return new RangeInt(min, max);
        }
        Config.warn("Invalid range: " + str);
        return null;
    }

    private NbtTagValue[] parseNbtTagValues(Properties props) {
        String PREFIX_NBT = "nbt.";
        Map mapNbt = CustomItemProperties.getMatchingProperties(props, PREFIX_NBT);
        if (mapNbt.size() <= 0) {
            return null;
        }
        ArrayList<NbtTagValue> listNbts = new ArrayList<NbtTagValue>();
        Set keySet = mapNbt.keySet();
        for (String key : keySet) {
            String val = (String)mapNbt.get(key);
            String id = key.substring(PREFIX_NBT.length());
            NbtTagValue nbt = new NbtTagValue(id, val);
            listNbts.add(nbt);
        }
        NbtTagValue[] nbts = listNbts.toArray(new NbtTagValue[listNbts.size()]);
        return nbts;
    }

    private static Map getMatchingProperties(Properties props, String keyPrefix) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set<Object> keySet = props.keySet();
        for (String string : keySet) {
            String val = props.getProperty(string);
            if (!string.startsWith(keyPrefix)) continue;
            map.put(string, val);
        }
        return map;
    }

    public boolean isValid(String path) {
        if (this.name == null || this.name.length() <= 0) {
            Config.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            Config.warn("No base path found: " + path);
            return false;
        }
        if (this.type == 0) {
            Config.warn("No type defined: " + path);
            return false;
        }
        if (this.type == 4 && this.items == null) {
            this.items = new int[]{adx.a((adx)aeb.cR)};
        }
        if ((this.type == 1 || this.type == 3 || this.type == 4) && this.items == null) {
            Config.warn("No items defined: " + path);
            return false;
        }
        if (this.texture == null && this.mapTextures == null) {
            Config.warn("No texture specified: " + path);
            return false;
        }
        if (this.type == 2 && this.enchantmentIds == null) {
            Config.warn("No enchantmentIDs specified: " + path);
            return false;
        }
        return true;
    }

    public void updateIcons(bwd textureMap) {
        if (this.texture != null) {
            this.textureLocation = this.getTextureLocation(this.texture);
            if (this.type == 1) {
                kn spriteLocation = this.getSpriteLocation(this.textureLocation);
                this.sprite = textureMap.a(spriteLocation);
            }
        }
        if (this.mapTextures != null) {
            this.mapTextureLocations = new HashMap();
            this.mapSprites = new HashMap();
            Set<String> keySet = this.mapTextures.keySet();
            for (String key : keySet) {
                String val = this.mapTextures.get(key);
                kn locTex = this.getTextureLocation(val);
                this.mapTextureLocations.put(key, locTex);
                if (this.type != 1) continue;
                kn locSprite = this.getSpriteLocation(locTex);
                bwe icon = textureMap.a(locSprite);
                this.mapSprites.put(key, icon);
            }
        }
    }

    private kn getTextureLocation(String texName) {
        String filePath;
        kn locFile;
        boolean exists;
        if (texName == null) {
            return null;
        }
        kn resLoc = new kn(texName);
        String domain = resLoc.b();
        String path = resLoc.a();
        if (!path.contains("/")) {
            path = "textures/blocks/" + path;
        }
        if (!(exists = Config.hasResource(locFile = new kn(domain, filePath = path + ".png")))) {
            Config.warn("File not found: " + filePath);
        }
        return locFile;
    }

    private kn getSpriteLocation(kn resLoc) {
        String pathTex = resLoc.a();
        pathTex = StrUtils.removePrefix(pathTex, "textures/");
        pathTex = StrUtils.removeSuffix(pathTex, ".png");
        kn locTex = new kn(resLoc.b(), pathTex);
        return locTex;
    }

    public void updateModel(bwd textureMap, bph itemModelGenerator) {
        String[] textures = this.getModelTextures();
        boolean useTint = this.isUseTint();
        this.model = CustomItemProperties.makeBakedModel(textureMap, itemModelGenerator, textures, useTint);
        if (this.type == 1 && this.mapTextures != null) {
            Set<String> keySet = this.mapTextures.keySet();
            for (String key : keySet) {
                String tex = this.mapTextures.get(key);
                String path = StrUtils.removePrefix(key, "texture.");
                if (!path.startsWith("bow") && !path.startsWith("fishing_rod")) continue;
                String[] texNames = new String[]{tex};
                byl modelTex = CustomItemProperties.makeBakedModel(textureMap, itemModelGenerator, texNames, useTint);
                if (this.mapModels == null) {
                    this.mapModels = new HashMap<String, byl>();
                }
                String location = "item/" + path;
                this.mapModels.put(location, modelTex);
            }
        }
    }

    private boolean isUseTint() {
        return true;
    }

    private static byl makeBakedModel(bwd textureMap, bph itemModelGenerator, String[] textures, boolean useTint) {
        bpd modelBlockBase = CustomItemProperties.makeModelBlock(textures);
        bpd modelBlock = itemModelGenerator.a(textureMap, modelBlockBase);
        byl model = CustomItemProperties.bakeModel(textureMap, modelBlock, useTint);
        return model;
    }

    private String[] getModelTextures() {
        if (this.type == 1 && this.items.length == 1) {
            acf itemArmor;
            adx item = adx.c((int)this.items[0]);
            if (item == aeb.bG && this.damage != null && this.damage.getCountRanges() > 0) {
                RangeInt range = this.damage.getRange(0);
                int valDamage = range.getMin();
                boolean splash = (valDamage & 0x4000) != 0;
                String texOverlay = this.getMapTexture(this.mapTextures, "texture.potion_overlay", "items/potion_overlay");
                String texMain = null;
                texMain = splash ? this.getMapTexture(this.mapTextures, "texture.potion_bottle_splash", "items/potion_bottle_splash") : this.getMapTexture(this.mapTextures, "texture.potion_bottle_drinkable", "items/potion_bottle_drinkable");
                return new String[]{texOverlay, texMain};
            }
            if (item instanceof acf && (itemArmor = (acf)item).d() == acf.a.a) {
                String material = "leather";
                String type = "helmet";
                if (itemArmor.c == sb.f) {
                    type = "helmet";
                }
                if (itemArmor.c == sb.e) {
                    type = "chestplate";
                }
                if (itemArmor.c == sb.d) {
                    type = "leggings";
                }
                if (itemArmor.c == sb.c) {
                    type = "boots";
                }
                String key = material + "_" + type;
                String texMain = this.getMapTexture(this.mapTextures, "texture." + key, "items/" + key);
                String texOverlay = this.getMapTexture(this.mapTextures, "texture." + key + "_overlay", "items/" + key + "_overlay");
                return new String[]{texMain, texOverlay};
            }
        }
        return new String[]{this.texture};
    }

    private String getMapTexture(Map<String, String> map, String key, String def) {
        if (map == null) {
            return def;
        }
        String str = map.get(key);
        if (str == null) {
            return def;
        }
        return str;
    }

    private static bpd makeModelBlock(String[] modelTextures) {
        StringBuffer sb2 = new StringBuffer();
        sb2.append("{\"parent\": \"builtin/generated\",\"textures\": {");
        for (int i = 0; i < modelTextures.length; ++i) {
            String modelTexture = modelTextures[i];
            if (i > 0) {
                sb2.append(", ");
            }
            sb2.append("\"layer" + i + "\": \"" + modelTexture + "\"");
        }
        sb2.append("}}");
        String modelStr = sb2.toString();
        bpd model = bpd.a((String)modelStr);
        return model;
    }

    private static byl bakeModel(bwd textureMap, bpd modelBlockIn, boolean useTint) {
        bym modelRotationIn = bym.a;
        boolean uvLocked = false;
        bwe var4 = textureMap.getSpriteSafe(modelBlockIn.c("particle"));
        bys.a var5 = new bys.a(modelBlockIn, modelBlockIn.g()).a(var4);
        for (boz var7 : modelBlockIn.a()) {
            for (ct var9 : var7.c.keySet()) {
                bpa var10 = (bpa)var7.c.get(var9);
                if (!useTint) {
                    var10 = new bpa(var10.b, -1, var10.d, var10.e);
                }
                bwe var11 = textureMap.getSpriteSafe(modelBlockIn.c(var10.d));
                boy quad = CustomItemProperties.makeBakedQuad(var7, var10, var11, var9, modelRotationIn, uvLocked);
                if (var10.b == null) {
                    var5.a(quad);
                    continue;
                }
                var5.a(modelRotationIn.a(var10.b), quad);
            }
        }
        return var5.b();
    }

    private static boy makeBakedQuad(boz blockPart, bpa blockPartFace, bwe textureAtlasSprite, ct enumFacing, bym modelRotation, boolean uvLocked) {
        bpg faceBakery = new bpg();
        return faceBakery.a(blockPart.a, blockPart.b, blockPartFace, textureAtlasSprite, enumFacing, modelRotation, blockPart.d, uvLocked, blockPart.e);
    }

    public String toString() {
        return "" + this.basePath + "/" + this.name + ", type: " + this.type + ", items: [" + Config.arrayToString(this.items) + "], textture: " + this.texture;
    }

    public float getTextureWidth(bwf textureManager) {
        if (this.textureWidth <= 0) {
            if (this.textureLocation != null) {
                bwg tex = textureManager.b(this.textureLocation);
                int texId = tex.b();
                int prevTexId = bob.getBoundTexture();
                bob.i((int)texId);
                this.textureWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                bob.i((int)prevTexId);
            }
            if (this.textureWidth <= 0) {
                this.textureWidth = 16;
            }
        }
        return this.textureWidth;
    }

    public float getTextureHeight(bwf textureManager) {
        if (this.textureHeight <= 0) {
            if (this.textureLocation != null) {
                bwg tex = textureManager.b(this.textureLocation);
                int texId = tex.b();
                int prevTexId = bob.getBoundTexture();
                bob.i((int)texId);
                this.textureHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                bob.i((int)prevTexId);
            }
            if (this.textureHeight <= 0) {
                this.textureHeight = 16;
            }
        }
        return this.textureHeight;
    }

    public byl getModel(kn modelLocation) {
        if (modelLocation != null && this.mapTextures != null) {
            byl customModel;
            String modelPath = modelLocation.a();
            if (this.mapModels != null && (customModel = this.mapModels.get(modelPath)) != null) {
                return customModel;
            }
        }
        return this.model;
    }
}

