/*
 * Decompiled with CFR 0.152.
 */
import java.util.BitSet;
import java.util.List;

public class RenderEnv {
    private aih blockAccess;
    private ars blockState;
    private cm blockPos;
    private bcz gameSettings;
    private int blockId = -1;
    private int metadata = -1;
    private int breakingAnimation = -1;
    private float[] quadBounds = new float[ct.n.length * 2];
    private BitSet boundsFlags = new BitSet(3);
    private box.b aoFace = new box.b();
    private BlockPosM colorizerBlockPosM = null;
    private boolean[] borderFlags = null;
    private static ThreadLocal threadLocalInstance = new ThreadLocal();

    private RenderEnv(aih blockAccess, ars blockState, cm blockPos) {
        this.blockAccess = blockAccess;
        this.blockState = blockState;
        this.blockPos = blockPos;
        this.gameSettings = Config.getGameSettings();
    }

    public static RenderEnv getInstance(aih blockAccessIn, ars blockStateIn, cm blockPosIn) {
        RenderEnv re = (RenderEnv)threadLocalInstance.get();
        if (re == null) {
            re = new RenderEnv(blockAccessIn, blockStateIn, blockPosIn);
            threadLocalInstance.set(re);
            return re;
        }
        re.reset(blockAccessIn, blockStateIn, blockPosIn);
        return re;
    }

    private void reset(aih blockAccessIn, ars blockStateIn, cm blockPosIn) {
        this.blockAccess = blockAccessIn;
        this.blockState = blockStateIn;
        this.blockPos = blockPosIn;
        this.blockId = -1;
        this.metadata = -1;
        this.breakingAnimation = -1;
        this.boundsFlags.clear();
    }

    public int getBlockId() {
        if (this.blockId < 0) {
            if (this.blockState instanceof arp) {
                arp bsb = (arp)this.blockState;
                this.blockId = bsb.getBlockId();
            } else {
                this.blockId = akf.a((akf)this.blockState.t());
            }
        }
        return this.blockId;
    }

    public int getMetadata() {
        if (this.metadata < 0) {
            if (this.blockState instanceof arp) {
                arp bsb = (arp)this.blockState;
                this.metadata = bsb.getMetadata();
            } else {
                this.metadata = this.blockState.t().e(this.blockState);
            }
        }
        return this.metadata;
    }

    public float[] getQuadBounds() {
        return this.quadBounds;
    }

    public BitSet getBoundsFlags() {
        return this.boundsFlags;
    }

    public box.b getAoFace() {
        return this.aoFace;
    }

    public boolean isBreakingAnimation(List listQuads) {
        if (this.breakingAnimation < 0 && listQuads.size() > 0) {
            this.breakingAnimation = listQuads.get(0) instanceof bpf ? 1 : 0;
        }
        return this.breakingAnimation == 1;
    }

    public boolean isBreakingAnimation(boy quad) {
        if (this.breakingAnimation < 0) {
            this.breakingAnimation = quad instanceof bpf ? 1 : 0;
        }
        return this.breakingAnimation == 1;
    }

    public boolean isBreakingAnimation() {
        return this.breakingAnimation == 1;
    }

    public ars getBlockState() {
        return this.blockState;
    }

    public BlockPosM getColorizerBlockPosM() {
        if (this.colorizerBlockPosM == null) {
            this.colorizerBlockPosM = new BlockPosM(0, 0, 0);
        }
        return this.colorizerBlockPosM;
    }

    public boolean[] getBorderFlags() {
        if (this.borderFlags == null) {
            this.borderFlags = new boolean[4];
        }
        return this.borderFlags;
    }
}

