/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.client;

import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class UpdateChecker {
    private static String currentVersion = "1.12-1.2.1";
    public static String newestVersion;
    public static String updateStatus;
    public static boolean show;
    public static boolean failedConnection;
    public static boolean hasShownUpdate;
    private static final Style download;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new UpdateChecker());
        UpdateChecker.getNewestVersion();
        if (newestVersion != null) {
            if (newestVersion.equalsIgnoreCase(currentVersion)) {
                updateStatus = "Your version is up to date!";
            } else {
                show = true;
                updateStatus = "New version is available!";
            }
        } else {
            show = true;
            failedConnection = true;
            updateStatus = "Failed to connect to check if update is available!";
        }
    }

    private static void getNewestVersion() {
        try {
            URL url = new URL("https://drive.google.com/uc?export=download&id=0B6_wwPkl6fmOR25vSVhyb0FCY1U");
            Scanner s = new Scanner(url.openStream());
            newestVersion = s.next();
            s.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWorldJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!hasShownUpdate) {
            UpdateChecker.sendInfoMessage(e.player, updateStatus, false);
            if (!failedConnection && !newestVersion.equalsIgnoreCase("1.12-1.2.1")) {
                UpdateChecker.sendDownloadMessageToPlayer(e.player);
            }
            hasShownUpdate = true;
        }
    }

    public static void sendDownloadMessageToPlayer(EntityPlayer player) {
        TextComponentString chat = new TextComponentString("");
        download.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(LucraftCoreUtil.translateToLocal((String)"lucraftcore.info.clickdownload"))));
        chat.func_150258_a(TextFormatting.DARK_GREEN + "[");
        Style data = download.func_150232_l();
        data.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://mods.curse.com/mc-mods/minecraft/252318-speedster-heroes"));
        chat.func_150257_a(new TextComponentString(TextFormatting.GREEN + "Download").func_150255_a(data));
        chat.func_150258_a(TextFormatting.DARK_GREEN + "] ");
        chat.func_150257_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + newestVersion));
        player.func_145747_a((ITextComponent)chat);
    }

    public static void sendInfoMessage(EntityPlayer player, String msg) {
        UpdateChecker.sendInfoMessage(player, msg, true);
    }

    public static void sendInfoMessage(EntityPlayer player, String msg, boolean translate) {
        String message;
        String string = message = translate ? LucraftCoreUtil.translateToLocal((String)msg) : msg;
        if (message == null) {
            message = "null";
        }
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "[" + TextFormatting.YELLOW + "SpeedsterHeroes" + TextFormatting.GOLD + "] " + TextFormatting.GRAY + message));
    }

    static {
        updateStatus = "NULL";
        show = false;
        failedConnection = false;
        hasShownUpdate = false;
        download = new Style();
    }
}

