/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.superpower.SpeedforcePlayerHandler;
import lucraft.mods.heroes.speedsterheroes.superpower.SuperpowerSpeedforce;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLightning
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    public SpeedsterType type;
    public float velocity;
    public int progress;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    protected boolean inGround;
    public int throwableShake;
    private EntityLivingBase thrower;
    private String throwerName;
    private int ticksInGround;
    private int ticksInAir;

    public EntityLightning(World world, EntityLivingBase entity, SpeedsterType type, double x, double y, double z) {
        super(world);
        this.progress = 400;
        this.type = type;
        if (entity instanceof EntityPlayer) {
            this.velocity = MathHelper.func_76131_a((float)((float)(SuperpowerHandler.hasSuperpower((EntityPlayer)((EntityPlayer)entity), (Superpower)SuperpowerSpeedforce.SPEEDFORCE) ? ((SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)((EntityPlayer)entity), SpeedforcePlayerHandler.class)).speedLevel : 1) / 5.0f), (float)1.0f, (float)10.0f);
        }
        this.thrower = entity;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + this.getInaccuracy()) / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.velocity, 1.0f);
    }

    public SpeedsterType getSpeedsterType() {
        return SpeedsterType.flashS2;
    }

    protected float getVelocity() {
        return this.velocity;
    }

    protected float getInaccuracy() {
        return 0.0f;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 180.0 / Math.PI);
        }
    }

    public EntityLightning(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c() == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3d Vec3d2 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d Vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(Vec3d2, Vec3d1);
        Vec3d2 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            Vec3d1 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
            double d0 = 0.0;
            EntityLivingBase entitylivingbase = this.getThrower();
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1 == entitylivingbase && this.ticksInAir < 5) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(Vec3d2, Vec3d1);
                if (movingobjectposition1 == null || !((d1 = Vec3d2.func_72436_e(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(movingobjectposition.func_178782_a());
            } else {
                this.onImpact(movingobjectposition);
            }
        }
        this.field_70165_t += this.field_70159_w / (double)this.getVelocity();
        this.field_70163_u += this.field_70181_x / (double)this.getVelocity();
        this.field_70161_v += this.field_70179_y / (double)this.getVelocity();
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f1) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        float f2 = this.getVelocity();
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
        this.field_70159_w *= (double)f2;
        this.field_70181_x *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        --this.progress;
        if (this.progress <= 0) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.xTile);
        tagCompound.func_74777_a("yTile", (short)this.yTile);
        tagCompound.func_74777_a("zTile", (short)this.zTile);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        tagCompound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        tagCompound.func_74774_a("shake", (byte)this.throwableShake);
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_70005_c_();
        }
        tagCompound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        this.xTile = tagCompund.func_74765_d("xTile");
        this.yTile = tagCompund.func_74765_d("yTile");
        this.zTile = tagCompund.func_74765_d("zTile");
        this.inTile = tagCompund.func_150297_b("inTile", 8) ? Block.func_149684_b((String)tagCompund.func_74779_i("inTile")) : Block.func_149729_e((int)(tagCompund.func_74771_c("inTile") & 0xFF));
        this.throwableShake = tagCompund.func_74771_c("shake") & 0xFF;
        this.inGround = tagCompund.func_74771_c("inGround") == 1;
        this.thrower = null;
        this.throwerName = tagCompund.func_74779_i("ownerName");
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
        this.thrower = this.getThrower();
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
            if (this.thrower == null && this.field_70170_p instanceof WorldServer) {
                try {
                    Entity entity = ((WorldServer)this.field_70170_p).func_175733_a(UUID.fromString(this.throwerName));
                    if (entity instanceof EntityLivingBase) {
                        this.thrower = (EntityLivingBase)entity;
                    }
                }
                catch (Throwable var2) {
                    this.thrower = null;
                }
            }
        }
        return this.thrower;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    protected void onImpact(RayTraceResult mop) {
        if (mop.field_72308_g != null) {
            mop.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getThrower()), 9.0f);
            if (mop.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)mop.field_72308_g).func_70690_d(new PotionEffect(SpeedsterHeroesProxy.speedShock, 200));
            }
        }
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        this.func_70106_y();
    }

    public void func_70020_e(NBTTagCompound tagCompund) {
        super.func_70020_e(tagCompund);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tagCompund) {
        return super.func_189511_e(tagCompund);
    }

    protected float getGravityVelocity() {
        return 1.0E-5f;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(SpeedsterType.getSpeedsterTypeId(this.type));
        buffer.writeInt(this.progress);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.type = SpeedsterType.getSpeedsterTypeFromId(additionalData.readInt());
        this.progress = additionalData.readInt();
    }

    protected void func_70088_a() {
    }
}

