/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.items;

import java.util.List;
import lucraft.mods.heroes.speedsterheroes.client.render.SHRenderer;
import lucraft.mods.heroes.speedsterheroes.client.render.speedlevelbars.SpeedLevelBar;
import lucraft.mods.heroes.speedsterheroes.items.ItemSHBase;
import lucraft.mods.heroes.speedsterheroes.items.ItemSpeedsterArmor;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.extendedinventory.IItemExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.IPlayerExtendedInventory;
import lucraft.mods.lucraftcore.util.IArmorUpgrade;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTachyonDevice
extends ItemSHBase
implements IArmorUpgrade,
IItemExtendedInventory {
    private TachyonDeviceType type;

    public ItemTachyonDevice(TachyonDeviceType type) {
        super(type.getName());
        this.type = type;
    }

    public TachyonDeviceType getTachyonDeviceType() {
        return this.type;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o()) {
            tooltip.add(stack.func_77978_p().func_74762_e("Charge") + "/" + this.getTachyonDeviceType().getMaxCharge());
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        stack.func_77982_d(new NBTTagCompound());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 1.0;
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Charge") / (double)this.getTachyonDeviceType().getMaxCharge();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack stack1 = new ItemStack((Item)this);
        stack1.func_77982_d(new NBTTagCompound());
        ItemStack stack2 = new ItemStack((Item)this);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Charge", this.getTachyonDeviceType().getMaxCharge());
        stack2.func_77982_d(nbt);
        subItems.add((Object)stack1);
        subItems.add((Object)stack2);
    }

    public boolean canBeApplied(int armorSlot, ItemStack suit, ItemStack upgrade) {
        if (upgrade.func_77973_b() instanceof ItemTachyonDevice) {
            return SpeedsterHeroesUtil.getTachyonDeviceFromArmor(suit).func_190926_b();
        }
        return false;
    }

    public IItemExtendedInventory.ExtendedInventoryItemType getEIItemType(ItemStack stack) {
        return IItemExtendedInventory.ExtendedInventoryItemType.MANTLE;
    }

    public void onWornTick(ItemStack stack, EntityPlayer player) {
        if (SpeedsterHeroesUtil.hasTachyonDevice(player.func_184582_a(EntityEquipmentSlot.CHEST))) {
            LucraftCoreUtil.givePlayerItemStack((EntityPlayer)player, (ItemStack)stack);
            ((IPlayerExtendedInventory)player.getCapability(LucraftCore.EXTENDED_INVENTORY, null)).getInventory().func_70299_a(1, ItemStack.field_190927_a);
        }
    }

    public boolean canEquip(ItemStack itemstack, EntityPlayer player) {
        return !SpeedsterHeroesUtil.hasTachyonDevice(player.func_184582_a(EntityEquipmentSlot.CHEST));
    }

    public static enum TachyonDeviceType {
        PROTOTYPE("tachyonPrototype", 3),
        DEVICE("tachyonDevice", 5),
        SMALL_DEVICE("smallTachyonDevice", 4);

        private String name;
        private int speedLevels;

        private TachyonDeviceType(String name, int speedLevels) {
            this.name = name;
            this.speedLevels = speedLevels;
        }

        public String getName() {
            return this.name;
        }

        public int getSpeedLevels() {
            return this.speedLevels;
        }

        public int getMaxCharge() {
            return this.getSpeedLevels() * 1000;
        }

        @SideOnly(value=Side.CLIENT)
        public ModelBase getModel() {
            return this == PROTOTYPE ? SHRenderer.TACHYON_PROTOTYPE_MODEL : (this == DEVICE ? SHRenderer.TACHYON_DEVICE_MODEL : null);
        }

        @SideOnly(value=Side.CLIENT)
        public void doModelTranslations(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (this == PROTOTYPE) {
                SpeedsterType type = player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() ? null : (player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSpeedsterArmor ? ((ItemSpeedsterArmor)player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b()).getSpeedsterType() : null);
                GlStateManager.func_179109_b((float)0.005f, (float)(0.25f + (type != null ? type.getTachyonDeviceModelTranslation((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, null) * 0.7f : 0.0f)), (float)-0.2f);
                GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
            } else if (this == DEVICE) {
                SpeedsterType type = player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() ? null : (player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSpeedsterArmor ? ((ItemSpeedsterArmor)player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b()).getSpeedsterType() : null);
                GlStateManager.func_179109_b((float)0.0f, (float)(0.25f + (type != null ? type.getTachyonDeviceModelTranslation((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, null) * 0.7f : 0.0f)), (float)-0.2f);
                GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTexture() {
            return this == PROTOTYPE ? SHRenderer.TACHYON_PROTOTYPE_TEX : (this == DEVICE ? SHRenderer.TACHYON_DEVICE_TEX : null);
        }

        public SpeedLevelBar getSpeedLevelBar() {
            return this == PROTOTYPE ? SpeedLevelBar.tachyonPrototypeSpeed : (this == DEVICE ? SpeedLevelBar.tachyonDeviceSpeed : SpeedLevelBar.smallTachyonDeviceSpeed);
        }
    }
}

