/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import lucraft.mods.heroes.speedsterheroes.entity.EntityDimensionBreach;
import lucraft.mods.heroes.speedsterheroes.network.AbstractServerMessageHandler;
import lucraft.mods.heroes.speedsterheroes.superpower.SpeedforcePlayerHandler;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSendInfoToServer
implements IMessage {
    public InfoType type;
    public int info;
    public static HashMap<Integer, InfoType> ids = new HashMap();

    public MessageSendInfoToServer() {
    }

    public MessageSendInfoToServer(InfoType type) {
        this.type = type;
        this.info = 0;
    }

    public MessageSendInfoToServer(InfoType type, int i) {
        this.type = type;
        this.info = i;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = InfoType.getInfoTypeFromId(buf.readInt());
        this.info = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.info);
    }

    public static enum InfoType {
        DIMENSION_BREACH_CANCEL,
        DIMENSION_BREACH_TELEPORT,
        CHOSEN_WAYPOINT,
        DELETE_WAYPOINT;


        private InfoType() {
            ids.put(this.ordinal(), this);
        }

        public static InfoType getInfoTypeFromId(int id) {
            return ids.get(id);
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<MessageSendInfoToServer> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final MessageSendInfoToServer message, MessageContext ctx) {
            LucraftCore.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    InfoType type = message.type;
                    SpeedforcePlayerHandler data = (SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)player, SpeedforcePlayerHandler.class);
                    switch (type) {
                        case DIMENSION_BREACH_CANCEL: {
                            if (player.func_184187_bx() == null || !(player.func_184187_bx() instanceof EntityDimensionBreach)) break;
                            ((EntityDimensionBreach)player.func_184187_bx()).startDespawn();
                            break;
                        }
                        case DIMENSION_BREACH_TELEPORT: {
                            player.func_184210_p();
                            if (player.field_70170_p.field_72995_K || !(player instanceof EntityPlayerMP)) break;
                            MinecraftServer server = ((EntityPlayerMP)player).field_70170_p.func_73046_m();
                            WorldServer worldServer = server.func_71218_a(message.info);
                            BlockPos spawn = worldServer.func_175694_M();
                            if (worldServer.field_73011_w.getDimension() == 1) {
                                spawn = worldServer.func_180504_m();
                            }
                            while (!worldServer.func_175623_d(spawn)) {
                                spawn = spawn.func_177984_a();
                            }
                            LucraftCoreUtil.teleportToDimension((EntityPlayer)player, (int)message.info, (double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
                            break;
                        }
                        case CHOSEN_WAYPOINT: {
                            ((SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)player, SpeedforcePlayerHandler.class)).chosenWaypointIndex = message.info;
                            LucraftCoreUtil.sendSuperpowerUpdatePacket((EntityPlayer)player);
                            break;
                        }
                        case DELETE_WAYPOINT: {
                            if (message.info <= -1 || message.info >= data.waypoints.size()) break;
                            data.waypoints.remove(message.info);
                            if (data.chosenWaypointIndex == message.info) {
                                data.chosenWaypointIndex = -1;
                            } else if (data.chosenWaypointIndex > message.info) {
                                --data.chosenWaypointIndex;
                            }
                            LucraftCoreUtil.sendSuperpowerUpdatePacket((EntityPlayer)player);
                            break;
                        }
                    }
                }
            });
            return null;
        }
    }
}

