/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.speedstertypes;

import java.util.Arrays;
import java.util.List;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityDimensionBreach;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityLightningThrowing;
import lucraft.mods.heroes.speedsterheroes.abilities.AbilityPhasing;
import lucraft.mods.heroes.speedsterheroes.items.ItemSHSpeedsterArmor;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.IAutoSpeedsterRecipeAdvanced;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailType;
import lucraft.mods.heroes.speedsterheroes.util.SpeedsterHeroesUtil;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.items.LCItems;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SpeedsterTypeJayGarrick2
extends SpeedsterType
implements IAutoSpeedsterRecipeAdvanced {
    protected SpeedsterTypeJayGarrick2() {
        super("jayGarrick2", TrailType.lightnings_orange);
    }

    @Override
    public void registerItems() {
        this.chestplate = new ItemSHSpeedsterArmor(this, EntityEquipmentSlot.CHEST);
        this.legs = new ItemSHSpeedsterArmor(this, EntityEquipmentSlot.LEGS);
        this.boots = new ItemSHSpeedsterArmor(this, EntityEquipmentSlot.FEET);
    }

    public List<String> getExtraDescription(ItemStack stack) {
        return Arrays.asList("CW Version", "Earth-3 Jay Garrick");
    }

    @Override
    public boolean canOpenHelmet() {
        return false;
    }

    @Override
    public int getExtraSpeedLevel(SpeedsterType type, EntityPlayer player) {
        return type == SpeedsterType.jayGarrick ? 4 : 5;
    }

    @Override
    public boolean shouldHideNameTag(EntityLivingBase player, boolean hasMaskOpen) {
        return false;
    }

    @Override
    public List<ItemStack> getFirstItemStack(ItemStack armor, EntityEquipmentSlot armorSlot) {
        return Arrays.asList(SHItems.getSymbolFromSpeedsterType(this, 1));
    }

    @Override
    public List<ItemStack> getSecondItemStack(ItemStack armor, EntityEquipmentSlot armorSlot) {
        if (armorSlot == EntityEquipmentSlot.HEAD) {
            return SpeedsterHeroesUtil.getOresWithAmount("plateIron", 4);
        }
        return Arrays.asList(LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.RED, (int)SpeedsterHeroesUtil.getRecommendedAmountForArmorSlotWithAddition(armorSlot, this)));
    }

    @Override
    public List<ItemStack> getThirdItemStack(ItemStack armor, EntityEquipmentSlot armorSlot) {
        if (armorSlot == EntityEquipmentSlot.HEAD) {
            return SpeedsterHeroesUtil.getOresWithAmount("ingotGold", 2);
        }
        return Arrays.asList(LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.BLUE, (int)SpeedsterHeroesUtil.getRecommendedAmountForArmorSlotWithAddition(armorSlot, this)));
    }

    @Override
    public Item getHelmet() {
        return SpeedsterType.jayGarrick.getHelmet();
    }

    @Override
    public ItemStack getRepairItem(ItemStack toRepair) {
        if (toRepair.func_77973_b() == this.getLegs()) {
            return LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.BLUE, (int)1);
        }
        return LCItems.getColoredTriPolymer((EnumDyeColor)EnumDyeColor.RED, (int)1);
    }

    @Override
    public List<Ability> addDefaultAbilities(EntityPlayer player, List<Ability> list) {
        list.add(new AbilityPhasing(player).setUnlocked(true).setRequiredLevel(15));
        list.add(new AbilityLightningThrowing(player).setUnlocked(true).setRequiredLevel(20));
        list.add(new AbilityDimensionBreach(player).setUnlocked(true).setRequiredLevel(25));
        return super.addDefaultAbilities(player, list);
    }

    @Override
    public Ability getSuitAbilityForKey(LucraftKeys key, List<Ability> list) {
        if (key == LucraftKeys.ARMOR_1) {
            return Ability.getAbilityFromClass(list, AbilityPhasing.class);
        }
        if (key == LucraftKeys.ARMOR_3) {
            return Ability.getAbilityFromClass(list, AbilityDimensionBreach.class);
        }
        return super.getSuitAbilityForKey(key, list);
    }
}

