/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.trailtypes;

import lucraft.mods.heroes.speedsterheroes.client.render.speedtrail.SpeedTrailRenderer;
import lucraft.mods.heroes.speedsterheroes.client.render.speedtrail.SpeedTrailRendererLightnings;
import lucraft.mods.heroes.speedsterheroes.client.render.speedtrail.SpeedTrailRendererNormal;
import lucraft.mods.heroes.speedsterheroes.client.render.speedtrail.SpeedTrailRendererParticles;
import lucraft.mods.heroes.speedsterheroes.client.render.speedtrail.SpeedTrailRendererRandomLightnings;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailTypeNormal;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailTypeParticles;
import lucraft.mods.heroes.speedsterheroes.trailtypes.TrailTypeRandomLightnings;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TrailType {
    public static SpeedTrailRenderer renderer_normal = new SpeedTrailRendererNormal();
    public static SpeedTrailRenderer renderer_lightnings = new SpeedTrailRendererLightnings();
    public static SpeedTrailRenderer renderer_electricity = new SpeedTrailRendererRandomLightnings();
    public static SpeedTrailRenderer renderer_particles = new SpeedTrailRendererParticles();
    public static TrailType lightnings_orange = new TrailType("lightnings_orange").setTrailColor(1.0f, 0.3f, 0.0f).setMirageColor(1.0f, 0.2f, 0.2f);
    public static TrailType lightnings_red = new TrailType("lightnings_red").setTrailColor(1.0f, 0.0f, 0.0f).setMirageColor(0.5f, 0.5f, 0.0f);
    public static TrailType lightnings_blue = new TrailType("lightnings_blue").setTrailColor(0.0f, 0.0f, 1.0f).setMirageColor(0.3f, 0.3f, 1.0f);
    public static TrailType lightnings_gold = new TrailType("lightnings_gold").setTrailColor(1.0f, 1.0f, 0.13f).setMirageColor(0.3f, 0.3f, 1.0f);
    public static TrailType lightnings_brightgold = new TrailType("lightnings_brightgold").setTrailColor(1.0f, 0.75f, 0.0f).setMirageColor(0.3f, 0.3f, 1.0f);
    public static TrailType lightnings_white = new TrailType("lightnings_white").setTrailColor(1.0f, 1.0f, 1.0f);
    public static TrailType lightnings_lightblue = new TrailType("lightnings_lightblue").setTrailColor(0.28f, 1.0f, 1.0f);
    public static TrailType lightnings_purple = new TrailType("lightnings_purple").setTrailColor(0.78f, 0.36f, 0.78f);
    public static TrailType randomlightnings_lightblue = new TrailTypeRandomLightnings("randomlightnings_lightblue").setTrailColor(0.4f, 0.4f, 1.0f).setMirageColor(0.3f, 0.3f, 1.0f);
    public static TrailType particles_blue = new TrailTypeParticles("particles_blue").setTrailColor(0.0f, 0.0f, 1.0f).setMirageColor(0.3f, 0.3f, 1.0f);
    public static TrailType particles_green = new TrailTypeParticles("particles_green").setTrailColor(0.0f, 1.0f, 0.0f).setMirageColor(0.0f, 0.0f, 0.0f);
    public static TrailType normal = new TrailTypeNormal();
    protected String name;
    protected Vec3d trailColor;
    protected Vec3d mirageColor;
    protected boolean[] miragesColorMasks;

    public TrailType(String name) {
        this.name = name;
        this.trailColor = new Vec3d(1.0, (double)0.3f, 0.0);
        this.mirageColor = new Vec3d(1.0, (double)0.2f, (double)0.2f);
        this.miragesColorMasks = new boolean[]{false, true, true};
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return LucraftCoreUtil.translateToLocal((String)("speedsterheroes.trailtype." + this.name + ".name"));
    }

    public TrailType setTrailColor(float r, float g, float b) {
        this.trailColor = new Vec3d((double)r, (double)g, (double)b);
        return this;
    }

    public Vec3d getTrailColor() {
        return this.trailColor;
    }

    public TrailType setMirageColor(float r, float g, float b) {
        this.mirageColor = new Vec3d((double)r, (double)g, (double)b);
        return this;
    }

    public Vec3d getMirageColor() {
        return this.mirageColor;
    }

    public TrailType setMiragesColorMasks(boolean par1, boolean par2, boolean par3) {
        this.miragesColorMasks = new boolean[]{par1, par2, par3};
        return this;
    }

    public boolean[] getMiragesColorMasks() {
        return this.miragesColorMasks;
    }

    @SideOnly(value=Side.CLIENT)
    public SpeedTrailRenderer getSpeedTrailRenderer() {
        return renderer_lightnings;
    }

    public static enum EnumTrailType {
        NORMAL("speedsterheroes.trailtype.normal.name", 5, renderer_normal),
        PARTICLES("speedsterheroes.trailtype.particles.name", 15, renderer_particles),
        ELECTRICITY("speedsterheroes.trailtype.randomlightnings.name", 20, renderer_electricity),
        LIGHTNINGS("speedsterheroes.trailtype.lightnings.name", 25, renderer_lightnings);

        private String name;
        private int requiredLevel;
        private SpeedTrailRenderer renderer;

        private EnumTrailType(String name, int requiredLevel, SpeedTrailRenderer renderer) {
            this.name = name;
            this.requiredLevel = requiredLevel;
            this.renderer = renderer;
        }

        public String getName() {
            return this.name;
        }

        public int getRequiredLevel() {
            return this.requiredLevel;
        }

        public SpeedTrailRenderer getSpeedTrailRenderer() {
            return this.renderer;
        }

        public static EnumTrailType getTrailTypeFromName(String name) {
            for (EnumTrailType types : EnumTrailType.values()) {
                if (!types.toString().equalsIgnoreCase(name)) continue;
                return types;
            }
            return NORMAL;
        }
    }
}

