/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.heroes.speedsterheroes.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lucraft.mods.heroes.speedsterheroes.client.render.speedlevelbars.SpeedLevelBar;
import lucraft.mods.heroes.speedsterheroes.entity.EntityBlackFlash;
import lucraft.mods.heroes.speedsterheroes.entity.EntitySpeedMirage;
import lucraft.mods.heroes.speedsterheroes.entity.EntityTimeRemnant;
import lucraft.mods.heroes.speedsterheroes.items.ItemSpeedsterArmor;
import lucraft.mods.heroes.speedsterheroes.items.ItemTachyonDevice;
import lucraft.mods.heroes.speedsterheroes.items.SHItems;
import lucraft.mods.heroes.speedsterheroes.proxies.SpeedsterHeroesProxy;
import lucraft.mods.heroes.speedsterheroes.speedstertypes.SpeedsterType;
import lucraft.mods.heroes.speedsterheroes.superpower.SpeedforcePlayerHandler;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.extendedinventory.IPlayerExtendedInventory;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.util.IFakePlayerEntity;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class SpeedsterHeroesUtil {
    public static Random rand = new Random();
    public static final int defaultSpeedLevelWithSpeedforce = 5;
    public static final int extraSpeedLevelVelocity9 = 3;
    public static final int requiredSpeedLevelForWaterWalking = 5;
    public static final int requiredSpeedLevelForSpeedforcePortal = 12;
    public static final int minSpeedsterLevel = 1;
    public static final int maxSpeedsterLevel = 40;
    public static final int maxExtraSpeedLevels = 5;
    public static final int extraSpeedLevelCost = 5;
    public static final String speedLevelNormal = "normal";
    public static final String speedLevelSuit = "suit";
    public static final String speedLevelVelocity9 = "velocity9";
    public static final String speedLevelTachyon = "tachyon";
    public static final String speedLevelExtra = "extra";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File RECIPE_DIR = new File("speedsters");

    public static boolean isMoving(EntityLivingBase entity) {
        return entity.field_70140_Q / 0.6f != entity.field_70141_P / 0.6f;
    }

    public static boolean isVelocity9Active(EntityLivingBase entity) {
        return entity.func_70644_a(SpeedsterHeroesProxy.velocity9);
    }

    public static int getRemainingVelocity9Duration(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && SpeedsterHeroesUtil.isVelocity9Active(entity)) {
            return entity.func_70660_b(SpeedsterHeroesProxy.velocity9).func_76459_b();
        }
        return 0;
    }

    public static SpeedsterType getSpeedsterType(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer || entity instanceof EntityTimeRemnant) {
            return SpeedsterHeroesUtil.hasArmorOn(entity) ? SpeedsterHeroesUtil.getSpeedsterType(entity.func_184582_a(EntityEquipmentSlot.CHEST)) : null;
        }
        if (entity instanceof EntitySpeedMirage) {
            return SpeedsterHeroesUtil.getSpeedsterType(((EntitySpeedMirage)entity).acquired);
        }
        if (entity instanceof EntityBlackFlash) {
            return SpeedsterType.blackFlash;
        }
        return null;
    }

    public static SpeedsterType getSpeedsterType(ItemStack stack) {
        if (stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemSpeedsterArmor) {
            return ((ItemSpeedsterArmor)stack.func_77973_b()).getSpeedsterType();
        }
        return null;
    }

    public static int getSpeedLevels(EntityPlayer player) {
        return SpeedsterHeroesUtil.getSpeedLevelList(player).size();
    }

    public static List<SpeedLevelBar> getSpeedLevelList(EntityPlayer player) {
        int i;
        ArrayList<SpeedLevelBar> list = new ArrayList<SpeedLevelBar>();
        SpeedforcePlayerHandler data = (SpeedforcePlayerHandler)SuperpowerHandler.getSpecificSuperpowerPlayerHandler((EntityPlayer)player, SpeedforcePlayerHandler.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            list.add(SpeedLevelBar.baseSpeed);
        }
        SpeedsterType type = SpeedsterHeroesUtil.getSpeedsterType((EntityLivingBase)player);
        if (type != null) {
            for (i = 0; i < type.getExtraSpeedLevel(type, player); ++i) {
                list.add(SpeedLevelBar.speedsterTypeLevel);
            }
        }
        for (i = 0; i < data.extraSpeedLevels; ++i) {
            list.add(SpeedLevelBar.extraSpeed);
        }
        if (SpeedsterHeroesUtil.isVelocity9Active((EntityLivingBase)player)) {
            for (i = 0; i < 3; ++i) {
                list.add(SpeedLevelBar.velocity9Speed);
            }
        }
        ItemStack tachyon = ItemStack.field_190927_a;
        ItemStack tachyon1 = SpeedsterHeroesUtil.getTachyonDeviceFromArmor(player.func_184582_a(EntityEquipmentSlot.CHEST));
        ItemStack tachyon2 = ((IPlayerExtendedInventory)player.getCapability(LucraftCore.EXTENDED_INVENTORY, null)).getInventory().func_70301_a(1);
        if (!tachyon1.func_190926_b()) {
            tachyon = tachyon1;
        } else if (!tachyon2.func_190926_b()) {
            tachyon = tachyon2;
        }
        if (!tachyon.func_190926_b() && tachyon.func_77942_o() && tachyon.func_77978_p().func_74762_e("Charge") > 0) {
            ItemTachyonDevice device = (ItemTachyonDevice)tachyon.func_77973_b();
            for (int i3 = 0; i3 < device.getTachyonDeviceType().getSpeedLevels(); ++i3) {
                list.add(device.getTachyonDeviceType().getSpeedLevelBar());
            }
        }
        return list;
    }

    public static boolean hasArmorOn(EntityLivingBase entity) {
        if (!entity.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSpeedsterArmor) {
            return ((ItemSpeedsterArmor)entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b()).getSpeedsterType().hasArmorOn(entity);
        }
        return false;
    }

    public static boolean hasArmorOn(EntityPlayer player, SpeedsterType type) {
        return SpeedsterHeroesUtil.hasArmorOn((EntityLivingBase)player) && ((ItemSpeedsterArmor)player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b()).getSpeedsterType() == type;
    }

    public static boolean hasHelmetOn(EntityLivingBase entity) {
        return !entity.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemSpeedsterArmor;
    }

    public static int getMetersForLevel(int level) {
        switch (level) {
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return (level - 1) * 1000;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 10000;
            }
            case 15: {
                return 15000;
            }
            case 16: 
            case 17: 
            case 18: {
                return 20000;
            }
            case 19: 
            case 20: {
                return 25000;
            }
            case 21: {
                return 50000;
            }
            case 22: {
                return 75000;
            }
            case 23: {
                return 100000;
            }
            case 24: {
                return 125000;
            }
            case 25: {
                return 150000;
            }
            case 26: {
                return 190000;
            }
            case 27: {
                return 20000;
            }
            case 28: {
                return 250000;
            }
            case 29: {
                return 300000;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return 350000;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return 375000;
            }
        }
        return 0;
    }

    public static int getSpeedsterPointsForLevel(int level) {
        if (level < 30 && (level == 5 || level == 10 || level == 15 || level == 20 || level == 25)) {
            return 10;
        }
        if (level > 30 && level == 35) {
            return 15;
        }
        if (level == 30) {
            return 15;
        }
        if (level == 40) {
            return 20;
        }
        return 5;
    }

    public static boolean isEntityAvailableForSpeedforce(Entity entity) {
        return entity != null && entity instanceof EntityPlayer && !(entity instanceof IFakePlayerEntity);
    }

    public static BlockPos getRandomPositionInNear(World world, BlockPos pos, int radius) {
        return SpeedsterHeroesUtil.getRandomPositionInNear(world, pos, radius, 20);
    }

    public static BlockPos getRandomPositionInNear(World world, BlockPos pos, int radius, int tries) {
        if (tries <= 0) {
            return pos;
        }
        BlockPos newPos = new BlockPos(pos.func_177958_n() + rand.nextInt(radius) - radius / 2, pos.func_177956_o() + rand.nextInt(radius) - radius / 2, pos.func_177952_p() + rand.nextInt(radius) - radius / 2);
        while (!world.func_175665_u(newPos)) {
            newPos = newPos.func_177977_b();
        }
        if (!world.func_175665_u(newPos = newPos.func_177984_a()) && !world.func_175665_u(newPos.func_177984_a()) && newPos.func_177956_o() >= pos.func_177956_o()) {
            return newPos;
        }
        return SpeedsterHeroesUtil.getRandomPositionInNear(world, newPos, radius, tries - 1);
    }

    public static int getRecommendedAmountForArmorSlot(int armorSlot) {
        return armorSlot == 0 ? 2 : (armorSlot == 1 ? 4 : (armorSlot == 2 ? 3 : 2));
    }

    public static int getRecommendedAmountForArmorSlotWithAddition(EntityEquipmentSlot armorSlot, SpeedsterType type) {
        float addition = (float)type.addDefaultAbilities(null, new ArrayList<Ability>()).size() / 2.0f + (float)type.getExtraSpeedLevel(type, null) / 5.0f;
        return (armorSlot == EntityEquipmentSlot.HEAD ? 1 : (armorSlot == EntityEquipmentSlot.CHEST ? 3 : (armorSlot == EntityEquipmentSlot.LEGS ? 2 : 1))) + Math.round(addition);
    }

    public static List<ItemStack> getOresWithAmount(String ores, int amount) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stacks : OreDictionary.getOres((String)ores)) {
            list.add(new ItemStack(stacks.func_77973_b(), amount, stacks.func_77960_j()));
        }
        return list;
    }

    public static boolean hasTachyonDevice(ItemStack stack) {
        return LucraftCoreUtil.hasArmorThisUpgrade((ItemStack)stack, (Item)SHItems.tachyonDevice) || LucraftCoreUtil.hasArmorThisUpgrade((ItemStack)stack, (Item)SHItems.tachyonPrototype) || LucraftCoreUtil.hasArmorThisUpgrade((ItemStack)stack, (Item)SHItems.smallTachyonDevice);
    }

    public static boolean isTachyonDevice(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == SHItems.tachyonDevice || stack.func_77973_b() == SHItems.tachyonPrototype || stack.func_77973_b() == SHItems.smallTachyonDevice);
    }

    public static ItemStack getTachyonDeviceFromArmor(ItemStack armor) {
        for (ItemStack s : LucraftCoreUtil.getArmorUpgrades((ItemStack)armor)) {
            if (s.func_190926_b() || !(s.func_77973_b() instanceof ItemTachyonDevice)) continue;
            return s;
        }
        return ItemStack.field_190927_a;
    }

    public static void generateSpeedsterSuitBlockStateJSON(SpeedsterType speedster) {
        String[] armorParts;
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
        HashMap<String, Serializable> list = new HashMap<String, Serializable>();
        list.put("forge_marker", Integer.valueOf(1));
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("model", "builtin/generated");
        HashMap<String, String> textures = new HashMap<String, String>();
        textures.put("layer0", "blocks/dirt");
        defaults.put("textures", textures);
        defaults.put("transform", "forge:default-item");
        list.put("defaults", defaults);
        HashMap<String, Map[]> variants = new HashMap<String, Map[]>();
        for (String s : armorParts = new String[]{"helmet", "chestplate", "legs", "boots"}) {
            HashMap<String, String> layers = new HashMap<String, String>();
            layers.put("layer0", "speedsterheroes".toLowerCase() + ":items/" + speedster.getRegistryName() + "/" + s);
            HashMap<String, HashMap<String, String>> textures2 = new HashMap<String, HashMap<String, String>>();
            textures2.put("textures", layers);
            Map[] armor = new Map[]{textures2};
            variants.put(s, armor);
        }
        list.put("variants", variants);
        String suffix = "";
        String name = speedster.getRegistryName() + "_suit";
        File f = new File(RECIPE_DIR, name + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, name + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(list, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

