/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;

public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private int type = 0;
    private String value = null;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";

    public NbtTagValue(String tag, String value) {
        String[] names = Config.tokenize(tag, ".");
        this.parents = Arrays.copyOfRange(names, 0, names.length - 1);
        this.name = names[names.length - 1];
        if (value.startsWith(PREFIX_PATTERN)) {
            this.type = 1;
            value = value.substring(PREFIX_PATTERN.length());
        } else if (value.startsWith(PREFIX_IPATTERN)) {
            this.type = 2;
            value = value.substring(PREFIX_IPATTERN.length()).toLowerCase();
        } else if (value.startsWith(PREFIX_REGEX)) {
            this.type = 3;
            value = value.substring(PREFIX_REGEX.length());
        } else if (value.startsWith(PREFIX_IREGEX)) {
            this.type = 4;
            value = value.substring(PREFIX_IREGEX.length()).toLowerCase();
        } else {
            this.type = 0;
        }
        this.value = value = StringEscapeUtils.unescapeJava((String)value);
    }

    public boolean matches(fn nbt) {
        if (nbt == null) {
            return false;
        }
        fn tagBase = nbt;
        for (int i = 0; i < this.parents.length; ++i) {
            String tag = this.parents[i];
            if ((tagBase = NbtTagValue.getChildTag((gd)tagBase, tag)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild((gd)tagBase);
        }
        if ((tagBase = NbtTagValue.getChildTag((gd)tagBase, this.name)) == null) {
            return false;
        }
        return this.matches((gd)tagBase);
    }

    private boolean matchesAnyChild(gd tagBase) {
        if (tagBase instanceof fn) {
            fn tagCompound = (fn)tagBase;
            Set nbtKeySet = tagCompound.c();
            for (String key : nbtKeySet) {
                gd nbtBase = tagCompound.a(key);
                if (!this.matches(nbtBase)) continue;
                return true;
            }
        }
        if (tagBase instanceof fv) {
            fv tagList = (fv)tagBase;
            int count = tagList.c();
            for (int i = 0; i < count; ++i) {
                gd nbtBase = tagList.g(i);
                if (!this.matches(nbtBase)) continue;
                return true;
            }
        }
        return false;
    }

    private static gd getChildTag(gd tagBase, String tag) {
        if (tagBase instanceof fn) {
            fn tagCompound = (fn)tagBase;
            return tagCompound.a(tag);
        }
        if (tagBase instanceof fv) {
            fv tagList = (fv)tagBase;
            int index = Config.parseInt(tag, -1);
            if (index < 0) {
                return null;
            }
            return tagList.g(index);
        }
        return null;
    }

    private boolean matches(gd nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String nbtValue = NbtTagValue.getValue(nbtBase);
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask(str, pattern, '*', '?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getValue(gd nbtBase) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof gc) {
            gc nbtString = (gc)nbtBase;
            return nbtString.a_();
        }
        if (nbtBase instanceof fu) {
            fu i = (fu)nbtBase;
            return Integer.toString(i.d());
        }
        if (nbtBase instanceof fm) {
            fm b2 = (fm)nbtBase;
            return Byte.toString(b2.f());
        }
        if (nbtBase instanceof gb) {
            gb s = (gb)nbtBase;
            return Short.toString(s.e());
        }
        if (nbtBase instanceof fw) {
            fw l = (fw)nbtBase;
            return Long.toString(l.c());
        }
        if (nbtBase instanceof fs) {
            fs f = (fs)nbtBase;
            return Float.toString(f.h());
        }
        if (nbtBase instanceof fq) {
            fq d = (fq)nbtBase;
            return Double.toString(d.g());
        }
        return nbtBase.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.parents.length; ++i) {
            String parent = this.parents[i];
            if (i > 0) {
                sb.append(".");
            }
            sb.append(parent);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
        return sb.toString();
    }
}

