/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.logging.Logger;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;
import schmoller.tubes.BasicFilterFactory;
import schmoller.tubes.BuildcraftProxy;
import schmoller.tubes.CommonProxy;
import schmoller.tubes.SpecialShapedRecipe;
import schmoller.tubes.SpecialShapelessRecipe;
import schmoller.tubes.TubeCreativeTab;
import schmoller.tubes.api.FilterRegistry;
import schmoller.tubes.api.Items;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.TubeRegistry;
import schmoller.tubes.api.TubesAPI;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.items.ItemTubeBase;
import schmoller.tubes.network.PacketManager;
import schmoller.tubes.network.packets.ModPacketNEIDragDrop;
import schmoller.tubes.network.packets.ModPacketSetColor;
import schmoller.tubes.network.packets.ModPacketSetFilterMode;
import schmoller.tubes.network.packets.ModPacketSetRequestingModes;
import schmoller.tubes.network.packets.ModPacketSetRoutingOptions;
import schmoller.tubes.parts.TubeCap;
import schmoller.tubes.routing.BlockedRouter;
import schmoller.tubes.routing.ImportSourceFinder;
import schmoller.tubes.routing.InputRouter;
import schmoller.tubes.routing.OutputRouter;

@Mod(name="Tubes", modid="Tubes", dependencies="required-after:Forge; required-after:ForgeMultipart; after:Buildcraft[6.1.5)")
public class ModTubes
extends TubesAPI {
    @Mod.Instance(value="Tubes")
    public static ModTubes instance;
    @SidedProxy(clientSide="schmoller.tubes.ClientProxy", serverSide="schmoller.tubes.CommonProxy")
    public static CommonProxy proxy;
    @SidedProxy(clientSide="schmoller.tubes.network.ClientPacketManager", serverSide="schmoller.tubes.network.PacketManager")
    public static PacketManager packetManager;
    public static Logger logger;
    public int plasticYield;
    public static int payloadRenderDistance;
    public static ItemTubeBase itemTube;
    public static Fluid fluidPlastic;
    public static final int GUI_INJECTION_TUBE = 0;
    public static final int GUI_FILTER_TUBE = 1;
    public static final int GUI_COMPRESSOR_TUBE = 2;
    public static final int GUI_REQUESTING_TUBE = 3;
    public static final int GUI_ROUTING_TUBE = 4;
    public static final int GUI_BUFFER_TUBE = 5;
    public static TubeCreativeTab creativeTab;
    private int mClientTickCounter;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        TubesAPI.instance = this;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        Property prop = config.get("general", "plasticYield", 2);
        prop.comment = "How much the base plastic recipe gives. Next level recipe is 4 times this. Default 2.";
        this.plasticYield = prop.getInt();
        prop = config.get("general", "maxItemRenderDistance", 30);
        prop.comment = "The maximum distance in blocks that items in tubes will render.";
        payloadRenderDistance = prop.getInt();
        payloadRenderDistance *= payloadRenderDistance;
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        FilterRegistry.registerFilterFactory(new BasicFilterFactory());
        creativeTab = new TubeCreativeTab();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetManager.initialize("tubes");
        packetManager.registerHandler(proxy, new Class[0]);
        packetManager.registerPacket(ModPacketSetFilterMode.class);
        packetManager.registerPacket(ModPacketSetRequestingModes.class);
        packetManager.registerPacket(ModPacketSetRoutingOptions.class);
        packetManager.registerPacket(ModPacketSetColor.class);
        packetManager.registerPacket(ModPacketNEIDragDrop.class);
        proxy.initialize();
        TubeRegistry.instance().finalizeTubes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        String[] dyes;
        for (String name : dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"}) {
            for (ItemStack item : OreDictionary.getOres((String)name)) {
                OreDictionary.registerOre((String)"Tubes$anyDye", (ItemStack)item);
            }
        }
        proxy.registerOreRecipes();
        event.buildSoftDependProxy("BuildCraft|Core", BuildcraftProxy.class.getName());
    }

    @Mod.EventHandler
    public void onRemapMissing(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.name.equalsIgnoreCase("tubes:tubes:items:tube")) {
                mapping.remap(Items.Tube.getItem());
                continue;
            }
            mapping.warn();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            TubeRegistry.instance().registerIcons((IIconRegister)event.map);
            if (fluidPlastic != null) {
                fluidPlastic.setIcons(event.map.func_94245_a("tubes:fluidPlastic"));
            }
            TubeCap.icon = event.map.func_94245_a("tubes:tube-cap");
        }
    }

    @Override
    public void registerShapedRecipe(ItemStack output, Object ... input) {
        GameRegistry.addRecipe((IRecipe)new SpecialShapedRecipe(output, input));
    }

    @Override
    public void registerShapelessRecipe(ItemStack output, Object ... input) {
        GameRegistry.addRecipe((IRecipe)new SpecialShapelessRecipe(output, input));
    }

    @Override
    public ItemStack createTubeForType(String type) {
        return this.createTubeForType(type, 1);
    }

    @Override
    public ItemStack createTubeForType(String type, int amount) {
        return itemTube.createForType(type, amount);
    }

    @Override
    public String getTubeType(ItemStack item) {
        return itemTube.getTubeType(item);
    }

    @Override
    public BaseRouter getOutputRouter(IBlockAccess world, Position position, TubeItem item) {
        return new OutputRouter(world, position, item);
    }

    @Override
    public BaseRouter getOutputRouter(IBlockAccess world, Position position, TubeItem item, int direction) {
        return new OutputRouter(world, position, item, direction);
    }

    @Override
    public BaseRouter getImportRouter(IBlockAccess world, Position position, TubeItem item) {
        return new InputRouter(world, position, item);
    }

    @Override
    public BaseRouter getImportSourceRouter(IBlockAccess world, Position position, int startDirection, IFilter filter, SizeMode mode) {
        return new ImportSourceFinder(world, position, startDirection, filter, mode);
    }

    @Override
    public BaseRouter getOverflowRouter(IBlockAccess world, Position position, TubeItem item) {
        return new BlockedRouter(world, position, item);
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return creativeTab;
    }

    public int getCurrentTick() {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af();
        }
        return this.mClientTickCounter;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        ++this.mClientTickCounter;
    }

    static {
        logger = Logger.getLogger("Tubes");
    }
}

