/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api.helpers;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import schmoller.tubes.api.Position;

public class CommonHelper {
    private static final String[] dyes = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
    private static final String[] colourNames = new String[]{"item.fireworksCharge.white", "item.fireworksCharge.orange", "item.fireworksCharge.magenta", "item.fireworksCharge.lightBlue", "item.fireworksCharge.yellow", "item.fireworksCharge.lime", "item.fireworksCharge.pink", "item.fireworksCharge.gray", "item.fireworksCharge.silver", "item.fireworksCharge.cyan", "item.fireworksCharge.purple", "item.fireworksCharge.blue", "item.fireworksCharge.brown", "item.fireworksCharge.green", "item.fireworksCharge.red", "item.fireworksCharge.black"};
    private static int[] dyeIds;

    public static TileEntity getTileEntity(IBlockAccess world, Position pos) {
        return world.func_147438_o(pos.x, pos.y, pos.z);
    }

    public static <T> T getTileEntity(IBlockAccess world, Position pos, Class<? extends T> tileClass) {
        return CommonHelper.getTileEntity(world, pos.x, pos.y, pos.z, tileClass);
    }

    public static <T> T getTileEntity(IBlockAccess world, int x, int y, int z, Class<? extends T> tileClass) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tileClass.isInstance(tile)) {
            return (T)tile;
        }
        return null;
    }

    public static <T> T getMultiPart(IBlockAccess world, int x, int y, int z, Class<? extends T> partClass) {
        TileMultipart tile = CommonHelper.getTileEntity(world, x, y, z, TileMultipart.class);
        if (tile == null) {
            return null;
        }
        TMultiPart part = tile.partMap(6);
        if (partClass.isInstance(part)) {
            return (T)part;
        }
        return null;
    }

    public static boolean isMultipartUsable(TMultiPart part, EntityPlayer player) {
        TileMultipart tile = part.tile();
        if (tile == null) {
            return false;
        }
        return tile.func_145831_w().func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) == tile && player.func_70092_e((double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5) <= 64.0;
    }

    public static int getDyeIndex(ItemStack dye) {
        if (dyeIds == null) {
            dyeIds = new int[16];
            for (int i = 0; i < 16; ++i) {
                CommonHelper.dyeIds[i] = OreDictionary.getOreID((String)dyes[i]);
            }
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)dye)) {
            for (int i = 0; i < 16; ++i) {
                if (dyeIds[i] != id) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getDyeColor(int index) {
        float[] rgb = EntitySheep.field_70898_d[index];
        return 0xFF000000 | (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
    }

    public static String getDyeName(int index) {
        return StatCollector.func_74838_a((String)colourNames[index]);
    }

    public static boolean isCtrlPressed() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }
}

