/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import schmoller.tubes.network.IModPacketHandler;
import schmoller.tubes.network.ModPacket;
import schmoller.tubes.network.ModPacketCodec;

@ChannelHandler.Sharable
public class PacketManager
extends SimpleChannelInboundHandler<ModPacket> {
    protected String mChannel;
    private int sNextId = 0;
    private HashMap<IModPacketHandler, Class<? extends ModPacket>[]> mHandlerFilters = new HashMap();
    private HashSet<IModPacketHandler> mHandlers = new HashSet();
    private EnumMap<Side, FMLEmbeddedChannel> mChannels;
    protected FMLEmbeddedChannel client;
    protected FMLEmbeddedChannel server;
    private ModPacketCodec mCodec;

    public void registerPacket(Class<? extends ModPacket> type) {
        this.mCodec.addDiscriminator(this.sNextId++, type);
    }

    public void registerHandler(IModPacketHandler handler, Class<? extends ModPacket> ... filter) {
        this.mHandlers.add(handler);
        if (filter != null && filter.length != 0) {
            this.mHandlerFilters.put(handler, filter);
        }
    }

    public void deregisterHandler(IModPacketHandler handler) {
        this.mHandlers.remove(handler);
        this.mHandlerFilters.remove(handler);
    }

    public void initialize(String channel) {
        this.mChannel = channel;
        this.mCodec = new ModPacketCodec();
        this.mChannels = NetworkRegistry.INSTANCE.newChannel(channel, new ChannelHandler[]{this.mCodec});
        this.client = this.mChannels.get(Side.CLIENT);
        this.server = this.mChannels.get(Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupHandler(this.client);
        this.setupHandler(this.server);
    }

    private void setupHandler(FMLEmbeddedChannel channel) {
        String codec = channel.findChannelHandlerNameForType(ModPacketCodec.class);
        channel.pipeline().addAfter(codec, "Handler", (ChannelHandler)this);
    }

    public void sendPacketToServer(ModPacket packet) {
        throw new IllegalStateException("Side is server!");
    }

    public void sendPacketToClient(ModPacket packet, EntityPlayer player) {
        this.server.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.server.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.server.writeAndFlush((Object)packet);
    }

    public void sendPacketToAllClients(ModPacket packet) {
        this.server.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.server.writeAndFlush((Object)packet);
    }

    public void sendPacketToAllAround(ModPacket packet, World world, int x, int y, int z, int range) {
        this.server.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.server.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, (double)range));
        this.server.writeAndFlush((Object)packet);
    }

    public void sendPacketToWorld(ModPacket packet, World world) {
        this.server.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.server.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)world.field_73011_w.field_76574_g);
        this.server.writeAndFlush((Object)packet);
    }

    @SubscribeEvent
    private void onServerStop(FMLServerStoppingEvent event) {
        this.mHandlers.clear();
        this.mHandlerFilters.clear();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ModPacket packet) throws Exception {
        for (IModPacketHandler handler : this.mHandlers) {
            Class<? extends ModPacket>[] filter = this.mHandlerFilters.get(handler);
            if (filter != null) {
                boolean found = false;
                for (Class<? extends ModPacket> clazz : filter) {
                    if (!clazz.isInstance(packet)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            EntityPlayerMP player = null;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                player = ((NetHandlerPlayServer)netHandler).field_147369_b;
            }
            if (!handler.onPacketArrive(packet, (EntityPlayer)player)) continue;
            break;
        }
    }
}

