/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import schmoller.tubes.AnyFilter;
import schmoller.tubes.api.InteractionHandler;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.OverflowBuffer;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.interfaces.IPayloadHandler;
import schmoller.tubes.api.interfaces.ITubeOverflowDestination;
import schmoller.tubes.routing.OutputRouter;
import schmoller.tubes.types.DirectionalBasicTube;

public class ExtractionTube
extends DirectionalBasicTube
implements IRedstonePart,
ITubeOverflowDestination {
    private boolean mIsPowered = false;
    private OverflowBuffer mOverflow = new OverflowBuffer();
    public static final int BLOCKED_TICKS = 10;
    public static final int CHANNEL_POWERED = 2;
    public float animTime = 0.0f;

    public ExtractionTube() {
        this("extraction");
    }

    protected ExtractionTube(String type) {
        super(type);
    }

    @Override
    public int getHollowSize(int side) {
        if (side == this.getFacing()) {
            return 10;
        }
        return super.getHollowSize(side);
    }

    @Override
    public int getTickRate() {
        return this.mOverflow.isEmpty() ? 20 : 10;
    }

    @Override
    public void onTick() {
        if (this.world().field_72995_K) {
            return;
        }
        if (!this.mOverflow.isEmpty()) {
            TubeItem item = this.mOverflow.peekNext();
            BaseRouter.PathLocation loc = new OutputRouter((IBlockAccess)this.world(), new Position(this.x(), this.y(), this.z()), item).route();
            if (loc != null) {
                this.mOverflow.getNext();
                item.state = 0;
                item.direction = item.lastDirection = this.getFacing() ^ 1;
                item.updated = false;
                item.setProgress(0.0f);
                this.addItem(item, true);
            }
            return;
        }
        if (this.mIsPowered) {
            return;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        Payload extracted = this.doExtract(this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ, dir.ordinal() ^ 1);
        if (extracted != null) {
            this.addItem(extracted, dir.ordinal() ^ 1);
        }
    }

    protected Payload doExtract(int x, int y, int z, int side) {
        IPayloadHandler handler = InteractionHandler.getHandler(ItemPayload.class, (IBlockAccess)this.world(), x, y, z);
        if (handler != null) {
            return handler.extract(new AnyFilter(0), side, true);
        }
        return null;
    }

    @Override
    public boolean canAcceptOverflowFromSide(int side) {
        return side != (this.getFacing() ^ 1);
    }

    private int getPower() {
        int current = 0;
        for (int side = 0; side < 6; ++side) {
            current = Math.max(current, RedstoneInteractions.getPowerTo((World)this.world(), (int)this.x(), (int)this.y(), (int)this.z(), (int)side, (int)31));
        }
        return current;
    }

    @Override
    protected void onDropItems(List<ItemStack> itemsToDrop) {
        super.onDropItems(itemsToDrop);
        this.mOverflow.onDropItems(itemsToDrop);
    }

    public void onWorldJoin() {
        this.mIsPowered = this.getPower() > 0;
    }

    @Override
    public void update() {
        boolean powered;
        boolean bl = powered = this.getPower() > 0;
        if (powered != this.mIsPowered && !this.world().field_72995_K) {
            this.openChannel(2).writeBoolean(powered);
        }
        this.mIsPowered = powered;
        if (this.world().field_72995_K) {
            if (!this.isPowered()) {
                this.animTime = (float)((double)this.animTime + 0.05);
                if (this.animTime > 1.0f) {
                    this.animTime -= 1.0f;
                }
            } else if (this.animTime > 0.0f) {
                this.animTime = (float)((double)this.animTime + 0.05);
                if (this.animTime > 1.0f) {
                    this.animTime = 0.0f;
                }
            }
        }
        super.update();
    }

    public boolean canConnectRedstone(int side) {
        return true;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    @Override
    protected boolean onItemJunction(TubeItem item) {
        if (item.state == 2) {
            item.lastDirection = item.direction;
            item.direction = this.getFacing();
            item.updated = true;
            return true;
        }
        return super.onItemJunction(item);
    }

    @Override
    protected boolean onItemLeave(TubeItem item) {
        if (item.state == 2 && item.direction == this.getFacing()) {
            if (!this.world().field_72995_K) {
                this.mOverflow.addItem(item);
            }
            return true;
        }
        return super.onItemLeave(item);
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        this.mOverflow.save(root);
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        this.mOverflow.load(root);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeBoolean(this.mIsPowered);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.mIsPowered = packet.readBoolean();
    }

    @Override
    protected void onRecieveDataClient(int channel, MCDataInput input) {
        if (channel == 2) {
            this.mIsPowered = input.readBoolean();
        } else {
            super.onRecieveDataClient(channel, input);
        }
    }

    public boolean isPowered() {
        return this.mIsPowered;
    }
}

