/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.helpers.BaseTube;
import schmoller.tubes.routing.OutputRouter;

public class RoundRobinTube
extends BaseTube {
    private int[] mNext = new int[6];

    public RoundRobinTube() {
        super("roundrobin");
    }

    @Override
    protected boolean hasCustomRouting() {
        return true;
    }

    @Override
    protected int onDetermineDestination(TubeItem item) {
        int fromDir = item.direction ^ 1;
        int connections = this.getConnections();
        connections -= connections & 1 << fromDir;
        int next = this.mNext[fromDir];
        int index = 0;
        int first = -1;
        for (int i = 0; i < 6; ++i) {
            BaseRouter.PathLocation dest;
            if ((connections & 1 << i) == 0 || (dest = new OutputRouter((IBlockAccess)this.world(), new Position(this.x(), this.y(), this.z()), item, i).route()) == null) continue;
            if (first == -1) {
                first = i;
            }
            if (index >= next) {
                int n = fromDir;
                this.mNext[n] = this.mNext[n] + 1;
                return i;
            }
            ++index;
        }
        if (first != -1) {
            this.mNext[fromDir] = 1;
            return first;
        }
        return -1;
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        root.func_74783_a("next", this.mNext);
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        this.mNext = root.func_74759_k("next");
    }
}

