/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import codechicken.lib.data.MCDataInput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import schmoller.tubes.AnyFilter;
import schmoller.tubes.ColorFilter;
import schmoller.tubes.FluidFilter;
import schmoller.tubes.ItemFilter;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.InventoryHelper;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.api.interfaces.IFilterFactory;

public class BasicFilterFactory
implements IFilterFactory {
    @Override
    public IFilter getFilterFrom(ItemStack heldItem, IFilter existing, int button, boolean shift, boolean ctrl, boolean mustHavePayload) {
        if (button == 1 && heldItem != null) {
            heldItem = heldItem.func_77946_l();
            heldItem.field_77994_a = 1;
        }
        if (existing instanceof ItemFilter && heldItem != null) {
            ItemStack stack = ((ItemFilter)existing).getItem();
            if (InventoryHelper.areItemsEqual(heldItem, stack)) {
                if (FluidContainerRegistry.isContainer((ItemStack)heldItem)) {
                    return new FluidFilter(FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldItem));
                }
                if (!mustHavePayload && CommonHelper.getDyeIndex(heldItem) != -1) {
                    return new ColorFilter(CommonHelper.getDyeIndex(heldItem));
                }
                return null;
            }
            return new ItemFilter(heldItem, ctrl);
        }
        if (heldItem != null) {
            return new ItemFilter(heldItem, ctrl);
        }
        if (existing instanceof ItemFilter && ctrl) {
            ((ItemFilter)existing).toggleFuzzy();
            return existing;
        }
        return null;
    }

    @Override
    public IFilter loadFilter(String filterName, NBTTagCompound tag) {
        if (filterName.equals("any")) {
            return AnyFilter.from(tag);
        }
        if (filterName.equals("item")) {
            return ItemFilter.from(tag);
        }
        if (filterName.equals("fluid")) {
            return FluidFilter.from(tag);
        }
        if (filterName.equals("color")) {
            return ColorFilter.from(tag);
        }
        return null;
    }

    @Override
    public IFilter loadFilter(String filterName, MCDataInput input) {
        if (filterName.equals("any")) {
            return AnyFilter.from(input);
        }
        if (filterName.equals("item")) {
            return ItemFilter.from(input);
        }
        if (filterName.equals("fluid")) {
            return FluidFilter.from(input);
        }
        if (filterName.equals("color")) {
            return ColorFilter.from(input);
        }
        return null;
    }
}

