/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.inventory.providers;

import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import schmoller.tubes.api.BlockInstance;
import schmoller.tubes.api.interfaces.IInterfaceProvider;

public class CauldronProvider
implements IInterfaceProvider<IFluidHandler> {
    @Override
    public IFluidHandler provide(Object object) {
        return new CauldronHandler((BlockInstance)object);
    }

    private static class CauldronHandler
    implements IFluidHandler {
        private BlockInstance mBlock;

        public CauldronHandler(BlockInstance block) {
            this.mBlock = block;
        }

        private FluidStack getContained() {
            int meta = this.mBlock.world.func_72805_g(this.mBlock.x, this.mBlock.y, this.mBlock.z);
            if (meta == 0) {
                return null;
            }
            return new FluidStack(FluidRegistry.WATER, (int)(333.3333333333333 * (double)meta));
        }

        public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
            if (resource.getFluid() != FluidRegistry.WATER) {
                return 0;
            }
            int points = resource.amount / 333;
            int meta = this.mBlock.world.func_72805_g(this.mBlock.x, this.mBlock.y, this.mBlock.z);
            if (meta < 3) {
                int filled = Math.min(3 - meta, points);
                if (doFill) {
                    ((World)this.mBlock.world).func_72921_c(this.mBlock.x, this.mBlock.y, this.mBlock.z, meta + filled, 2);
                    ((World)this.mBlock.world).func_147460_e(this.mBlock.x, this.mBlock.y, this.mBlock.z, this.mBlock.world.func_147439_a(this.mBlock.x, this.mBlock.y, this.mBlock.z));
                }
                return Math.min((int)((double)filled * 333.3333333333333), resource.amount);
            }
            return 0;
        }

        public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
            if (resource.getFluid() != FluidRegistry.WATER) {
                return null;
            }
            return this.drain(from, resource.amount, doDrain);
        }

        public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
            int meta = this.mBlock.world.func_72805_g(this.mBlock.x, this.mBlock.y, this.mBlock.z);
            if (meta == 0) {
                return null;
            }
            int points = maxDrain / 333;
            int drained = Math.min(meta, points);
            if (doDrain) {
                ((World)this.mBlock.world).func_72921_c(this.mBlock.x, this.mBlock.y, this.mBlock.z, meta - drained, 2);
                ((World)this.mBlock.world).func_147460_e(this.mBlock.x, this.mBlock.y, this.mBlock.z, this.mBlock.world.func_147439_a(this.mBlock.x, this.mBlock.y, this.mBlock.z));
            }
            return new FluidStack(FluidRegistry.WATER, drained * 333);
        }

        public boolean canFill(ForgeDirection from, Fluid fluid) {
            return FluidRegistry.WATER == fluid;
        }

        public boolean canDrain(ForgeDirection from, Fluid fluid) {
            return FluidRegistry.WATER == fluid;
        }

        public FluidTankInfo[] getTankInfo(ForgeDirection from) {
            return new FluidTankInfo[]{new FluidTankInfo(this.getContained(), 1000)};
        }
    }
}

