/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.network.packets;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.io.IOException;
import schmoller.tubes.network.ModBlockPacket;
import schmoller.tubes.types.FilterTube;

public class ModPacketSetFilterMode
extends ModBlockPacket {
    public FilterTube.Mode mode;
    public FilterTube.Comparison comparison;

    public ModPacketSetFilterMode(int x, int y, int z, FilterTube.Mode mode) {
        super(x, y, z);
        this.mode = mode;
    }

    public ModPacketSetFilterMode(int x, int y, int z, FilterTube.Comparison comp) {
        super(x, y, z);
        this.comparison = comp;
    }

    public ModPacketSetFilterMode() {
    }

    @Override
    public void write(MCDataOutput output) throws IOException {
        super.write(output);
        if (this.mode != null) {
            output.writeBoolean(true);
            output.writeByte(this.mode.ordinal());
        } else {
            output.writeBoolean(false);
            output.writeByte(this.comparison.ordinal());
        }
    }

    @Override
    public void read(MCDataInput input) throws IOException {
        super.read(input);
        if (input.readBoolean()) {
            byte val = input.readByte();
            this.mode = val >= 0 && val < FilterTube.Mode.values().length ? FilterTube.Mode.values()[val] : FilterTube.Mode.Allow;
        } else {
            byte val = input.readByte();
            this.comparison = val >= 0 && val < FilterTube.Comparison.values().length ? FilterTube.Comparison.values()[val] : FilterTube.Comparison.Any;
        }
    }
}

