/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.AdvRender;
import schmoller.tubes.ModTubes;
import schmoller.tubes.api.FluidPayload;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.client.IPayloadRender;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.definitions.TypeNormalTube;

public class FluidPayloadRender
implements IPayloadRender {
    private AdvRender mRender = new AdvRender();

    @Override
    public void render(Payload rawPayload, int color, double x, double y, double z, int direction, float progress) {
        FluidPayload payload = (FluidPayload)rawPayload;
        FluidStack fluid = payload.fluid;
        int tickNo = ModTubes.instance.getCurrentTick();
        if (payload.tickNo < tickNo - 1) {
            payload.coordX = (float)x;
            payload.coordY = (float)y;
            payload.coordZ = (float)z;
            payload.lastDirection = direction;
            payload.lastProgress = progress;
        }
        payload.tickNo = tickNo;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        IIcon icon = fluid.getFluid().getIcon(fluid);
        this.mRender.enableLighting = false;
        this.mRender.enableNormals = true;
        this.mRender.resetTransform();
        this.mRender.resetColor();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Minecraft.func_71410_x().func_110434_K().func_130087_a(fluid.getFluid().getSpriteNumber()));
        this.mRender.setIcon(icon);
        this.mRender.setAbsoluteTextureCoords(false);
        float scale = (float)fluid.amount / 1000.0f * 0.7f + 0.3f;
        float baseSize = 0.05f * scale;
        float spacing = 0.1f * scale;
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        this.mRender.pushTransform();
        this.mRender.translate((float)x, (float)y, (float)z);
        this.mRender.drawBox(63, -baseSize, -baseSize, -baseSize, baseSize, baseSize, baseSize);
        this.mRender.popTransform();
        float xx = (float)x;
        float yy = (float)y;
        float zz = (float)z;
        int index = 0;
        int segmentCount = 4;
        for (int i = 0; i < segmentCount; ++i) {
            float size = 1.0f - (float)index / (float)(segmentCount - 1);
            this.mRender.pushTransform();
            this.mRender.scale(size *= 2.0f, size, size);
            ForgeDirection dir = ForgeDirection.getOrientation((int)(direction ^ 1));
            xx += spacing * (float)dir.offsetX;
            yy += spacing * (float)dir.offsetY;
            zz += spacing * (float)dir.offsetZ;
            boolean backSide = false;
            switch (direction) {
                case 0: {
                    backSide = yy > payload.coordY;
                    break;
                }
                case 1: {
                    backSide = yy < payload.coordY;
                    break;
                }
                case 2: {
                    backSide = zz > payload.coordZ;
                    break;
                }
                case 3: {
                    backSide = zz < payload.coordZ;
                    break;
                }
                case 4: {
                    backSide = xx > payload.coordX;
                    break;
                }
                case 5: {
                    boolean bl = backSide = xx < payload.coordX;
                }
            }
            if (backSide && payload.lastDirection != direction) {
                float difference = 0.0f;
                float xxx = xx;
                float yyy = yy;
                float zzz = zz;
                switch (direction) {
                    case 0: 
                    case 1: {
                        difference = Math.abs(yy - payload.coordY);
                        yyy = payload.coordY;
                        break;
                    }
                    case 2: 
                    case 3: {
                        difference = Math.abs(zz - payload.coordZ);
                        zzz = payload.coordZ;
                        break;
                    }
                    case 4: 
                    case 5: {
                        difference = Math.abs(xx - payload.coordX);
                        xxx = payload.coordX;
                    }
                }
                switch (payload.lastDirection) {
                    case 0: {
                        this.mRender.translate(xxx, yyy + difference, zzz);
                        break;
                    }
                    case 1: {
                        this.mRender.translate(xxx, yyy - difference, zzz);
                        break;
                    }
                    case 2: {
                        this.mRender.translate(xxx, yyy, zzz + difference);
                        break;
                    }
                    case 3: {
                        this.mRender.translate(xxx, yyy, zzz - difference);
                        break;
                    }
                    case 4: {
                        this.mRender.translate(xxx + difference, yyy, zzz);
                        break;
                    }
                    case 5: {
                        this.mRender.translate(xxx - difference, yyy, zzz);
                    }
                }
            } else {
                this.mRender.translate(xx, yy, zz);
            }
            this.mRender.drawBox(63, -baseSize, -baseSize, -baseSize, baseSize, baseSize, baseSize);
            this.mRender.popTransform();
            ++index;
        }
        tes.func_78381_a();
        if ((double)payload.lastProgress >= 0.5 && (double)progress < 0.5) {
            payload.lastDirection = direction;
            payload.coordX = (float)x;
            payload.coordY = (float)y;
            payload.coordZ = (float)z;
        }
        payload.lastProgress = progress;
        if (color != -1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            this.mRender.enableNormals = false;
            this.mRender.resetLighting(0xF000F0);
            this.mRender.resetColor();
            this.mRender.resetAO();
            this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            this.mRender.resetTransform();
            this.mRender.setColorRGB(CommonHelper.getDyeColor(color));
            this.mRender.translate(-0.5f, -0.5f, -0.5f);
            ForgeDirection dir = ForgeDirection.getOrientation((int)(direction ^ 1));
            xx = (float)x + spacing * (float)dir.offsetX;
            yy = (float)y + spacing * (float)dir.offsetY;
            zz = (float)z + spacing * (float)dir.offsetZ;
            boolean backSide = false;
            switch (direction) {
                case 0: {
                    backSide = yy > payload.coordY;
                    break;
                }
                case 1: {
                    backSide = yy < payload.coordY;
                    break;
                }
                case 2: {
                    backSide = zz > payload.coordZ;
                    break;
                }
                case 3: {
                    backSide = zz < payload.coordZ;
                    break;
                }
                case 4: {
                    backSide = xx > payload.coordX;
                    break;
                }
                case 5: {
                    boolean bl = backSide = xx < payload.coordX;
                }
            }
            if (backSide && payload.lastDirection != direction) {
                float difference = 0.0f;
                float xxx = xx;
                float yyy = yy;
                float zzz = zz;
                switch (direction) {
                    case 0: 
                    case 1: {
                        difference = Math.abs(yy - payload.coordY);
                        yyy = payload.coordY;
                        break;
                    }
                    case 2: 
                    case 3: {
                        difference = Math.abs(zz - payload.coordZ);
                        zzz = payload.coordZ;
                        break;
                    }
                    case 4: 
                    case 5: {
                        difference = Math.abs(xx - payload.coordX);
                        xxx = payload.coordX;
                    }
                }
                switch (payload.lastDirection) {
                    case 0: {
                        this.mRender.translate(xxx, yyy + difference, zzz);
                        break;
                    }
                    case 1: {
                        this.mRender.translate(xxx, yyy - difference, zzz);
                        break;
                    }
                    case 2: {
                        this.mRender.translate(xxx, yyy, zzz + difference);
                        break;
                    }
                    case 3: {
                        this.mRender.translate(xxx, yyy, zzz - difference);
                        break;
                    }
                    case 4: {
                        this.mRender.translate(xxx + difference, yyy, zzz);
                        break;
                    }
                    case 5: {
                        this.mRender.translate(xxx - difference, yyy, zzz);
                    }
                }
            } else {
                this.mRender.translate(xx, yy, zz);
            }
            this.mRender.setIcon(TypeNormalTube.itemBorder);
            tes.func_78382_b();
            this.mRender.drawBox(63, 0.3f, 0.3f, 0.3f, 0.7f, 0.7f, 0.7f);
            tes.func_78381_a();
        }
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2896);
    }
}

