/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import net.minecraft.world.World;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.types.DirectionalBasicTube;

public class ValveTube
extends DirectionalBasicTube
implements IRedstonePart {
    private boolean mIsOpen = false;
    private static int CHANNEL_STATE = 2;

    public ValveTube() {
        super("valve");
    }

    @Override
    public int getHollowSize(int side) {
        if (side == this.getFacing()) {
            return 10;
        }
        return super.getHollowSize(side);
    }

    @Override
    protected int getConnectableSides() {
        return 63;
    }

    @Override
    public boolean canItemEnter(TubeItem item) {
        if (this.mIsOpen || item.direction != (this.getFacing() ^ 1)) {
            return super.canItemEnter(item);
        }
        return false;
    }

    @Override
    public boolean canAddItem(Payload item, int direction) {
        if (this.mIsOpen || direction != (this.getFacing() ^ 1)) {
            return super.canAddItem(item, direction);
        }
        return false;
    }

    @Override
    public boolean addItem(TubeItem item, boolean syncToClient) {
        return super.addItem(item, syncToClient);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeBoolean(this.mIsOpen);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.mIsOpen = packet.readBoolean();
    }

    @Override
    protected void onRecieveDataClient(int channel, MCDataInput input) {
        if (channel == CHANNEL_STATE) {
            this.mIsOpen = input.readBoolean();
            this.markForRender();
        } else {
            super.onRecieveDataClient(channel, input);
        }
    }

    private int getPower() {
        int current = 0;
        for (int side = 0; side < 6; ++side) {
            current = Math.max(current, RedstoneInteractions.getPowerTo((World)this.world(), (int)this.x(), (int)this.y(), (int)this.z(), (int)side, (int)31));
        }
        return current;
    }

    public void onWorldJoin() {
        this.mIsOpen = this.getPower() > 0;
    }

    @Override
    public void update() {
        if (!this.world().field_72995_K) {
            boolean state;
            boolean bl = state = this.getPower() > 0;
            if (this.mIsOpen != state) {
                this.openChannel(CHANNEL_STATE).writeBoolean(state);
            }
            this.mIsOpen = state;
        }
        super.update();
    }

    public boolean canConnectRedstone(int side) {
        return true;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }
}

