/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.minetweaker;

import fox.spiteful.avaritia.crafting.CompressOreRecipe;
import fox.spiteful.avaritia.crafting.CompressorManager;
import fox.spiteful.avaritia.crafting.CompressorRecipe;
import fox.spiteful.avaritia.crafting.ExtremeCraftingManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.avaritia.Compressor")
public class Compressor {
    @ZenMethod
    public static void add(IItemStack output, int amount, IIngredient input, boolean exact) {
        CompressorRecipe recipe = null;
        if (input instanceof IOreDictEntry) {
            recipe = new CompressOreRecipe(Compressor.toStack(output), amount, Compressor.toString((IOreDictEntry)input), exact);
        } else if (input instanceof IItemStack) {
            recipe = new CompressorRecipe(Compressor.toStack(output), amount, Compressor.toStack((IItemStack)input), exact);
        }
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
        }
    }

    @ZenMethod
    public static void add(IItemStack output, int amount, IIngredient input) {
        Compressor.add(output, amount, input, true);
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(Compressor.toStack(output)));
    }

    private static ItemStack toStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            MineTweakerAPI.getLogger().logError("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    private static Object toObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return Compressor.toString((IOreDictEntry)ingredient);
        }
        if (ingredient instanceof IItemStack) {
            return Compressor.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static Object[] toObjects(IIngredient[] list) {
        if (list == null) {
            return null;
        }
        Object[] ingredients = new Object[list.length];
        for (int x = 0; x < list.length; ++x) {
            ingredients[x] = Compressor.toObject(list[x]);
        }
        return ingredients;
    }

    private static Object toActualObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return OreDictionary.getOres((String)Compressor.toString((IOreDictEntry)ingredient));
        }
        if (ingredient instanceof IItemStack) {
            return Compressor.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    private static class Remove
    implements IUndoableAction {
        CompressorRecipe recipe = null;
        ItemStack remove;

        public Remove(ItemStack rem) {
            this.remove = rem;
        }

        public void apply() {
            for (Object obj : ExtremeCraftingManager.getInstance().getRecipeList()) {
                CompressorRecipe craft;
                if (!(obj instanceof IRecipe) || !(craft = (CompressorRecipe)obj).getOutput().func_77969_a(this.remove)) continue;
                this.recipe = craft;
                CompressorManager.getRecipes().remove(obj);
                break;
            }
        }

        public boolean canUndo() {
            return this.recipe != null;
        }

        public void undo() {
            CompressorManager.getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Removing Compressor Recipe for " + this.remove.func_82833_r();
        }

        public String describeUndo() {
            return "Un-removing Compressor Recipe for " + this.remove.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        CompressorRecipe recipe;

        public Add(CompressorRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            CompressorManager.getRecipes().add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CompressorManager.getRecipes().remove(this.recipe);
        }

        public String describe() {
            return "Adding Compressor Recipe for " + this.recipe.getOutput().func_82833_r();
        }

        public String describeUndo() {
            return "Un-adding Compressor Recipe for " + this.recipe.getOutput().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

