/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.EnumSet;
import java.util.List;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnemyStep {
    static final String DoJumping = "SB.DoJumping";
    static final String WallKick = "SB.WallKick";

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (target == null) {
            return;
        }
        if (!target.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = target.func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        EnumSet<ItemSlashBlade.SwordType> swordType = ((ItemSlashBlade)stack.func_77973_b()).getSwordType(stack);
        if (!swordType.contains((Object)ItemSlashBlade.SwordType.Bewitched)) {
            return;
        }
        boolean wallKickJumped = target.getEntityData().func_74764_b(WallKick);
        if (!this.canCycleJump(target)) {
            if (wallKickJumped && target.field_70122_E) {
                target.getEntityData().func_82580_o(WallKick);
            }
            return;
        }
        Entity enemy = this.getStepEntity(target);
        if (enemy != null) {
            this.resetJump(target);
            if (wallKickJumped) {
                target.getEntityData().func_82580_o(WallKick);
            }
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_71047_c(enemy);
            }
            return;
        }
        if (!wallKickJumped && !target.field_70122_E) {
            if (this.hasCollidWallBlocks((Entity)target, target.func_174791_d())) {
                this.resetJump(target);
                target.getEntityData().func_74768_a(WallKick, 1);
                if (target instanceof EntityPlayer) {
                    ((EntityPlayer)target).func_71009_b((Entity)target);
                }
            }
            return;
        }
    }

    public boolean canCycleJump(EntityLivingBase target) {
        boolean isJumping = (Boolean)ReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)target, (String[])new String[]{"isJumping", "field_70703_bu"});
        int jumpState = target.getEntityData().func_74762_e(DoJumping);
        if (isJumping) {
            switch (jumpState) {
                case 0: {
                    target.getEntityData().func_74768_a(DoJumping, 1);
                    return target.field_70143_R != 0.0f;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    target.getEntityData().func_74768_a(DoJumping, 1);
                    return true;
                }
            }
            return false;
        }
        switch (jumpState) {
            case 1: {
                target.getEntityData().func_74768_a(DoJumping, 2);
                return false;
            }
        }
        if (target.field_70122_E) {
            target.getEntityData().func_82580_o(DoJumping);
        }
        return false;
    }

    private void resetJump(EntityLivingBase target) {
        target.field_70122_E = true;
        ReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)target, (Object)0, (String[])new String[]{"jumpTicks", "field_70773_bE"});
    }

    public boolean hasCollidWallBlocks(Entity target, Vec3d pos) {
        AxisAlignedBB bb = this.getPositionAABB(target, pos);
        List blockCollidList = target.field_70170_p.func_184144_a(target, bb = bb.func_72314_b(1.0, 0.0, 1.0));
        return !blockCollidList.isEmpty();
    }

    public AxisAlignedBB getPositionAABB(Entity target, Vec3d pos) {
        return this.getPositionAABB(target, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public AxisAlignedBB getPositionAABB(Entity target, double x, double y, double z) {
        float f = target.field_70130_N / 2.0f;
        float f1 = target.field_70131_O;
        return new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f);
    }

    private Entity getStepEntity(EntityLivingBase target) {
        AxisAlignedBB bb = target.func_174813_aQ();
        bb = bb.func_72314_b(2.0, 1.5, 2.0);
        List list = target.field_70170_p.func_175674_a((Entity)target, bb = bb.func_72317_d(0.0, 0.5, 0.0), EntitySelectorAttackable.getInstance());
        if (0 < list.size()) {
            Entity enemy = null;
            float distance = 10.0f;
            for (Entity curEntity : list) {
                float curDist = curEntity.func_70032_d((Entity)target);
                if (!(curDist < distance)) continue;
                enemy = curEntity;
                distance = curDist;
            }
            return enemy;
        }
        return null;
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Entity enemy;
        EntityLivingBase target = event.getEntityLiving();
        if (target == null) {
            return;
        }
        ItemStack stack = target.func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        target.field_70143_R = 0.0f;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        ItemSlashBlade.ComboSequence seq = ItemSlashBlade.getComboSequence(tag);
        if (seq != ItemSlashBlade.ComboSequence.Kiriage) {
            ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.None);
        }
        if (target.field_70160_al && (enemy = this.getStepEntity(target)) != null && 3.0 < (double)target.field_70143_R) {
            enemy.field_70181_x -= Math.abs(target.field_70181_x);
            enemy.field_70143_R += target.field_70143_R;
            enemy.func_70097_a(new EntityDamageSource("fall", (Entity)target).func_76348_h(), (float)((double)target.field_70143_R - 3.0));
        }
    }
}

