/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Collection;
import mods.flammpfeil.slashblade.TagPropertyAccessor;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.ability.UntouchableTime;
import mods.flammpfeil.slashblade.entity.EntityJustGuardManager;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class JustGuard {
    public static int activeTicks = 7;
    public static long interval = -5L;
    public static TagPropertyAccessor.TagPropertyLong ChargeStart = new TagPropertyAccessor.TagPropertyLong("SBChargeStart");

    public static boolean atJustGuard(EntityLivingBase e) {
        long last = ChargeStart.get(e.getEntityData());
        return last < 0L;
    }

    public static void setJustGuardState(EntityLivingBase e) {
        int hurtTicks = Math.min(20, Math.max(0, e.field_70172_ad - (int)((float)e.field_70771_an / 2.0f)));
        long last = ChargeStart.get(e.getEntityData());
        if (!JustGuard.atJustGuard(e)) {
            ChargeStart.set(e.getEntityData(), e.field_70170_p.func_82737_E() + (long)hurtTicks);
        }
    }

    @SubscribeEvent
    public void LivingHurtEvent(LivingHurtEvent e) {
        String type = e.getSource().func_76355_l();
        if (e.isCanceled()) {
            return;
        }
        if (e.getEntity() == null) {
            return;
        }
        if (!(e.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityLivingBase el = e.getEntityLiving();
        ItemStack stack = e.getEntityLiving().func_184586_b(EnumHand.MAIN_HAND);
        if (el instanceof EntityPlayer && !el.func_184607_cu().func_190926_b() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemSlashBlade) {
            boolean guardable;
            boolean bl = guardable = e.getSource().func_76346_g() != null;
            if (!guardable && e.getSource().func_76363_c()) {
                return;
            }
            long cs = ChargeStart.get(el.getEntityData());
            if (0L < cs && el.field_70170_p.func_82737_E() - cs < (long)activeTicks) {
                e.setCanceled(true);
                e.setAmount(0.0f);
                UntouchableTime.setUntouchableTime((Entity)el, 20);
                NBTTagCompound tag = stack.func_77978_p();
                el.func_85034_r(-1);
                ReflectionAccessHelper.setVelocity((Entity)el, 0.0, 0.0, 0.0);
                double yOffset = 0.0;
                if (el.field_70122_E) {
                    yOffset = 0.5;
                }
                el.getEntityData().func_74780_a("SBLastPosY", el.field_70163_u + yOffset);
                this.storePotionEffect(el);
                ItemSlashBlade.IsCharged.set(tag, true);
                ItemSlashBlade.OnClick.set(tag, true);
                ItemSlashBlade.OnJumpAttacked.set(tag, false);
                ChargeStart.set(el.getEntityData(), interval);
                el.func_184185_a(SoundEvents.field_187603_D, 1.0f, 1.0f);
                StylishRankManager.addRankPoint((Entity)el, StylishRankManager.AttackTypes.JustGuard);
                EntityJustGuardManager entityManager = new EntityJustGuardManager(el.field_70170_p, el);
                if (entityManager != null) {
                    el.field_70170_p.func_72838_d((Entity)entityManager);
                }
            }
        }
    }

    @SubscribeEvent
    public void LivingUpdateEvent(LivingEvent.LivingUpdateEvent e) {
        EntityLivingBase el = e.getEntityLiving();
        ItemStack stack = el.func_184586_b(EnumHand.MAIN_HAND);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSlashBlade) {
            long cs = ChargeStart.get(el.getEntityData());
            if ((cs = Math.max(interval, cs)) < 0L) {
                if (cs == -1L) {
                    this.restorePotionEffect(el);
                }
                el.field_70159_w = 0.0;
                el.field_70181_x = 0.0;
                el.field_70179_y = 0.0;
                el.field_70163_u = el.getEntityData().func_74769_h("SBLastPosY");
                el.func_70634_a(el.field_70165_t, el.field_70163_u, el.field_70161_v);
                ChargeStart.set(el.getEntityData(), cs + 1L);
            }
        }
    }

    void storePotionEffect(EntityLivingBase entity) {
        Collection effects = entity.func_70651_bq();
        if (!effects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : effects) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            entity.getEntityData().func_74782_a("SB_JG_LastEffects", (NBTBase)nbttaglist);
        }
    }

    void restorePotionEffect(EntityLivingBase entity) {
        if (!entity.getEntityData().func_74764_b("SB_JG_LastEffects")) {
            return;
        }
        entity.func_70674_bp();
        NBTTagList nbttaglist = entity.getEntityData().func_150295_c("SB_JG_LastEffects", 10);
        entity.getEntityData().func_82580_o("SB_JG_LastEffects");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            PotionEffect potioneffect = PotionEffect.func_82722_b((NBTTagCompound)nbttagcompound1);
            if (potioneffect == null) continue;
            entity.func_70690_d(potioneffect);
        }
    }
}

