/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.List;
import mods.flammpfeil.slashblade.entity.EntitySummonedSwordBase;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class ProjectileBarrier {
    public static boolean isAvailable(EntityLivingBase owner, ItemStack stack, int duration) {
        if (owner == null) {
            return false;
        }
        if (owner.func_184607_cu().func_190926_b()) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return false;
        }
        if (!stack.func_77948_v()) {
            return false;
        }
        if (!owner.field_70122_E) {
            return false;
        }
        if (!owner.func_70093_af()) {
            return false;
        }
        int ticks = stack.func_77988_m() - duration;
        if (ticks < ItemSlashBlade.RequiredChargeTick) {
            return false;
        }
        if (((ItemSlashBlade)stack.func_77973_b()).getSwordType(stack).contains((Object)ItemSlashBlade.SwordType.Broken)) {
            return false;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)stack);
        return level > 0;
    }

    @SubscribeEvent
    public void onUpdate(LivingEntityUseItemEvent.Tick event) {
        if (ProjectileBarrier.isAvailable(event.getEntityLiving(), event.getItem(), event.getDuration())) {
            this.expandBarrier(event.getEntityLiving());
        }
    }

    private void expandBarrier(EntityLivingBase player) {
        if (player.field_70173_aa % 7 == 0) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.45f, 0.5f);
        }
        AxisAlignedBB bb = player.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0);
        List list = player.field_70170_p.func_175674_a((Entity)player, bb, EntitySelectorDestructable.getInstance());
        for (Entity target : list) {
            if (target instanceof EntitySummonedSwordBase || target instanceof IThrowableEntity && ((IThrowableEntity)target).getThrower() == player) continue;
            this.destructEntity(player, target);
        }
    }

    private void destructEntity(EntityLivingBase player, Entity target) {
        if (player.field_70170_p instanceof WorldServer) {
            ((WorldServer)player.field_70170_p).func_73039_n().func_151248_b((Entity)player, (Packet)new SPacketAnimation(target, 5));
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187689_f, SoundCategory.PLAYERS, 0.8f, 1.5f + player.func_70681_au().nextFloat() * 0.5f);
        }
        ItemSlashBlade.damageItem(player.func_184614_ca(), 1, player);
        ReflectionAccessHelper.setVelocity(target, 0.0, 0.0, 0.0);
        target.func_70106_y();
    }
}

