/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.TagPropertyAccessor;
import mods.flammpfeil.slashblade.network.MessageRankpointSynchronize;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.stats.AchievementList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StylishRankManager {
    public static String[] rankText = new String[]{"D", "C", "B", "A", "S", "SS", "SSS"};
    public static float RankRate = 1.0f;
    public static int RankRange = 100;
    public static TagPropertyAccessor.TagPropertyIntegerWithRange RankPoint = new TagPropertyAccessor.TagPropertyIntegerWithRange("SBRankPoint", 0, 6 * RankRange - 1);
    public static TagPropertyAccessor.TagPropertyLong LastRankPointUpdate = new TagPropertyAccessor.TagPropertyLong("SBLastRPUpdate");
    public static TagPropertyAccessor.TagPropertyLong LastRankPointSynchronize = new TagPropertyAccessor.TagPropertyLong("SBLastRPSynchronize");
    public static TagPropertyAccessor.TagPropertyString AttackType = new TagPropertyAccessor.TagPropertyString("LastAttackType");
    public static final int initCooltime = 20;
    public static final int addCooltime = 10;
    public static final int maxCooltime = 30;
    public static NBTTagCompound dummyTag = new NBTTagCompound();
    public static Set<String> ignoreDamageTypes = Sets.newHashSet((Object[])new String[]{"thorns", "fall"});

    private static String unescape(String source) {
        return source.replace("\"", "").replace("\\quot;", "\"").replace("\\r;", "\r").replace("\\n;", "\n").replace("\\\\", "\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StylishRankManager() {
        try {
            SlashBlade.mainConfiguration.load();
            Property propIgnoreDamageType = SlashBlade.mainConfiguration.get("general", "RankDownIgnoreDamageTypes", new String[0]);
            propIgnoreDamageType.setShowInGui(false);
            String[] strs = propIgnoreDamageType.getStringList();
            ArrayList tmp = Lists.newArrayList();
            for (String str : strs) {
                ignoreDamageTypes.add(StylishRankManager.unescape(str));
            }
        }
        finally {
            SlashBlade.mainConfiguration.save();
        }
    }

    public static void setRankRate(float rankRate) {
        RankRate = rankRate;
    }

    public static void setRankRange(int rankRange) {
        RankRange = rankRange;
        RankPoint = new TagPropertyAccessor.TagPropertyIntegerWithRange("SBRankPoint", 0, 6 * RankRange - 1);
    }

    public static NBTTagCompound getTag(Entity e) {
        if (e != null) {
            return e.getEntityData();
        }
        return dummyTag;
    }

    public static int getTotalRankPoint(Entity e) {
        NBTTagCompound tag = StylishRankManager.getTag(e);
        int rank = RankPoint.get(tag);
        long now = e.field_70170_p.func_82737_E();
        long lastUpdate = LastRankPointUpdate.get(tag);
        float factor = 1.0f;
        int currentProgress = rank % RankRange;
        long descPoint = Math.max(0, Math.min(currentProgress, (int)((float)(now - lastUpdate) * factor)));
        rank = (int)((long)rank - descPoint);
        rank = Math.max(0, rank);
        return rank;
    }

    public static float getCurrentProgress(Entity e) {
        int rank = StylishRankManager.getTotalRankPoint(e);
        return (float)(rank %= RankRange) / (float)RankRange;
    }

    public static int getStylishRank(Entity e) {
        return StylishRankManager.getStylishRank(StylishRankManager.getTotalRankPoint(e));
    }

    public static int getStylishRank(int totalRankPoint) {
        int rank = totalRankPoint;
        rank = (int)Math.floor((float)rank / (float)RankRange);
        if ((double)(RankRange * 5) + (double)RankRange / 3.0 < (double)totalRankPoint) {
            ++rank;
        }
        if ((double)(RankRange * 5) + (double)(RankRange * 2) / 3.0 < (double)totalRankPoint) {
            ++rank;
        }
        rank = Math.max(0, Math.min(rankText.length, rank));
        return rank;
    }

    public static String getRankText(Entity e) {
        return StylishRankManager.getRankText(StylishRankManager.getStylishRank(e));
    }

    public static String getRankText(int rank) {
        return rank <= 0 ? "" : rankText[Math.min(rank - 1, rankText.length - 1)];
    }

    public static void setNextAttackType(Entity e, String key) {
        NBTTagCompound tag = StylishRankManager.getTag(e);
        AttackType.set(tag, key);
    }

    public static void doAttack(Entity e) {
        if (e == null) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e);
        String attackType = AttackType.get(tag);
        StylishRankManager.addRankPoint(e, attackType);
    }

    public static void addRankPoint(Entity e, String attackType) {
        if (e == null) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e);
        int value = 0;
        if (AttackTypes.types.containsKey(attackType)) {
            value = (int)((float)RankRange * AttackTypes.types.get(attackType).floatValue() * RankRate);
        }
        if (value == 0) {
            return;
        }
        if (value < 0) {
            value = Math.abs(value);
        } else {
            long now;
            String timerKey = "SBAttackTime" + attackType;
            long last = tag.func_74763_f(timerKey);
            if (last < (now = e.field_70170_p.func_82737_E())) {
                tag.func_74772_a(timerKey, now + 20L);
            } else if (last - now < 20L) {
                value /= 2;
                tag.func_74772_a(timerKey, Math.min(now + 30L, last + 10L));
            } else {
                value = 1;
                tag.func_74772_a(timerKey, now + 30L);
            }
        }
        int currentRank = StylishRankManager.getStylishRank(e);
        if (2 < currentRank) {
            currentRank = Math.min(rankText.length - 2, currentRank);
            currentRank -= 2;
            do {
                value = (int)((float)value * 0.8f);
            } while (0 < --currentRank);
            value = Math.max(1, value);
        }
        StylishRankManager.addRankPoint(e, value);
    }

    public static void addRankPoint(Entity e, int amount) {
        if (e == null) {
            return;
        }
        if (e.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e);
        int rankPoint = StylishRankManager.getTotalRankPoint(e);
        int lastRank = StylishRankManager.getStylishRank(rankPoint);
        RankPoint.set(tag, rankPoint += amount);
        LastRankPointUpdate.set(tag, e.field_70170_p.func_82737_E());
        int postRank = StylishRankManager.getStylishRank(rankPoint);
        if (lastRank < postRank && !e.field_70170_p.field_72995_K && e instanceof EntityPlayerMP) {
            StatisticsManagerServer statMgr = ((EntityPlayerMP)e).func_147099_x();
            Achievement achievement = AchievementList.getAchievement("rank" + StylishRankManager.getRankText(postRank));
            if (achievement != null && !statMgr.func_77443_a(achievement) && !statMgr.func_77442_b(achievement)) {
                Stack<Achievement> stackAch = new Stack<Achievement>();
                stackAch.push(achievement);
                while (((Achievement)stackAch.peek()).field_75992_c != null && !statMgr.func_77442_b((Achievement)stackAch.peek())) {
                    stackAch.push(((Achievement)stackAch.peek()).field_75992_c);
                }
                while (!stackAch.isEmpty()) {
                    ((EntityPlayerMP)e).func_71029_a((StatBase)stackAch.pop());
                }
            }
        }
    }

    @SubscribeEvent
    public void LivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        long lastSync;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag((Entity)event.getEntityLiving());
        long lastUpdate = LastRankPointUpdate.get(tag);
        if (lastUpdate != (lastSync = LastRankPointSynchronize.get(tag).longValue())) {
            LastRankPointSynchronize.set(tag, lastUpdate);
            NetworkManager.INSTANCE.sendTo((IMessage)new MessageRankpointSynchronize(RankPoint.get(tag)), (EntityPlayerMP)event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void LivingHurtEvent(LivingHurtEvent e) {
        EntityLivingBase attacker;
        String type = e.getSource().func_76355_l();
        if (e.isCanceled()) {
            return;
        }
        if (e.getEntity() == null) {
            return;
        }
        if (!(e.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (e.getSource().func_76363_c() && e.getSource().func_76346_g() != null) {
            return;
        }
        if (e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)e.getSource().func_76346_g()).func_142015_aE() == attacker.field_70173_aa) {
            return;
        }
        if (ignoreDamageTypes.contains(type)) {
            return;
        }
        NBTTagCompound tag = StylishRankManager.getTag(e.getEntity());
        long lastUpdate = LastRankPointUpdate.get(tag);
        long now = e.getEntity().field_70170_p.func_82737_E();
        if ((long)(RankRange * 2) < now - lastUpdate) {
            RankPoint.set(tag, 0);
        } else {
            RankPoint.add(tag, -RankRange * 2);
        }
        LastRankPointUpdate.set(tag, now);
    }

    public static void setRankPoint(EntityLivingBase user, int rankPoint) {
        NBTTagCompound tag = StylishRankManager.getTag((Entity)user);
        RankPoint.set(tag, rankPoint);
        LastRankPointUpdate.set(tag, user.field_70170_p.func_82737_E());
    }

    public static class AttackTypes {
        public static Map<String, Float> types = Maps.newHashMap();
        public static String None = AttackTypes.registerAttackType("None", 0.0f);
        public static String SimpleAttack = AttackTypes.registerAttackType("SimpleAttack", 0.3f);
        public static String Saya1 = AttackTypes.registerAttackType("Saya1", 0.3f);
        public static String Saya2 = AttackTypes.registerAttackType("Saya2", 0.3f);
        public static String Battou = AttackTypes.registerAttackType("Battou", 0.5f);
        public static String IaiBattou = AttackTypes.registerAttackType("IaiBattou", -0.5f);
        public static String Kiriage = AttackTypes.registerAttackType("Kiriage", 0.3f);
        public static String Kiriorosi = AttackTypes.registerAttackType("Kiriorosi", 0.4f);
        public static String Iai = AttackTypes.registerAttackType("Iai", 0.3f);
        public static String JumpBattou = AttackTypes.registerAttackType("JumpBattou", 0.4f);
        public static String SlashDim = AttackTypes.registerAttackType("SlashDim", 0.6f);
        public static String SlashDimMagic = AttackTypes.registerAttackType("SlashDimMagic", -0.1f);
        public static String JudgmentCut = AttackTypes.registerAttackType("JudgmentCut", 0.1f);
        public static String Drive = AttackTypes.registerAttackType("Drive", 0.5f);
        public static String Spear = AttackTypes.registerAttackType("Spear", -0.2f);
        public static String CircleSlash = AttackTypes.registerAttackType("CircleSlash", 0.3f);
        public static String QuickDrive = AttackTypes.registerAttackType("QuickDrive", 0.2f);
        public static String PhantomSword = AttackTypes.registerAttackType("PhantomSword", 0.2f);
        public static String BreakPhantomSword = AttackTypes.registerAttackType("BreakPhantomSword", 0.1f);
        public static String JustGuard = AttackTypes.registerAttackType("JustGuard", 1.0f);
        public static String Noutou = AttackTypes.registerAttackType("Noutou", -1.0f);
        public static String KillNoutou = AttackTypes.registerAttackType("KillNoutou", -0.5f);
        public static String DestructObject = AttackTypes.registerAttackType("DestructObject", -0.1f);
        public static String AttackAvoidance = AttackTypes.registerAttackType("AttackAvoidance", -0.3f);
        public static String SlashEdge = AttackTypes.registerAttackType("SlashEdge", 0.2f);
        public static String ReturnEdge = AttackTypes.registerAttackType("ReturnEdge", 0.2f);
        public static String SSlashEdge = AttackTypes.registerAttackType("SSlashEdge", 0.3f);
        public static String SReturnEdge = AttackTypes.registerAttackType("SReturnEdge", 0.3f);
        public static String SIai = AttackTypes.registerAttackType("SIai", 0.3f);
        public static String SSlashBlade = AttackTypes.registerAttackType("SSlashBlade", -0.2f);
        public static String ASlashEdge = AttackTypes.registerAttackType("ASlashEdge", 0.3f);
        public static String AKiriorosi = AttackTypes.registerAttackType("AKiriorosi", 0.3f);
        public static String AKiriage = AttackTypes.registerAttackType("AKiriage", 0.4f);
        public static String AKiriorosiFinish = AttackTypes.registerAttackType("AKiriorosiFinish", 0.5f);
        public static String Calibur = AttackTypes.registerAttackType("Calibur", 0.5f);
        public static String HelmBraker = AttackTypes.registerAttackType("HelmBraker", 0.5f);
        public static String RapidSlash = AttackTypes.registerAttackType("RapidSlash", 0.3f);
        public static String RisingStar = AttackTypes.registerAttackType("RisingStar", 0.3f);
        public static String Force1 = AttackTypes.registerAttackType("Force1", 0.3f);
        public static String Force2 = AttackTypes.registerAttackType("Force2", 0.3f);
        public static String Force3 = AttackTypes.registerAttackType("Force3", 0.3f);
        public static String Force4 = AttackTypes.registerAttackType("Force4", 0.3f);
        public static String Force5 = AttackTypes.registerAttackType("Force5", 0.3f);
        public static String Force6 = AttackTypes.registerAttackType("Force6", 0.3f);
        public static String Taunt = AttackTypes.registerAttackType("Taunt", 0.1f);
        public static String TauntFinish = AttackTypes.registerAttackType("TauntFinish", -0.5f);

        public static String registerAttackType(String key, float factor) {
            types.put(key, Float.valueOf(factor));
            return key;
        }
    }
}

