/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Collection;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class UntouchableTime {
    private static final String UntouchableTimeOut = "SB.UntouchableTimeOut";
    private static final String IsAvoid = "SB.IsAvoid";
    private static final String LastEffects = "SB.UT.LastEffects";
    private static final String LastNoBurning = "SB.UT.LastNoBurning";

    public static void setUntouchableTime(Entity target, int ticks) {
        UntouchableTime.setUntouchableTime(target, ticks, false);
    }

    public static void setUntouchableTime(Entity target, int ticks, boolean isAvoid) {
        target.getEntityData().func_74772_a(UntouchableTimeOut, target.field_70170_p.func_82737_E() + (long)ticks);
        UntouchableTime.setIsAvoid(target, isAvoid);
        if (target instanceof EntityLivingBase) {
            UntouchableTime.storePotionEffect((EntityLivingBase)target);
        }
    }

    private static void setIsAvoid(Entity target, boolean isAvoid) {
        target.getEntityData().func_74757_a(IsAvoid, isAvoid);
    }

    private static boolean isAvoid(Entity target) {
        return target.getEntityData().func_74767_n(IsAvoid);
    }

    private static void removeUntouchableTag(Entity target) {
        String[] targetKeys;
        NBTTagCompound tag = target.getEntityData();
        for (String key : targetKeys = new String[]{UntouchableTimeOut, IsAvoid, LastEffects, LastNoBurning}) {
            if (!tag.func_74764_b(key)) continue;
            tag.func_82580_o(key);
        }
    }

    private static boolean isUntouchable(EntityLivingBase target) {
        long now;
        if (target == null) {
            return false;
        }
        if (target.field_70170_p == null) {
            return false;
        }
        NBTTagCompound tag = target.getEntityData();
        if (!tag.func_74764_b(UntouchableTimeOut)) {
            return false;
        }
        long timeOut = tag.func_74763_f(UntouchableTimeOut);
        if (timeOut < (now = target.field_70170_p.func_82737_E())) {
            UntouchableTime.removeUntouchableTag((Entity)target);
            return false;
        }
        return true;
    }

    private static void doAvoid(EntityLivingBase target) {
        if (!UntouchableTime.isAvoid((Entity)target)) {
            return;
        }
        StylishRankManager.addRankPoint((Entity)target, StylishRankManager.AttackTypes.AttackAvoidance);
        UntouchableTime.setIsAvoid((Entity)target, false);
    }

    private void WitchTime(Entity target, int duration) {
        if (target == null) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        StunManager.setStun((EntityLivingBase)target, duration);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (!UntouchableTime.isUntouchable(target)) {
            return;
        }
        UntouchableTime.doAvoid(target);
        this.WitchTime(event.getSource().func_76346_g(), 10);
        event.setCanceled(true);
        event.setAmount(0.0f);
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (!UntouchableTime.isUntouchable(target)) {
            return;
        }
        UntouchableTime.doAvoid(target);
        this.WitchTime(event.getSource().func_76346_g(), 10);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void LivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (UntouchableTime.isUntouchable(event.getEntityLiving())) {
            UntouchableTime.restorePotionEffect(event.getEntityLiving());
        }
    }

    private static void storePotionEffect(EntityLivingBase entity) {
        Collection effects = entity.func_70651_bq();
        if (!effects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : effects) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            entity.getEntityData().func_74782_a(LastEffects, (NBTBase)nbttaglist);
        }
        if (!entity.func_70027_ad()) {
            entity.getEntityData().func_74757_a(LastNoBurning, true);
        }
    }

    private static void restorePotionEffect(EntityLivingBase entity) {
        if (entity.getEntityData().func_74764_b(LastNoBurning)) {
            ReflectionAccessHelper.setFire((Entity)entity, 0);
        }
        if (!entity.getEntityData().func_74764_b(LastEffects)) {
            return;
        }
        entity.func_70674_bp();
        NBTTagList nbttaglist = entity.getEntityData().func_150295_c(LastEffects, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound tag = nbttaglist.func_150305_b(i);
            PotionEffect potioneffect = PotionEffect.func_82722_b((NBTTagCompound)tag);
            if (potioneffect == null) continue;
            entity.func_70690_d(potioneffect);
        }
    }
}

