/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.core;

import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.crafting.RecipeCustomBlade;
import mods.flammpfeil.slashblade.stats.AchievementList;
import mods.flammpfeil.slashblade.util.SlashBladeAchievementCreateEvent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ConfigCustomBladeManager {
    String[] lines = new String[0];

    private static String escape(String source) {
        return String.format("\"%s\"", source.replace("\\", "\\\\").replace("\"", "\\quot;").replace("\r", "\\r;").replace("\n", "\\n;"));
    }

    private static String unescape(String source) {
        return source.replace("\"", "").replace("\\quot;", "\"").replace("\\r;", "\r").replace("\\n;", "\n").replace("\\\\", "\\");
    }

    public void loadConfig(Configuration config) {
        Property propCustomBlade = SlashBlade.mainConfiguration.get("general", "CustomBlade", new String[]{"dios"});
        this.lines = propCustomBlade.getStringList();
        propCustomBlade.setShowInGui(false);
    }

    @SubscribeEvent
    public void onSlashBladeAchievementCreateEvent(SlashBladeAchievementCreateEvent event) {
        int x = 1;
        int y = 13;
        for (String line : this.lines) {
            String key = "custom_" + line;
            ItemStack customBlade = new ItemStack((Item)SlashBlade.bladeNamed, 1, 0);
            NBTTagCompound tag = new NBTTagCompound();
            customBlade.func_77982_d(tag);
            ItemSlashBladeNamed.CurrentItemName.set(tag, key);
            ItemSlashBladeNamed.CustomMaxDamage.set(tag, 50);
            ItemSlashBlade.setBaseAttackModifier(tag, 4.0f + Item.ToolMaterial.IRON.func_78000_c());
            ItemSlashBlade.TextureName.set(tag, "custom/" + line + "/texture");
            ItemSlashBlade.ModelName.set(tag, "custom/" + line + "/model");
            ItemSlashBlade.StandbyRenderType.set(tag, 2);
            ItemStack tiny = SlashBlade.getCustomBlade("tiny_bladesoul");
            tiny.func_190920_e(x);
            ShapedOreRecipe recipe = new RecipeCustomBlade(customBlade, "P##", "#B#", "##S", Character.valueOf('S'), SlashBlade.getCustomBlade("sphere_bladesoul"), Character.valueOf('B'), new ItemStack((Item)SlashBlade.bladeNamed, 1, 0), Character.valueOf('P'), tiny).setMirrored(false);
            SlashBlade.addRecipe(key, (IRecipe)recipe);
            SlashBlade.registerCustomItemStack(key, customBlade);
            Achievement achievement = AchievementList.registerCraftingAchievement(key, -3 + x++, y, SlashBlade.getCustomBlade(key), AchievementList.getAchievement("noname"));
            AchievementList.setContent(achievement, key);
            ItemSlashBladeNamed.NamedBlades.add(key);
        }
    }
}

