/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import mods.flammpfeil.slashblade.ItemSlashBladeWrapper;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.SpecialEffects;
import mods.flammpfeil.slashblade.stats.AchievementList;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import mods.flammpfeil.slashblade.util.SlashBladeHooks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class EntityBladeStand
extends Entity {
    private static final DataParameter<ItemStack> WatchIndexBlade = EntityDataManager.func_187226_a(EntityBladeStand.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> WatchIndexFlipState = EntityDataManager.func_187226_a(EntityBladeStand.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WatchIndexStandType = EntityDataManager.func_187226_a(EntityBladeStand.class, (DataSerializer)DataSerializers.field_187192_b);
    static final String SaveKeyBlade = "Blade";
    static final String SaveKeyStandType = "StandType";
    static final String SaveKeyFlip = "Flip";

    public EntityBladeStand(World p_i1582_1_) {
        super(p_i1582_1_);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityBladeStand(World p_i1582_1_, double x, double y, double z, ItemStack blade) {
        this(p_i1582_1_);
        this.setStandType(-1);
        this.func_70080_a(x, y, z, 180.0f * (this.field_70146_Z.nextFloat() * 2.0f - 1.0f), this.field_70125_A);
        this.setBlade(blade);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(WatchIndexBlade, (Object)ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(WatchIndexFlipState, (Object)0);
        this.func_184212_Q().func_187214_a(WatchIndexStandType, (Object)0);
    }

    public int getFlip() {
        return (Integer)this.func_184212_Q().func_187225_a(WatchIndexFlipState);
    }

    public void setFlip(int value) {
        if (this.hasBlade() && this.getBlade().func_77973_b() instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(this.getBlade()) && 2 <= value) {
            value = 0;
        }
        this.func_184212_Q().func_187227_b(WatchIndexFlipState, (Object)value);
    }

    public void doFlip() {
        this.setFlip(Math.abs((this.getFlip() + 1) % 4));
    }

    public int getStandType() {
        return (Integer)this.func_184212_Q().func_187225_a(WatchIndexStandType);
    }

    public void setStandType(int value) {
        this.func_184212_Q().func_187227_b(WatchIndexStandType, (Object)value);
    }

    public static StandType getType(EntityBladeStand e) {
        return StandType.getType(e.getStandType());
    }

    public ItemStack getBlade() {
        return (ItemStack)this.func_184212_Q().func_187225_a(WatchIndexBlade);
    }

    public void setBlade(ItemStack blade) {
        if (!blade.func_190926_b() && blade.func_77973_b() instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(blade) && 2 <= this.getFlip()) {
            this.setFlip(0);
        }
        if (!blade.func_190926_b() && blade.func_77973_b() instanceof ItemSlashBlade) {
            NBTTagCompound nBTTagCompound = ItemSlashBlade.getItemTagCompound(blade);
        }
        this.func_184212_Q().func_187227_b(WatchIndexBlade, (Object)(!blade.func_190926_b() ? blade : ItemStack.field_190927_a));
        this.func_184212_Q().func_187217_b(WatchIndexBlade);
    }

    public boolean hasBlade() {
        return !this.getBlade().func_190926_b();
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        if (p_70037_1_.func_74764_b(SaveKeyStandType)) {
            int type = p_70037_1_.func_74762_e(SaveKeyStandType);
            this.setStandType(type);
        }
        if (p_70037_1_.func_74764_b(SaveKeyBlade)) {
            NBTTagCompound tag = p_70037_1_.func_74775_l(SaveKeyBlade);
            ItemStack blade = new ItemStack(tag);
            this.setBlade(blade);
        }
        if (p_70037_1_.func_74764_b(SaveKeyFlip)) {
            int flip = p_70037_1_.func_74762_e(SaveKeyFlip);
            this.setFlip(flip);
        }
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        ItemStack blade = this.getBlade();
        if (!blade.func_190926_b()) {
            NBTTagCompound tag = new NBTTagCompound();
            blade.func_77955_b(tag);
            p_70014_1_.func_74782_a(SaveKeyBlade, (NBTBase)tag);
        }
        int type = this.getStandType();
        p_70014_1_.func_74768_a(SaveKeyStandType, type);
        int flip = this.getFlip();
        p_70014_1_.func_74768_a(SaveKeyFlip, flip);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (SlashBladeHooks.onBladeStandAttack(this, p_70097_1_, p_70097_2_)) {
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ReflectionAccessHelper.setVelocity(this, 0.0, this.field_70181_x, 0.0);
        if (SlashBladeHooks.onEntityBladeStandUpdateHooks(this)) {
            return;
        }
        this.field_70181_x = EntityBladeStand.getType(this) == StandType.Wall ? 0.0 : (this.hasBlade() ? (this.field_70163_u > 0.0 ? -0.1 : (this.field_70163_u < -0.5 ? 1.0 : 0.0)) : -0.1);
        this.field_70145_X = false;
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.field_70170_p.func_175623_d(pos) && this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos) < 0.0f) {
            ReflectionAccessHelper.setVelocity(this, 0.0, 0.0, 0.0);
            this.func_70634_a(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v);
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.hasBlade() && this.field_70163_u < -10.0) {
            this.func_70106_y();
        }
        if (EntityBladeStand.getType(this) == StandType.Naked && !this.hasBlade() && 200 < this.field_70173_aa) {
            this.func_70106_y();
        }
    }

    public boolean setStandBlade(Entity e) {
        if (e instanceof EntityPlayer && !e.field_70170_p.field_72995_K) {
            EntityPlayer p = (EntityPlayer)e;
            ItemStack stack = p.func_184586_b(EnumHand.MAIN_HAND);
            if (stack.func_190926_b() && this.hasBlade()) {
                ItemStack blade = this.getBlade();
                NBTTagCompound bladeTag = ItemSlashBlade.getItemTagCompound(blade);
                if (bladeTag.func_186855_b("Owner")) {
                    UserListOpsEntry userlistopsentry;
                    boolean hasPerm = bladeTag.func_186857_a("Owner").equals(p.func_110124_au());
                    if (!hasPerm && p.func_184102_h() != null && ((userlistopsentry = (UserListOpsEntry)p.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)p.func_146103_bH())) != null ? userlistopsentry.func_152644_a() >= 2 : p.func_184102_h().func_71264_H())) {
                        hasPerm = true;
                    }
                    if (!hasPerm) {
                        p.func_145747_a((ITextComponent)new TextComponentTranslation("flammpfeil.swaepon.info.notowner.msg", new Object[0]));
                        return false;
                    }
                }
                if (SpecialEffects.isEffective(p, blade, SpecialEffects.Limitter) == SpecialEffects.State.NonEffective && !p.func_184812_l_()) {
                    int level = ItemSlashBlade.getSpecialEffect(blade).func_74762_e(SpecialEffects.Limitter.getEffectKey());
                    p.func_145747_a((ITextComponent)new TextComponentTranslation("flammpfeil.swaepon.info.needlevel.msg", new Object[]{Integer.toString(level)}));
                    return false;
                }
                AchievementList.triggerCraftingAchievement(this.getBlade(), p);
                p.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getBlade());
                this.setBlade(ItemStack.field_190927_a);
                if (EntityBladeStand.getType(this) == StandType.Naked) {
                    this.func_70106_y();
                }
                return true;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSlashBlade && !this.hasBlade()) {
                this.setBlade(stack);
                p.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                return true;
            }
        }
        return false;
    }

    public boolean func_85031_j(Entity p_85031_1_) {
        if (this.setStandBlade(p_85031_1_)) {
            return true;
        }
        if (!this.hasBlade() && p_85031_1_.func_70093_af()) {
            if (!p_85031_1_.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return true;
        }
        return super.func_85031_j(p_85031_1_);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND) {
            if (player.func_70093_af()) {
                this.doFlip();
                return true;
            }
            if (this.setStandBlade((Entity)player)) {
                return true;
            }
        }
        return super.func_184230_a(player, hand);
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_70076_C() {
        if (this.hasBlade() && this.field_70163_u < 0.0) {
            this.field_70163_u = 0.0;
        } else {
            super.func_70076_C();
        }
    }

    public static enum StandType {
        Dual,
        Single,
        Upright,
        Naked,
        Wall;

        static Map<Integer, StandType> typeMap;

        public static StandType getType(int id) {
            if (typeMap.containsKey(id)) {
                return typeMap.get(id);
            }
            return Naked;
        }

        static {
            typeMap = Maps.newHashMap();
            typeMap.put(-1, Naked);
            typeMap.put(0, Dual);
            typeMap.put(1, Single);
            typeMap.put(2, Wall);
            typeMap.put(3, Upright);
        }
    }
}

