/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDrive
extends Entity
implements IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = ItemStack.field_190927_a;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    protected float AttackLevel = 0.0f;
    private static final DataParameter<Float> ROLL = EntityDataManager.func_187226_a(EntityDrive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> LIFETIME = EntityDataManager.func_187226_a(EntityDrive.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_MULTI_HIT = EntityDataManager.func_187226_a(EntityDrive.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SLASH_DIMENSION = EntityDataManager.func_187226_a(EntityDrive.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityDrive(World par1World) {
        super(par1World);
    }

    public EntityDrive(World par1World, EntityLivingBase entityLiving, float AttackLevel, boolean multiHit, float roll) {
        this(par1World, entityLiving, AttackLevel, multiHit);
        this.setRoll(roll);
    }

    public EntityDrive(World par1World, EntityLivingBase entityLiving, float AttackLevel, boolean multiHit) {
        this(par1World, entityLiving, AttackLevel);
        this.setIsMultiHit(multiHit);
    }

    public EntityDrive(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        this(par1World);
        this.AttackLevel = AttackLevel;
        this.thrower = entityLiving;
        this.blade = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
        if (!this.blade.func_190926_b() && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = ItemStack.field_190927_a;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.func_184187_bx());
        this.alreadyHitEntity.addAll(this.thrower.func_184188_bt());
        this.field_70173_aa = 0;
        this.func_70105_a(1.0f, 2.0f);
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u + (double)this.thrower.func_70047_e() / 2.0, this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
        this.setDriveVector(0.75f);
        Vec3d motion = this.thrower.func_70040_Z();
        if (motion == null) {
            motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        motion = motion.func_72432_b();
        this.func_70107_b(this.field_70165_t + motion.field_72450_a * 20.0, this.field_70163_u + motion.field_72448_b * 20.0, this.field_70161_v + motion.field_72449_c * 20.0);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ROLL, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(LIFETIME, (Object)20);
        this.func_184212_Q().func_187214_a(IS_MULTI_HIT, (Object)false);
        this.func_184212_Q().func_187214_a(IS_SLASH_DIMENSION, (Object)false);
    }

    public boolean getIsMultiHit() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_MULTI_HIT);
    }

    public void setIsMultiHit(boolean isMultiHit) {
        this.func_184212_Q().func_187227_b(IS_MULTI_HIT, (Object)isMultiHit);
    }

    public float getRoll() {
        return ((Float)this.func_184212_Q().func_187225_a(ROLL)).floatValue();
    }

    public void setRoll(float roll) {
        this.func_184212_Q().func_187227_b(ROLL, (Object)Float.valueOf(roll));
    }

    public int getLifeTime() {
        return (Integer)this.func_184212_Q().func_187225_a(LIFETIME);
    }

    public void setLifeTime(int lifetime) {
        this.func_184212_Q().func_187227_b(LIFETIME, (Object)lifetime);
    }

    public boolean getIsSlashDimension() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SLASH_DIMENSION);
    }

    public void setIsSlashDimension(boolean isSlashDimension) {
        this.func_184212_Q().func_187227_b(IS_SLASH_DIMENSION, (Object)isSlashDimension);
    }

    public void setInitialSpeed(float f) {
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u + (double)this.thrower.func_70047_e() / 2.0, this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
        this.setDriveVector(f);
        Vec3d motion = this.thrower.func_70040_Z();
        if (motion == null) {
            motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        motion = motion.func_72432_b();
        this.func_70107_b(this.field_70165_t + motion.field_72450_a * 1.0, this.field_70163_u + motion.field_72448_b * 1.0, this.field_70161_v + motion.field_72449_c * 1.0);
    }

    public void setDriveVector(float fYVecOfst) {
        float fYawDtoR = this.field_70177_z / 180.0f * (float)Math.PI;
        float fPitDtoR = this.field_70125_A / 180.0f * (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        this.field_70181_x = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
        this.field_70179_y = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI);
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            double dAmbit = 1.5;
            AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - dAmbit, this.field_70163_u - dAmbit, this.field_70161_v - dAmbit, this.field_70165_t + dAmbit, this.field_70163_u + dAmbit, this.field_70161_v + dAmbit);
            if (this.getThrower() instanceof EntityLivingBase) {
                EntityLivingBase entityLiving = (EntityLivingBase)this.getThrower();
                List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorDestructable.getInstance());
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
                list.removeAll(this.alreadyHitEntity);
                this.alreadyHitEntity.addAll(list);
                for (Entity curEntity : list) {
                    boolean isDestruction = true;
                    if (curEntity instanceof EntityFireball) {
                        isDestruction = ((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y() ? false : !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), this.AttackLevel);
                    } else if (curEntity instanceof EntityArrow) {
                        if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof IThrowableEntity) {
                        if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof EntityThrowable && ((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (!isDestruction) continue;
                    ReflectionAccessHelper.setVelocity(curEntity, 0.0, 0.0, 0.0);
                    curEntity.func_70106_y();
                    for (int var1 = 0; var1 < 10; ++var1) {
                        Random rand = this.getRand();
                        double var2 = rand.nextGaussian() * 0.02;
                        double var4 = rand.nextGaussian() * 0.02;
                        double var6 = rand.nextGaussian() * 0.02;
                        double var8 = 10.0;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6, new int[0]);
                    }
                    StylishRankManager.doAttack(this.thrower);
                }
            }
            if (!this.getIsMultiHit() || this.field_70173_aa % 2 == 0) {
                List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorAttackable.getInstance());
                list.removeAll(this.alreadyHitEntity);
                if (!this.getIsMultiHit()) {
                    this.alreadyHitEntity.addAll(list);
                }
                float magicDamage = Math.max(1.0f, this.AttackLevel);
                if (this.getIsMultiHit()) {
                    StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.QuickDrive);
                } else {
                    StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.Drive);
                }
                for (Entity curEntity : list) {
                    float health;
                    if (this.getIsSlashDimension() && curEntity instanceof EntityLivingBase && 0.0f < (health = ((EntityLivingBase)curEntity).func_110143_aJ())) {
                        health = Math.max(1.0f, health - magicDamage);
                        ((EntityLivingBase)curEntity).func_70606_j(health);
                    }
                    curEntity.field_70172_ad = 0;
                    DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
                    curEntity.func_70097_a(ds, magicDamage);
                    if (this.blade.func_190926_b() || !(curEntity instanceof EntityLivingBase)) continue;
                    ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)curEntity, (EntityLivingBase)this.thrower);
                }
            }
            if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
                this.func_70106_y();
            }
        }
        this.field_70159_w *= (double)1.05f;
        this.field_70181_x *= (double)1.05f;
        this.field_70179_y *= (double)1.05f;
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70173_aa >= this.getLifeTime()) {
            this.alreadyHitEntity.clear();
            this.alreadyHitEntity = null;
            this.func_70106_y();
        }
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void func_70091_d(MoverType moverType, double par1, double par3, double par5) {
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f1 = super.func_70013_c(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_181015_d(BlockPos pos) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public Entity getThrower() {
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        this.thrower = entity;
    }
}

