/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHelmBrakerManager
extends Entity
implements IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = ItemStack.field_190927_a;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    private static final DataParameter<Boolean> SINGLE_HIT = EntityDataManager.func_187226_a(EntityHelmBrakerManager.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LIFETIME = EntityDataManager.func_187226_a(EntityHelmBrakerManager.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THROWER_ENTITY_ID = EntityDataManager.func_187226_a(EntityHelmBrakerManager.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityHelmBrakerManager(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
        this.field_70181_x = -1.0;
        this.field_70138_W = 1.0f;
    }

    public EntityHelmBrakerManager(World par1World, EntityLivingBase entityLiving, boolean isSingleHit) {
        this(par1World, entityLiving);
        this.setIsSingleHit(isSingleHit);
    }

    public EntityHelmBrakerManager(World par1World, EntityLivingBase entityLiving) {
        this(par1World);
        this.setThrower((Entity)entityLiving);
        this.blade = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
        if (!this.blade.func_190926_b() && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = ItemStack.field_190927_a;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.func_184187_bx());
        this.alreadyHitEntity.addAll(this.thrower.func_184188_bt());
        this.field_70173_aa = 0;
        this.func_70105_a(2.0f, 2.0f);
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u, this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SINGLE_HIT, (Object)false);
        this.func_184212_Q().func_187214_a(LIFETIME, (Object)20);
        this.func_184212_Q().func_187214_a(THROWER_ENTITY_ID, (Object)0);
    }

    public boolean isSingleHit() {
        return (Boolean)this.func_184212_Q().func_187225_a(SINGLE_HIT);
    }

    public void setIsSingleHit(boolean isSingleHit) {
        this.func_184212_Q().func_187227_b(SINGLE_HIT, (Object)isSingleHit);
    }

    public int getLifeTime() {
        return (Integer)this.func_184212_Q().func_187225_a(LIFETIME);
    }

    public void setLifeTime(int lifetime) {
        this.func_184212_Q().func_187227_b(LIFETIME, (Object)lifetime);
    }

    public int getThrowerEntityId() {
        return (Integer)this.func_184212_Q().func_187225_a(THROWER_ENTITY_ID);
    }

    public void setThrowerEntityId(int entityid) {
        this.func_184212_Q().func_187227_b(THROWER_ENTITY_ID, (Object)entityid);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70143_R = 30.0f;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        AxisAlignedBB bb = null;
        ItemSlashBlade.ComboSequence combo = ItemSlashBlade.ComboSequence.None;
        if (this.getThrower() != null && this.getThrower() instanceof EntityLivingBase) {
            EntityLivingBase owner = (EntityLivingBase)this.getThrower();
            if (this.blade.func_190926_b()) {
                this.blade = owner.func_184614_ca();
                if (this.blade.func_190926_b() || !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
                    this.func_70106_y();
                    return;
                }
            }
            ItemSlashBlade itemBlade = (ItemSlashBlade)this.blade.func_77973_b();
            bb = itemBlade.getBBofCombo(this.blade, ItemSlashBlade.ComboSequence.HelmBraker, (EntityLivingBase)this.getThrower());
            NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
            combo = ItemSlashBlade.getComboSequence(tag);
        }
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa >= this.getLifeTime() || combo != ItemSlashBlade.ComboSequence.HelmBraker || this.getThrower() == null || this.getThrower() != null && (this.getThrower().field_70122_E || this.isLanding() || this.getThrower().func_70090_H() || this.getThrower().func_180799_ab()))) {
            this.alreadyHitEntity.clear();
            this.alreadyHitEntity = null;
            this.func_70106_y();
            if (this.getThrower() instanceof EntityPlayerMP) {
                EntityPlayerMP entityPlayer = (EntityPlayerMP)this.getThrower();
                entityPlayer.field_71135_a.func_147364_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, entityPlayer.field_70177_z, entityPlayer.field_70125_A);
            }
            return;
        }
        if (1 < this.field_70173_aa && this.getThrower() != null) {
            ReflectionAccessHelper.setVelocity(this.getThrower(), 0.0, this.getThrower().field_70181_x, 0.0);
            this.getThrower().func_70091_d(MoverType.SELF, 0.0, -1.5, 0.0);
            this.getThrower().field_70143_R = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.getThrower() != null) {
            if (this.getThrower() instanceof EntityLivingBase) {
                EntityLivingBase entityLiving = (EntityLivingBase)this.getThrower();
                List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorDestructable.getInstance());
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
                list.removeAll(this.alreadyHitEntity);
                this.alreadyHitEntity.addAll(list);
                for (Entity curEntity : list) {
                    boolean isDestruction = true;
                    if (curEntity instanceof EntityFireball) {
                        isDestruction = ((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y() ? false : !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), 1.0f);
                    } else if (curEntity instanceof EntityArrow) {
                        if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof IThrowableEntity) {
                        if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof EntityThrowable && ((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (!isDestruction) continue;
                    curEntity.field_70159_w = 0.0;
                    curEntity.field_70181_x = 0.0;
                    curEntity.field_70179_y = 0.0;
                    curEntity.func_70106_y();
                    for (int var1 = 0; var1 < 10; ++var1) {
                        Random rand = this.getRand();
                        double var2 = rand.nextGaussian() * 0.02;
                        double var4 = rand.nextGaussian() * 0.02;
                        double var6 = rand.nextGaussian() * 0.02;
                        double var8 = 10.0;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6, new int[0]);
                    }
                    StylishRankManager.doAttack(this.thrower);
                }
            }
            if (this.isSingleHit() || this.field_70173_aa % 3 == 0) {
                List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorAttackable.getInstance());
                list.removeAll(this.alreadyHitEntity);
                if (this.isSingleHit()) {
                    this.alreadyHitEntity.addAll(list);
                }
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.HelmBraker);
                if (!this.blade.func_190926_b()) {
                    NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
                    for (Entity curEntity : list) {
                        if (this.thrower instanceof EntityPlayer) {
                            ItemSlashBlade itemBlade = (ItemSlashBlade)this.blade.func_77973_b();
                            itemBlade.attackTargetEntity(this.blade, curEntity, (EntityPlayer)this.thrower, true);
                            continue;
                        }
                        EntityDamageSource ds = new EntityDamageSource("mob", this.getThrower());
                        curEntity.func_70097_a((DamageSource)ds, 10.0f);
                        if (this.blade.func_190926_b() || !(curEntity instanceof EntityLivingBase)) continue;
                        ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)curEntity, (EntityLivingBase)this.thrower);
                    }
                }
            }
        }
    }

    boolean isLanding() {
        int i5;
        int l4;
        int j4 = MathHelper.func_76128_c((double)this.getThrower().field_70165_t);
        BlockPos blockpos = new BlockPos(j4, l4 = MathHelper.func_76128_c((double)(this.getThrower().field_70163_u - (double)0.2f)), i5 = MathHelper.func_76128_c((double)this.getThrower().field_70161_v));
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        return !iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos);
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.func_70090_H()) {
            this.func_70072_I();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70143_R > 3.0f && onGroundIn && this.getThrower() != null && this.getThrower() instanceof EntityLivingBase) {
            float f = MathHelper.func_76123_f((float)(this.field_70143_R - 3.0f));
            if (!state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) {
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(150.0 * d0);
                if (!state.func_177230_c().addLandingEffects(state, (WorldServer)this.field_70170_p, pos, state, (EntityLivingBase)this.getThrower(), i)) {
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u, this.field_70161_v, i, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)state)});
                }
            }
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f1 = super.func_70013_c(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_181015_d(BlockPos p_181015_1_) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public Entity getThrower() {
        int id;
        if (this.thrower == null && (id = this.getThrowerEntityId()) != 0) {
            this.thrower = this.func_130014_f_().func_73045_a(id);
        }
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity != null) {
            this.setThrowerEntityId(entity.func_145782_y());
        }
        this.thrower = entity;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }
}

