/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.entity.EntitySlashDimension;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityJudgmentCutManager
extends Entity
implements IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = ItemStack.field_190927_a;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    private static final DataParameter<Integer> ThrowerEntityID = EntityDataManager.func_187226_a(EntityJudgmentCutManager.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityJudgmentCutManager(World par1World) {
        super(par1World);
        this.field_70173_aa = 0;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ThrowerEntityID, (Object)0);
    }

    int getThrowerEntityID() {
        return (Integer)this.func_184212_Q().func_187225_a(ThrowerEntityID);
    }

    void setThrowerEntityID(int id) {
        this.func_184212_Q().func_187227_b(ThrowerEntityID, (Object)id);
    }

    public EntityJudgmentCutManager(World par1World, EntityLivingBase entityLiving) {
        this(par1World);
        this.thrower = entityLiving;
        this.setThrowerEntityID(this.thrower.func_145782_y());
        this.blade = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
        if (!this.blade.func_190926_b() && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = ItemStack.field_190927_a;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.func_184187_bx());
        this.alreadyHitEntity.addAll(this.thrower.func_184188_bt());
        this.field_70173_aa = 0;
        this.func_70105_a(64.0f, 32.0f);
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u, this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
    }

    public void func_70071_h_() {
        EntityPlayer player;
        ItemStack stack;
        if (this.thrower == null && this.getThrowerEntityID() != 0) {
            this.thrower = this.field_70170_p.func_73045_a(this.getThrowerEntityID());
        }
        if (this.blade.func_190926_b() && this.getThrower() != null && this.getThrower() instanceof EntityPlayer && (stack = (player = (EntityPlayer)this.getThrower()).func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof ItemSlashBlade) {
            this.blade = stack;
        }
        if (this.thrower != null) {
            ReflectionAccessHelper.setVelocity(this.getThrower(), 0.0, 0.0, 0.0);
            if (this.getThrower() != null && this.getThrower() instanceof EntityPlayer) {
                player = (EntityPlayer)this.getThrower();
                if (this.field_70173_aa < 3) {
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
                if (this.field_70173_aa < 8) {
                    for (int i = 0; i < 20; ++i) {
                        double d0 = player.func_70681_au().nextGaussian() * 0.2;
                        double d1 = player.func_70681_au().nextGaussian() * 0.2;
                        double d2 = player.func_70681_au().nextGaussian() * 0.2;
                        double d3 = 16.0;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, player.field_70165_t + (double)(player.func_70681_au().nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N - d0 * d3, player.field_70163_u, player.field_70161_v + (double)(player.func_70681_au().nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
                    }
                    player.func_184185_a(SoundEvents.field_187603_D, 1.0f, 1.0f);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            List list;
            AxisAlignedBB bb = this.func_174813_aQ().func_72317_d(0.0, (double)(-this.field_70131_O / 2.0f), 0.0);
            if (this.field_70173_aa == 2 && this.getThrower() != null) {
                list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorAttackable.getInstance());
                list.removeAll(this.alreadyHitEntity);
                if (!this.blade.func_190926_b()) {
                    NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
                    for (Entity curEntity : list) {
                        if (!(curEntity instanceof EntityLivingBase)) continue;
                        int stanTicks = 40;
                        if (!curEntity.field_70170_p.field_72995_K) {
                            ((EntityLivingBase)curEntity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, stanTicks, 30, true, false));
                        }
                        StunManager.setStun((EntityLivingBase)curEntity, stanTicks);
                        StunManager.setFreeze((EntityLivingBase)curEntity, stanTicks);
                        for (int i = 0; i < 5; ++i) {
                            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, curEntity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)curEntity.field_70130_N, curEntity.field_70163_u + this.field_70146_Z.nextDouble() * (double)curEntity.field_70131_O - 0.25, curEntity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)curEntity.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                        }
                    }
                }
            }
            if (this.field_70173_aa == 25 && this.getThrower() != null) {
                list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorAttackable.getInstance());
                list.removeAll(this.alreadyHitEntity);
                StylishRankManager.setNextAttackType(this.getThrower(), StylishRankManager.AttackTypes.JudgmentCut);
                if (!this.blade.func_190926_b()) {
                    NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
                    ItemSlashBlade bladeItem = (ItemSlashBlade)this.blade.func_77973_b();
                    int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)this.blade);
                    float magicDamage = 1.0f + ItemSlashBlade.AttackAmplifier.get(tag).floatValue() * ((float)level / 5.0f);
                    for (Entity curEntity : list) {
                        int i;
                        if (!(this.getThrower() instanceof EntityPlayer)) continue;
                        bladeItem.attackTargetEntity(this.blade, curEntity, (EntityPlayer)this.getThrower(), true);
                        ((EntityPlayer)this.getThrower()).func_71047_c(curEntity);
                        curEntity.field_70172_ad = 0;
                        for (i = 0; i < 5; ++i) {
                            EntityDrive entityDrive = new EntityDrive(this.field_70170_p, (EntityLivingBase)this.getThrower(), Math.min(1.0f, magicDamage), true, 0.0f);
                            float rotationYaw = curEntity.field_70177_z + (float)(60 * i) + (entityDrive.getRand().nextFloat() - 0.5f) * 60.0f;
                            float rotationPitch = (entityDrive.getRand().nextFloat() - 0.5f) * 60.0f;
                            float fYawDtoR = rotationYaw / 180.0f * (float)Math.PI;
                            float fPitDtoR = rotationPitch / 180.0f * (float)Math.PI;
                            float fYVecOfst = 0.5f;
                            float motionX = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst * 2.0f;
                            float motionY = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
                            float motionZ = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst * 2.0f;
                            entityDrive.func_70012_b(curEntity.field_70165_t - (double)motionX, curEntity.field_70163_u + (double)curEntity.func_70047_e() / 2.0 - (double)motionY, curEntity.field_70161_v - (double)motionZ, rotationYaw, rotationPitch);
                            entityDrive.setDriveVector(fYVecOfst);
                            entityDrive.setLifeTime(8);
                            entityDrive.setIsMultiHit(false);
                            int rank = StylishRankManager.getStylishRank(this.getThrower());
                            if (5 <= rank) {
                                EnumSet<ItemSlashBlade.SwordType> type = bladeItem.getSwordType(this.blade);
                                entityDrive.setIsSlashDimension(type.contains((Object)ItemSlashBlade.SwordType.FiercerEdge));
                            }
                            entityDrive.setRoll(90.0f + 120.0f * (entityDrive.getRand().nextFloat() - 0.5f));
                            if (entityDrive == null) continue;
                            this.field_70170_p.func_72838_d((Entity)entityDrive);
                        }
                        if (curEntity.field_70170_p.field_72995_K) continue;
                        for (i = 0; i < 2; ++i) {
                            EntitySlashDimension dim = new EntitySlashDimension(curEntity.field_70170_p, (EntityLivingBase)this.getThrower(), 1.0f);
                            if (dim == null) continue;
                            dim.func_70107_b(curEntity.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * 5.0, curEntity.field_70163_u + (double)(curEntity.field_70131_O * this.field_70146_Z.nextFloat()), curEntity.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * 5.0);
                            dim.setLifeTime(10 + i * 3);
                            dim.setIsSlashDimension(true);
                            curEntity.field_70170_p.func_72838_d((Entity)dim);
                        }
                    }
                }
            }
        }
        if (this.field_70173_aa >= 30) {
            if (!this.blade.func_190926_b()) {
                NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
                ItemSlashBlade bladeItem = (ItemSlashBlade)this.blade.func_77973_b();
                ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.Battou);
                if (this.getThrower() != null && this.getThrower() instanceof EntityPlayer) {
                    bladeItem.doSwingItem(this.blade, (EntityLivingBase)((EntityPlayer)this.getThrower()));
                }
                this.blade.func_77964_b(this.blade.func_77958_k() / 2);
            }
            this.alreadyHitEntity.clear();
            this.alreadyHitEntity = null;
            this.func_70106_y();
        }
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void func_70091_d(MoverType moverType, double par1, double par3, double par5) {
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f1 = super.func_70013_c(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_181015_d(BlockPos p_181015_1_) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public Entity getThrower() {
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        this.thrower = entity;
    }
}

