/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityLumberManager
extends Entity {
    private static final DataParameter<Integer> LIFETIME = EntityDataManager.func_187226_a(EntityLumberManager.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityLumberManager.class, (DataSerializer)DataSerializers.field_187203_m);
    Deque<BlockPos> harvestTargets = Queues.newLinkedBlockingDeque((int)50);
    BlockPos root = null;
    Block targetBlock = null;
    static final List<BlockPos> checkOffsets = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)new BlockPos(1, 0, 1), (BlockPos)new BlockPos(-1, 0, -1)));
    static final List<BlockPos> checkOffsetsUpper = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)new BlockPos(1, 1, 1), (BlockPos)new BlockPos(-1, 1, -1)));

    public EntityLumberManager(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityLumberManager(World worldIn, Block target) {
        this(worldIn);
        this.targetBlock = target;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(LIFETIME, (Object)20);
        this.func_184212_Q().func_187214_a(OWNER, (Object)Optional.absent());
    }

    public int getLifeTime() {
        return (Integer)this.func_184212_Q().func_187225_a(LIFETIME);
    }

    public void setLifeTime(int lifetime) {
        this.func_184212_Q().func_187227_b(LIFETIME, (Object)lifetime);
    }

    public Optional<EntityPlayer> getOwner() {
        Optional owner = (Optional)this.func_184212_Q().func_187225_a(OWNER);
        return owner.isPresent() ? Optional.fromNullable((Object)this.field_70170_p.func_152378_a((UUID)owner.get())) : Optional.absent();
    }

    public void setOwner(EntityPlayer owner) {
        this.func_184212_Q().func_187227_b(OWNER, (Object)(owner != null ? Optional.of((Object)owner.func_110124_au()) : Optional.absent()));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
        this.setLifeTime(compound.func_74762_e("lifetime"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
        compound.func_74768_a("lifetime", this.getLifeTime());
    }

    protected void func_70018_K() {
        super.func_70018_K();
        this.func_70076_C();
    }

    private boolean validTarget(BlockPos target) {
        IBlockState state = this.field_70170_p.func_180495_p(target);
        if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, target)) {
            return false;
        }
        Block block = state.func_177230_c();
        if (block.isWood((IBlockAccess)this.field_70170_p, target)) {
            if (this.targetBlock != block) {
                return false;
            }
            BlockPos under = target.func_177971_a(EnumFacing.DOWN.func_176730_m());
            IBlockState underState = this.field_70170_p.func_180495_p(under);
            boolean canHarvest = false;
            canHarvest |= underState.func_177230_c().isAir(underState, (IBlockAccess)this.field_70170_p, under);
            canHarvest |= underState.func_177230_c().isLeaves(underState, (IBlockAccess)this.field_70170_p, under);
            if (!(canHarvest |= underState.func_177230_c().isWood((IBlockAccess)this.field_70170_p, under))) {
                return false;
            }
        } else if (block.isLeaves(state, (IBlockAccess)this.field_70170_p, target)) {
            BlockHarvestDropsEventHandler.captureDrops(true);
            block.beginLeavesDecay(state, this.field_70170_p, target);
            block.func_180650_b(this.field_70170_p, target, state, this.field_70146_Z);
            List<ItemStack> drops = BlockHarvestDropsEventHandler.captureDrops(false);
            for (ItemStack item : drops) {
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.root, (ItemStack)item);
            }
            if (!state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, target)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void func_70071_h_() {
        Optional<EntityPlayer> player;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!(this.field_70170_p.field_72995_K || this.getLifeTime() >= this.field_70173_aa && this.getOwner().isPresent())) {
            this.func_70076_C();
            return;
        }
        if (this.targetBlock == null) {
            this.func_70076_C();
            return;
        }
        if (this.root == null) {
            this.root = this.func_180425_c();
        }
        if ((player = this.getOwner()).isPresent() && player.get() instanceof EntityPlayerMP) {
            EntityPlayerMP playerMp = (EntityPlayerMP)player.get();
            if (playerMp.func_184614_ca().func_190926_b() || !(playerMp.func_184614_ca().func_77973_b() instanceof ItemSlashBlade)) {
                this.func_70076_C();
                return;
            }
            boolean harvested = false;
            int stackCounter = 0;
            do {
                BlockPos currentPos;
                BlockPos pos;
                if ((pos = this.harvestTargets.pollFirst()) == null) {
                    pos = this.root;
                }
                this.harvestTargets.offerLast(pos);
                PlayerInteractionManager im = playerMp.field_71134_c;
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block.isWood((IBlockAccess)this.field_70170_p, pos)) {
                    BlockHarvestDropsEventHandler.captureDrops(true);
                    harvested |= im.func_180237_b(pos);
                    List<ItemStack> drops = BlockHarvestDropsEventHandler.captureDrops(false);
                    for (ItemStack item : drops) {
                        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.root, (ItemStack)item);
                    }
                } else if (block.isLeaves(state, (IBlockAccess)this.field_70170_p, pos)) {
                    BlockHarvestDropsEventHandler.captureDrops(true);
                    block.beginLeavesDecay(state, this.field_70170_p, pos);
                    block.func_180650_b(this.field_70170_p, pos, state, this.field_70146_Z);
                    List<ItemStack> drops = BlockHarvestDropsEventHandler.captureDrops(false);
                    harvested |= 0 < drops.size();
                    for (ItemStack item : drops) {
                        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.root, (ItemStack)item);
                    }
                }
                boolean isFull = false;
                Iterator<BlockPos> itrOffset = checkOffsets.iterator();
                do {
                    if (!this.validTarget(currentPos = pos.func_177971_a((Vec3i)itrOffset.next())) || this.harvestTargets.contains(currentPos)) continue;
                    isFull |= !this.harvestTargets.offerFirst(currentPos);
                } while (!isFull && itrOffset.hasNext());
                itrOffset = checkOffsetsUpper.iterator();
                do {
                    if (!this.validTarget(currentPos = pos.func_177971_a((Vec3i)itrOffset.next())) || this.harvestTargets.contains(currentPos)) continue;
                    isFull |= !this.harvestTargets.offerFirst(currentPos);
                } while (!isFull && itrOffset.hasNext());
                if (isFull) continue;
                this.harvestTargets.pollLast();
            } while (!harvested && !this.harvestTargets.isEmpty() && stackCounter++ < 30);
            if (30 <= stackCounter) {
                this.func_70076_C();
            }
        }
        if (this.harvestTargets.isEmpty()) {
            this.func_70076_C();
        }
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public static class BlockHarvestDropsEventHandler {
        public static boolean fastLeavesDecay = false;
        protected static ThreadLocal<Boolean> captureDrops = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        protected static ThreadLocal<List<ItemStack>> capturedDrops = new ThreadLocal<List<ItemStack>>(){

            @Override
            protected List<ItemStack> initialValue() {
                return new ArrayList<ItemStack>();
            }
        };

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onBlockHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
            IBlockState state = event.getState();
            Block block = state.func_177230_c();
            World world = event.getWorld();
            BlockPos root = event.getPos();
            if (fastLeavesDecay && block.isLeaves(state, (IBlockAccess)world, root)) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos pos = root.func_177972_a(facing);
                    world.func_180497_b(pos, block, block.func_149738_a(world) + world.field_73012_v.nextInt(10), 1);
                }
            }
            if (captureDrops.get().booleanValue()) {
                List drops = event.getDrops();
                float chance = event.getDropChance();
                for (ItemStack stack : drops) {
                    if (!(world.field_73012_v.nextFloat() < chance)) continue;
                    capturedDrops.get().add(stack);
                }
                drops.clear();
            }
        }

        public static List<ItemStack> captureDrops(boolean start) {
            if (start) {
                captureDrops.set(true);
                capturedDrops.get().clear();
                return null;
            }
            captureDrops.set(false);
            return capturedDrops.get();
        }
    }
}

